// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Maya/MayaSceneExport/hctMayaSceneExport.h>
#include <ContentTools/Maya/MayaSceneExport/Nodes/Decomposition/hctDecompositionNode.h>
#include <ContentTools/Maya/MayaSceneExport/Utilities/hctUtilities.h>

MObject hctDecompositionNode::m_matrix;
MObject hctDecompositionNode::m_translation;
MObject hctDecompositionNode::m_rotation;
MObject hctDecompositionNode::m_scale;
MObject hctDecompositionNode::m_scaleAndSkew;
MObject hctDecompositionNode::m_skew;


MStatus hctDecompositionNode::initialize()
{
    MStatus status = MStatus::kSuccess;

    MFnMatrixAttribute  matrixFn;
    MFnUnitAttribute    unitFn;
    MFnNumericAttribute numFn;

    m_matrix = matrixFn.create( "matrix", "mat" );
    addAttribute( m_matrix );

    MObject transX = unitFn.create( "translationX", "transX", MFnUnitAttribute::kDistance );
    MObject transY = unitFn.create( "translationY", "transY", MFnUnitAttribute::kDistance );
    MObject transZ = unitFn.create( "translationZ", "transZ", MFnUnitAttribute::kDistance );
    m_translation = numFn.create( "translation", "trans", transX, transY, transZ );
    addAttribute( m_translation );

    MObject rotX = unitFn.create( "rotationX", "rotX", MFnUnitAttribute::kAngle );
    MObject rotY = unitFn.create( "rotationY", "rotY", MFnUnitAttribute::kAngle );
    MObject rotZ = unitFn.create( "rotationZ", "rotZ", MFnUnitAttribute::kAngle );
    m_rotation = numFn.create( "rotation", "rot", rotX, rotY, rotZ );
    addAttribute( m_rotation );

    MObject scaleX = unitFn.create( "scaleX", "scX", MFnUnitAttribute::kDistance, 1.0 );
    MObject scaleY = unitFn.create( "scaleY", "scY", MFnUnitAttribute::kDistance, 1.0 );
    MObject scaleZ = unitFn.create( "scaleZ", "scZ", MFnUnitAttribute::kDistance, 1.0 );
    m_scale = numFn.create( "scale", "sc", scaleX, scaleY, scaleZ );
    addAttribute( m_scale );

    m_scaleAndSkew = matrixFn.create( "scaleAndSkew", "sas" );
    addAttribute( m_scaleAndSkew );

    m_skew = matrixFn.create( "skew", "sk" );
    addAttribute( m_skew );

    attributeAffects( m_matrix, m_translation );
    attributeAffects( m_matrix, m_rotation );
    attributeAffects( m_matrix, m_scale );
    attributeAffects( m_matrix, m_scaleAndSkew );
    attributeAffects( m_matrix, m_skew );

    return status;
}


MStatus hctDecompositionNode::compute( const MPlug& plug, MDataBlock& data )
{
    const MMatrix& matrix = data.inputValue( m_matrix ).asMatrix();

    hctUtilities::Decomposition decomp;
    hctUtilities::decomposeMatrix( matrix, decomp );

    // Rotation is outputted as Euler angles
    MEulerRotation rot = decomp.m_rotation.asEulerRotation();
    data.outputValue( m_rotation ).set( rot.x, rot.y, rot.z );

    // Others are a straight copy
    data.outputValue( m_translation ).set( decomp.m_translation );
    data.outputValue( m_scale ).set( decomp.m_scale );
    data.outputValue( m_scaleAndSkew ).set( decomp.m_scaleAndSkew );
    data.outputValue( m_skew ).set( decomp.m_skew );

    data.setClean( plug );
    return MStatus::kSuccess;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
