// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Maya/MayaSceneExport/Nodes/hctLocatorNode.h>
#include <ContentTools/Maya/MayaSceneExport/Utilities/hctManipContainer.h>


// Base abstract constraint node
class hctConstraintNode : public hctLocatorNode
{
protected:

    static MStatus initialize( MString hkType, MTypeId typeId, bool hasRotations = true );

    hctConstraintNode() {}
    virtual ~hctConstraintNode() {}

    // Supervise connections (ie. to the parent node)
    virtual MStatus legalConnection( const MPlug& plug, const MPlug& otherPlug, bool asSrc, bool& result ) const;

    // Draw methods - first is inherited from API, second is for easier derivation
    virtual void draw( M3dView& view, const MDagPath& path, M3dView::DisplayStyle style, M3dView::DisplayStatus displayStatus );
    virtual void draw( const MMatrix& childSpaceToWorld, const MMatrix& parentSpaceToWorld, bool wireframe ) const;

public:

    // Utilities
    enum SpaceType
    {
        SPACE_INVALID,
        SPACE_PARENT_NODE,
        SPACE_PARENT,
        SPACE_CHILD
    };
    static void getParentNode( const MObject& node, MDagPath& parentOut );
    static void getSpaceInWorld( const MObject& node, SpaceType space, MMatrix& spaceToWorldOut );

    // this is kept to adjust the scaling of the prismatic constraint display
    // (so that the length of the drawn prism is independent of  MFnManip3D::globalSize() )
    MMatrix m_parentScale;

    // Common display type
    static DisplayType m_displayType;

    //
    // Attributes
    //

    // Group name
    static MObject m_hkType;

    // Parent node
    static MObject m_parentNode;
    static MObject m_parentNodeLast;

    // Constraint spaces
    static MObject m_childTranslationLocked;
    static MObject m_childTranslation;
    static MObject m_childRotationLocked;
    static MObject m_childRotation;
    static MObject m_parentTranslationLocked;
    static MObject m_parentTranslation;
    static MObject m_parentRotationLocked;
    static MObject m_parentRotation;

    // Breakable
    static MObject m_isBreakable;
    static MObject m_breakThreshold;
};


// Base constraint manipulator container
class hctConstraintManip : public hctManipContainer
{
protected:

    enum
    {
        MANIP_CHILD_TRANSLATION,
        MANIP_CHILD_ROTATION,
        MANIP_PARENT_TRANSLATION,
        MANIP_PARENT_ROTATION
    };

    virtual const ManipDesc* getManipulatorDesc( int id ) const;
    virtual MMatrix getManipulatorBaseTransform( int id ) const;
    virtual bool getManipulatorVisibility( int id ) const;
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
