// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Maya/MayaSceneExport/hctMayaSceneExport.h>
#include <ContentTools/Maya/MayaSceneExport/Nodes/Constraints/StiffSpring/hctStiffSpringConstraintNode.h>

#include <ContentTools/Maya/MayaSceneExport/Utilities/hctUtilities.h>

// Attributes
MObject hctStiffSpringConstraintNode::m_hasRestLength;
MObject hctStiffSpringConstraintNode::m_restLength;


MStatus hctStiffSpringConstraintNode::initialize()
{
    // Initialize the base class
    MStatus status = hctConstraintNode::initialize( "hkStiffSpringConstraint", typeId(), false );
    if( status != MStatus::kSuccess )
    {
        return status;
    }

    MFnNumericAttribute numFn;
    MFnUnitAttribute    unitFn;

    // Add additional attributes
    m_hasRestLength = numFn.create( "changeRestLength", "crl", MFnNumericData::kBoolean, 0 );
    numFn.setKeyable( true );
    addAttribute( m_hasRestLength );

    m_restLength = unitFn.create( "restLength", "rl", MFnUnitAttribute::kDistance, 1.0 );
    unitFn.setMin( 0 );
    unitFn.setKeyable( true );
    addAttribute( m_restLength );

    // Unlock parent translation by default
    numFn.setObject( m_parentTranslationLocked );
    numFn.setDefault( false );

    return status;
}


void hctStiffSpringConstraintNode::draw( const MMatrix& childSpaceToWorld, const MMatrix& parentSpaceToWorld, bool ) const
{
    // Get attribute values
    bool hasRestLength;
    double restLength;
    {
        MFnDependencyNode nodeFn( thisMObject() );
        nodeFn.findPlug( m_hasRestLength ).getValue( hasRestLength );
        nodeFn.findPlug( m_restLength ).getValue( restLength );
    }

    // Get positions
    MVector childPos( childSpaceToWorld[3] );
    MVector parentPos( parentSpaceToWorld[3] );
    MVector childRestPos;
    MVector parentRestPos;
    {
        if( !hasRestLength )
        {
            restLength = ( parentPos - childPos ).length();
        }
        MVector center = ( parentPos + childPos ) * 0.5;
        MVector dir = (childPos == parentPos)? MVector::zAxis: ( parentPos - childPos ).normal();
        childRestPos = center - ( dir * restLength * 0.5 );
        parentRestPos = center + ( dir * restLength * 0.5 );
    }

    // Get colors
    MColor childColor( hctUtilities::getColor( "ConstraintChildSpace" ) );
    MColor parentColor( hctUtilities::getColor( "ConstraintParentSpace" ) );
    MColor volumeColor( hctUtilities::getColor( "ConstraintVolume" ) );
    volumeColor.a = 0.5f;

    // Set up OpenGL
    glPushAttrib( GL_CURRENT_BIT | GL_ENABLE_BIT | GL_LINE_BIT | GL_POINT_BIT );
    glEnable( GL_POINT_SMOOTH );    glHint( GL_POINT_SMOOTH_HINT, GL_NICEST );
    glEnable( GL_LINE_SMOOTH );     glHint( GL_LINE_SMOOTH_HINT, GL_NICEST );
    glEnable( GL_BLEND );           glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );
    glShadeModel( GL_SMOOTH );

    // Draw the rod
    glLineWidth( 2.0f );
    glBegin( GL_LINES );
    glColor4fv( &parentColor.r );
    glVertex3dv( &parentPos.x );
    glColor4fv( &childColor.r );
    glVertex3dv( &childPos.x );
    glEnd();

    // Draw the rest length
    glLineWidth( hasRestLength? 10.0f: 6.0f );
    glColor4fv( &volumeColor.r );
    glBegin( GL_LINES );
    glVertex3dv( &childRestPos.x );
    glVertex3dv( &parentRestPos.x );
    glEnd();

    // Draw the spaces
    glPointSize( 8.0f );
    glBegin( GL_POINTS );
    glColor4fv( &parentColor.r );
    glVertex3dv( &parentPos.x );
    glColor4fv( &childColor.r );
    glVertex3dv( &childPos.x );
    glEnd();

    glPopAttrib();
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
