// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Maya/MayaSceneExport/Nodes/Constraints/hctConstraintNode.h>


// Rag Doll constraint node
class hctRagDollConstraintNode : public hctConstraintNode
{
public:

    HK_DECLARE_MAYA_NODE( hctRagDollConstraintNode, "hkNodeRagDollConstraint", hkNodeRagDollConstraintID );
    static MStatus initialize();

    // From hctConstraintNode
    virtual void draw( const MMatrix& childSpaceToWorld, const MMatrix& parentSpaceToWorld, bool wireframe ) const;

    // Returns the twist between the two spaces in a rag doll constraint. Replicates the behaviour at run-time.
    static float getTwist( const MMatrix& parentSpaceWorld, const MMatrix& childSpaceWorld );

    // Drawing utilities
    static void drawVolume( float inclusiveAngle, float upperExclusiveAngle, float lowerExclusiveAngle, bool wireframe );
    static void drawQuadrantSurface( float inclusiveAngle, float exclusiveAngle );
    static void drawQuadrantSides( float inclusiveAngle, float exclusiveAngle );
    static void drawQuadrantEdges( float inclusiveAngle, float exclusiveAngle );

    // Attributes
    static MObject m_coneAngle;
    static MObject m_planeAngleMin;
    static MObject m_planeAngleMax;
    static MObject m_twistMin;
    static MObject m_twistMax;
    static MObject m_maxFrictionTorque;
    static MObject m_motorType;
    static MObject m_displayCones;
    static MObject m_displayTwist;
};


// Ragdoll manipulator
class hctRagDollConstraintManip : public hctConstraintManip
{
public:
    HK_DECLARE_MAYA_NODE( hctRagDollConstraintManip, "hkNodeRagDollConstraintManip", hkNodeRagDollConstraintManipID );
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
