// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Maya/MayaSceneExport/Nodes/Constraints/hctConstraintNode.h>


// Prismatic constraint node
class hctPrismaticConstraintNode : public hctConstraintNode
{
public:

    HK_DECLARE_MAYA_NODE( hctPrismaticConstraintNode, "hkNodePrismaticConstraint", hkNodePrismaticConstraintID );
    static MStatus initialize();

    // From hctConstraintNode
    virtual void draw( const MMatrix& childSpaceToWorld, const MMatrix& parentSpaceToWorld, bool wireframe ) const;

    // Drawing utilities
    static void drawAxis();
    static void drawTriangle();
    static void drawVolume( bool isLimitedMin, bool isLimitedMax,
                            float limitMin, float limitMax, bool wireframe );

    // Attributes
    static MObject m_isLimitedMin;
    static MObject m_isLimitedMax;
    static MObject m_limitMin;
    static MObject m_limitMax;
    static MObject m_maxFrictionForce;
    static MObject m_motorType;
};


// Prismatic manipulator
class hctPrismaticConstraintManip : public hctConstraintManip
{
public:
    HK_DECLARE_MAYA_NODE( hctPrismaticConstraintManip, "hkNodePrismaticConstraintManip", hkNodePrismaticConstraintManipID );
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
