// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Maya/MayaSceneExport/hctMayaSceneExport.h>
#include <ContentTools/Maya/MayaSceneExport/Nodes/Constraints/Fixed/hctFixedConstraintNode.h>

// Attributes
MObject hctFixedConstraintNode::m_maxLinearImpulse;
MObject hctFixedConstraintNode::m_maxAngularImpulse;

MStatus hctFixedConstraintNode::initialize()
{
    // Initialize the base class, without rotations
    MStatus status = hctConstraintNode::initialize( "hkFixedConstraint", typeId() );

    // Unlock child translation by default
    MFnNumericAttribute numFn;
    numFn.setObject( m_childTranslationLocked );
    numFn.setDefault( false );

    m_maxLinearImpulse = numFn.create ("maxLinearImpulse", "mli", MFnNumericData::kFloat, 0.0f);
    numFn.setMin(0.0f);
    numFn.setKeyable( true );
    addAttribute(m_maxLinearImpulse);

    m_maxAngularImpulse = numFn.create ("maxAngularImpulse", "mai", MFnNumericData::kFloat, 0.0f);
    numFn.setMin(0.0f);
    numFn.setKeyable( true );
    addAttribute(m_maxAngularImpulse);

    return status;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
