// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Maya/MayaSceneExport/Nodes/hctLocatorNode.h>

#include <vector>


// Node which references (by name) a vertex painting channel in its sibling mesh,
// adding additional scaling and dimension type information. Each instance of this node
// corresponds to one exported vertex float channel in the mesh.
// The node also provides Maya viewport visualization of the vertex painting weights, as
// either spheres or normals.

class hctChannelNode : public hctLocatorNode
{
public:

    HK_DECLARE_MAYA_NODE( hctChannelNode, "hkNodeChannel", hkNodeChannelID );
    static MStatus initialize();

    hctChannelNode();
    virtual ~hctChannelNode();

    virtual void postConstructor();
    virtual bool isTransparent() const;

    // Draw the locator
    virtual void draw( M3dView& view, const MDagPath& path,
                       M3dView::DisplayStyle displayStyle, M3dView::DisplayStatus displayStatus );

    void requestContinualRefresh(bool on);

    enum VisualizationType
    {
        VIZ_RADIUS = 0,
        VIZ_NORMAL_DISTANCE,
        VIZ_INVALID
    };

    struct VertexInfo
    {
        int vIndex;
        double vDist;
    };

    /*
    ** Attributes
    */

    // Group name
    static MObject m_hkType;
    static MObject m_channelName;

    static MObject m_dimensionType;
    static MObject m_visualizationType;
    static MObject m_display;
    static MObject m_opacity;

    static MObject m_rescaleEnable;
    static MObject m_rescaleMin;
    static MObject m_rescaleMax;

private:

    enum
    {
        NGRID = 8,
        NCELL = 512 // must be NGRID^3
    };

    void readAttributes(bool& refreshAll, bool& refreshMainOnly);

    void refreshAll();
    void rebuildAllCellLists();
    void rebuildDirtyCellLists();
    void renderMain();

    bool vertexToCell(int i, int& cell);
    void buildCellList(int cell);
    void findDirtyCells(MIntArray& dirtyCells, const MFloatArray& floatArray);

    bool findMesh();
    bool checkMesh();
    bool refreshGeometry();
    MBoundingBox getMeshBoundingBox();
    void getBoxDims(float* cellDims, MPoint& boxMin, int Ngrid);
    void cacheVertexArray(const MPointArray& vertexArray);
    void cacheNormalArray(const MFloatVectorArray& normalArray);
    void cacheFloatArray(const MFloatArray& floatArray);

    bool extractObjectSpaceGeometry( MPointArray& vertexArray, MFloatVectorArray& normalArray );
    bool extractFloats( MFloatArray& floatArray );

    void beginGL(M3dView& view);
    void endGL(M3dView& view);

    MStatus rebuildSphereDisplayList();
    void drawSphere( const MPoint& p, float radius, const float* color );
    void drawNormal( const MPoint& p, const MFloatVector& n, float dist );
    void buildSphere();

    // Path to the associated mesh
    MDagPath m_meshPath;

    // The currently cached (object space) vertices, normals and corresponding floats of the (mesh, channel)
    MPointArray m_cachedVertexArray;
    MFloatVectorArray m_cachedNormalArray;
    MFloatArray m_cachedFloatArray;

    // Cached object space mesh bounding box
    MBoundingBox m_bbox;

    // Lists of normals associated with each vertex
    struct VertexNormals
    {
        std::vector<int> m_normalIndices;
    };
    std::vector<VertexNormals> m_perVertexNormals;

    // Visualization colors
    enum VizColorTypes
    {
        SPHERE_POSITIVE,
        SPHERE_NEGATIVE,
        PIN_POSITIVE,
        PIN_NEGATIVE
    };
    MFloatVectorArray m_vizColors;
    MStringArray m_vizColorAttributeNames;

    // Indices of the vertices associated with each grid cell
    MIntArray m_cellVertexIndices[NCELL];

    // Cell containing each vertex
    MIntArray m_vertexCellIndices;

    // Main display list
    GLuint m_mainDisplayList;

    // Display list index for each cell
    GLuint m_cellDisplayLists[NCELL];

    // Display list containing sphere geometry
    GLuint m_sphereDisplayList;

    // Activity status of each display list
    bool m_listActive[NCELL];

    // Used to speed up determination of which cells are dirty
    bool m_dirty[NCELL];

    // Current object space (of Node/Mesh) position of camera
    MPoint m_cameraObjPos;

    // Used to render transparent objects in back-to-front order
    std::vector<VertexInfo> m_vertexInfo;

    // Node/Mesh object-to-world matrix, and its inverse
    MMatrix m_cachedObjToWorld;
    MMatrix m_cachedWorldToObj;

    // Cached attribute values
    VisualizationType m_cachedVizTypeEnum;
    MString m_cachedChannelName;
    int m_cachedRescaleEnable;
    float m_cachedMin;
    float m_cachedMax;
    double m_cachedOpacity;
    bool m_cachedDisplayEnable;

    // Flag indicating need to extract mesh geometry again
    bool m_refreshGeometry;

    // Flag indicating state in which we update mesh geometry and regenerate visualization every frame (e.g. during animation)
    bool m_refreshAllContinually;

    MCallbackId m_animationPlaybackCallbackId;
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
