// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

// Capsule node: outputs a mesh based on a set of attribute values
class hctCapsuleNode : public MPxNode
{
public:

    HK_DECLARE_MAYA_NODE( hctCapsuleNode, "hkNodeCapsule", hkNodeCapsuleID );
    static MStatus initialize();

    virtual void postConstructor();
    virtual MStatus compute( const MPlug& plug, MDataBlock& data );

private:

    //
    // Attributes
    //

    // Note: Local space of generated capsule is centered on the halfway point between the spheres.
    //       The specified axis is directed from the start sphere to the end sphere.

    static MObject m_radius; // radius of 'start sphere'
    static MObject m_height;
    static MObject m_taper;  // radius of 'end sphere' is m_radius * m_taper

    static MObject m_axis;

    // Output
    static MObject m_outputMesh;
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
