// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Maya/MayaSceneExport/hctMayaSceneExport.h>

#include <Common/GeometryUtilities/Mesh/hkMeshBody.h>
#include <Common/GeometryUtilities/Mesh/Utils/MeshSectionLockSet/hkMeshSectionLockSet.h>

#include <ContentTools/Common/SceneExport/Importer/MeshImport/hctModelerMeshBuilder.h>
#include <ContentTools/Common/SceneExport/Importer/MeshImport/hctMeshImportUtilities.h>
#include <ContentTools/Maya/MayaSceneExport/Importer/MeshImport/hctMayaMeshBuilder.h>

#include <ContentTools/Maya/MayaSceneExport/Importer/MeshImport/hctMayaMeshImport.h>


MObject hctMayaSceneConvertUtilities::createNodeFromMesh(hkxScene*         sceneGraph,
                                                         const hkMeshBody& meshBody,
                                                         MObject&          parentNode,
                                                         MDagModifier&     dagMod,
                                                         const char*       childNodeName,
                                                         const char*       meshNodeName,
                                                         bool              forceUseOfRotatePivot)
{
    hkMeshSectionLockSet lockSet;
    int numSections = hctModelerMeshBuilderUtilities::prepareMeshSectionLockSet(meshBody, &lockSet);

    hkMatrix4 transform;
    meshBody.getTransform(transform);

    if ( (numSections == 0) || (!transform.isOk()) )
    {
        return MObject::kNullObj;
    }

    // NB, the following mesh creation/connection is not done using MDagModifier, but that's OK since on undoing,
    // the transform containing the mesh is deleted, effectively undoing the creation and connection.
    // create a mesh parented to this transform
    MFnMesh meshFn;

    // Setup the virtual modeler interface.
    hctMayaMeshBuilder mayaMeshBuilder(meshBody, meshFn, dagMod, meshNodeName, transform, parentNode, forceUseOfRotatePivot, childNodeName, sceneGraph);

    // This loop will basically only create non-existent Shading Groups.
    {
        for (int sectionIndex = 0; sectionIndex < numSections; sectionIndex++)
        {
            const hkMeshSection& meshSection = lockSet.getSection(sectionIndex);
            const char* materialName = meshSection.m_material ? meshSection.m_material->getName() : HK_NULL;
            mayaMeshBuilder.registerMaterial(materialName);
        }
    }

    // Do the actual mesh conversion.
    hkResult res = hctModelerMeshBuilderUtilities::convertHavokMeshToModelerNode(meshBody, lockSet, mayaMeshBuilder);
    if ( res.isFailure() )
    {
        return MObject::kNullObj;
    }

    return mayaMeshBuilder.m_transformNode;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
