// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#pragma once


#include <maya/MDagModifier.h>

#include <Common/GeometryUtilities/Mesh/hkMeshBody.h>

#include <ContentTools/Common/SceneExport/Error/hctSceneExportError.h>

#include <ContentTools/Common/SceneExport/Importer/MeshImport/hctModelerMeshBuilder.h>


/// The Maya-specific implementation of the abstract modeler mesh builder interface.
class hctMayaMeshBuilder : public hctModelerMeshBuilder
{
    public:

        hctMayaMeshBuilder(const hkMeshBody& meshBody, MFnMesh& meshFn, MDagModifier& dagMod, const char* meshName, hkMatrix4& transform, MObject& parentNode, bool forceUseOfRotatePivot, const char* nodeName, hkxScene* sceneGraph);

        /// This function needs to be called before the respective material can be assigned to a triangle.
        void                registerMaterial(const char* materialName);

        //
        // Implementation of hctModelerMeshBuilder interface.
        //

        virtual VertexId    addMeshVertexDelayed(const hkVector4& position);
        virtual int         addMeshTriangleDelayed(VertexId positionIndex0, VertexId positionIndex1, VertexId positionIndex2);
        virtual void        realizeDelayedMesh();

        virtual void        selectColorChannel(int channel);

        virtual ColorId     addVertexColorImmediate(float r, float g, float b);
        virtual ColorId     addVertexColorDelayed  (float r, float g, float b);
        virtual void        realizeDelayedVertexColors();

        virtual int         addVertexColorTriangleImmediate(int triangleIndex, ColorId colorIndexVertex0, ColorId colorIndexVertex1, ColorId colorIndexVertex2);
        virtual int         addVertexColorTriangleDelayed                     (ColorId colorIndexVertex0, ColorId colorIndexVertex1, ColorId colorIndexVertex2);
        virtual void        realizeDelayedVertexColorTriangles();

        virtual void        selectUvChannel(int channel);

        virtual UvId        addVertexUvImmediate(float u, float v);
        virtual UvId        addVertexUvDelayed  (float u, float v);
        virtual void        realizeDelayedVertexUvs();

        virtual int         addVertexUvTriangleImmediate(int triangleIndex, UvId uvIndexVertex0, UvId uvIndexVertex1, UvId uvIndexVertex2);
        virtual int         addVertexUvTriangleDelayed                     (UvId uvIndexVertex0, UvId uvIndexVertex1, UvId uvIndexVertex2);
        virtual void        realizeDelayedVertexUvTriangles();

        virtual NormalId    addNormalDelayed(const hkVector4& normal);
        virtual int         addNormalTriangleDelayed(NormalId triangleVertex0, NormalId triangleVertex1, NormalId triangleVertex2);
        virtual void        realizeDelayedNormals();

        virtual void        setTriangleMaterialImmediate(int triangleIndex, const char* materialName);
        virtual void        setTriangleMaterialDelayed  (int triangleIndex, const char* materialName);
        virtual void        realizeDelayedTriangleMaterials();

    public:

        MObject m_transformNode;

    protected:

        struct MaterialMap
        {
            const char* m_materialName;
            MIntArray   m_triangleIndicesArray;
        };

    protected:

        hkxScene*               m_sceneGraph;
        MFnMesh&                m_meshFn;
        const char*             m_meshName;
        bool                    m_reverseEffectOfRotatePivot;
        MPoint                  m_rotatePivotOffset;
        MObject&                m_parentNode;
        MDagModifier&           m_dagMod;
        const hkMeshBody&       m_meshBody;
        MPointArray             m_vertices;
        MIntArray               m_triangles;
        MString                 m_colorSet;
        MStringArray            m_parentColorSets;
        MColorArray             m_vertexColors;
        MIntArray               m_vertexColorTriangles;
        MString                 m_uvSet;
        MStringArray            m_parentUvSets;
        MFloatArray             m_uValues;
        MFloatArray             m_vValues;
        MIntArray               m_vertexUvTriangles;
        MVectorArray            m_normals;
        MVectorArray            m_triangleVertexNormals;
        hkArray<MaterialMap>    m_materialMap;
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
