// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Maya/MayaSceneExport/hctMayaSceneExport.h>

#include <ContentTools/Maya/MayaSceneExport/Utilities/hctUtilities.h>

// this
#include <ContentTools/Maya/MayaSceneExport/Gizmos/hctSimpleGizmos.h>

/*static*/ void hctSimpleGizmos::drawPlane( const MTransformationMatrix& localToWorld, bool wireframe )
{
    // Draws a basic plane
    glPushAttrib( GL_ENABLE_BIT | GL_POLYGON_BIT | GL_LIGHTING_BIT | GL_DEPTH_BUFFER_BIT );

    glEnable( GL_POINT_SMOOTH );    glHint( GL_POINT_SMOOTH_HINT, GL_NICEST );
    glEnable( GL_LINE_SMOOTH );     glHint( GL_LINE_SMOOTH_HINT, GL_NICEST );
    glEnable( GL_BLEND );           glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );
    glShadeModel( GL_SMOOTH );

    MColor color( hctUtilities::getColor( "PlaneGizmo" ) );
    color.a = 0.5;
    glColor4fv( &color.r );

    glPushMatrix();
    glMultMatrixd(&(localToWorld.asMatrix().matrix[0][0]));

    if (wireframe)
    {
        glEnable( GL_LINE_STIPPLE );
        glLineWidth( 2.0f );
        glLineStipple( 4, 0xAAAA );
        glBegin( GL_LINE_LOOP );
    }
    else
    {
        glBegin( GL_QUADS );
        glNormal3f( 0.0f, 0.0f, 1.0f );
    }

    glVertex3f( -1.0f, 1.0f, 0.0f );
    glVertex3f( -1.0f, -1.0f, 0.0f );
    glVertex3f( 1.0f, -1.0f, 0.0f );
    glVertex3f( 1.0f, 1.0f, 0.0f );
    glEnd();

    glPopMatrix();

    glPopAttrib();
}

/*static*/ void hctSimpleGizmos::drawArrow( const MTransformationMatrix& localToWorld, bool wireframe )
{
    // Draws a basic plane
    glPushAttrib( GL_ENABLE_BIT | GL_POLYGON_BIT | GL_LIGHTING_BIT | GL_DEPTH_BUFFER_BIT );

    glEnable( GL_POINT_SMOOTH );    glHint( GL_POINT_SMOOTH_HINT, GL_NICEST );
    glEnable( GL_LINE_SMOOTH );     glHint( GL_LINE_SMOOTH_HINT, GL_NICEST );
    glEnable( GL_BLEND );           glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );
    glShadeModel( GL_SMOOTH );

    MColor color( hctUtilities::getColor( "ArrowGizmo" ) );
    color.a = 0.5;
    glColor4fv( &color.r );

    glPushMatrix();
    glMultMatrixd(&(localToWorld.asMatrix().matrix[0][0]));

    float t = 0.03f;
    float t2 = 0.09f;

    float l = .8f;
    float l2 = .7f;
    float l3 = 1.0f;
    if (wireframe)
    {
        glEnable( GL_LINE_STIPPLE );
        glLineWidth( 2.0f );
        glLineStipple( 4, 0xAAAA );
        glBegin( GL_LINES );

        // shaft
        glVertex3f(-t, 0.0f, 0.0f);
        glVertex3f(-t, 0.0f, l);
        glVertex3f( t, 0.0f, 0.0f);
        glVertex3f( t, 0.0f, l);
        glVertex3f(0.0f, -t, 0.0f);
        glVertex3f(0.0f, -t, l);
        glVertex3f(0.0f,  t, 0.0f);
        glVertex3f(0.0f,  t, l);

        // head
        glVertex3f(-t2, 0.0f,   l2);
        glVertex3f( 0.0f, 0.0f, l3);
        glVertex3f( t2, 0.0f,   l2);
        glVertex3f( 0.0f, 0.0f, l3);
        glVertex3f(0.0f, -t2,   l2);
        glVertex3f(0.0f,  0.0f, l3);
        glVertex3f(0.0f,  t2,   l2);
        glVertex3f(0.0f,  0.0f, l3);

        glEnd();
    }
    else
    {
        hctUtilities::drawCylinder( t, l, 8 );
        glTranslatef( 0.0f, 0.0f, l );
        hctUtilities::drawCone( t2, l3-l, 8 );
    }

    glPopMatrix();

    glPopAttrib();
}

/*static*/ void hctSimpleGizmos::drawSphere(const MTransformationMatrix& localToWorld, float radius, bool wireframe)
{
    glPushAttrib( GL_ENABLE_BIT | GL_POLYGON_BIT | GL_LIGHTING_BIT | GL_DEPTH_BUFFER_BIT );

    glEnable( GL_POINT_SMOOTH );    glHint( GL_POINT_SMOOTH_HINT, GL_NICEST );
    glEnable( GL_LINE_SMOOTH );     glHint( GL_LINE_SMOOTH_HINT, GL_NICEST );
    glEnable( GL_BLEND );           glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );
    glShadeModel( GL_SMOOTH );

    MColor color( hctUtilities::getColor( "SphereGizmo" ) );
    color.a = 0.5;
    glColor4fv( &color.r );

    glPushMatrix();
    glMultMatrixd(&(localToWorld.asMatrix().matrix[0][0]));

    int numTheta = 16;
    int numPhi = 32;
    if (wireframe)
    {
        numTheta = 32;
        numPhi = 5;
    }

    // Create the points
    MPointArray points( numTheta * numPhi );
    MPointArray equator( 2 * numTheta );

    for( int i=0; i<numTheta; ++i )
    {
        const float theta = float(i) * PI/float(numTheta-1);
        for( int j=0; j<numPhi; ++j )
        {
            float phi = float(j) * 2.0f * PI/float(numPhi-1);
            MPoint& point = points[ i*numPhi + j ];
            point.x = radius * cos(phi) * sin(theta);
            point.y = radius * sin(phi) * sin(theta);
            point.z = radius * cos(theta);
        }
    }

    for( int i=0; i<numTheta; ++i )
    {
        const float theta = PI/2.0f;
        float phi = float(i) * PI/float(numTheta-1);
        MPoint& point = equator[ i ];
        point.x = radius * cos(phi) * sin(theta);
        point.y = radius * sin(phi) * sin(theta);
        point.z = radius * cos(theta);
    }

    for( int i=0; i<numTheta; ++i )
    {
        const float theta = 3.0f*PI/2.0f;
        float phi = float(i) * PI/float(numTheta-1);
        MPoint& point = equator[ i+numTheta ];
        point.x = radius * cos(phi) * sin(theta);
        point.y = radius * sin(phi) * sin(theta);
        point.z = radius * cos(theta);
    }

    if (wireframe)
    {
        //meridians
        for( int j=1; j<numPhi; ++j )
        {
            glBegin( GL_LINE_STRIP );
            glVertex3f( 0.0f, 0.0f, radius );
            for( int i=1; i<numTheta-1; ++i )
            {
                glVertex3dv( &points[ i*numPhi + j-1 ].x );
            }
            glVertex3f( 0.0f, 0.0f, -radius );
            glEnd();
        }

        //equator
        glBegin( GL_LINE_STRIP );
        glVertex3f( radius, 0.0f, 0.0f );
        for( int i=1; i<2*numTheta; ++i )
        {
            glVertex3dv( &equator[ i ].x );
        }
        glEnd();
    }

    else
    {
        for( int j=1; j<numPhi; ++j )
        {
            glBegin( GL_TRIANGLE_STRIP );
            glNormal3f( 0.0f, 0.0f, 1.0f );
            glVertex3f( 0.0f, 0.0f, radius );
            for( int i=1; i<numTheta-1; ++i )
            {
                glNormal3dv( &points[ i*numPhi + j-1 ].x );
                glVertex3dv( &points[ i*numPhi + j-1 ].x );
                glNormal3dv( &points[ i*numPhi + j ].x );
                glVertex3dv( &points[ i*numPhi + j ].x );
            }
            glNormal3f( 0.0f, 0.0f, -1.0f );
            glVertex3f( 0.0f, 0.0f, -radius );
            glEnd();
        }
    }

    glPopMatrix();

    glPopAttrib();
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
