// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Common/SceneExport/Userchannel/hctUserChannelUtil.h>

class hctMayaSceneExporter;

// The mesh writer - used by the exporter
class hctMayaMeshWriter
{
    public:

        hctMayaMeshWriter();
        ~hctMayaMeshWriter();

        void setOwner( class hctMayaSceneExporter* owner );

        /// Extracts the geometry (including materials and textures)
        /// and any skinning details of a given mesh node.
        MStatus write( const MDagPath& dagPath, hkxMesh*& writtenMesh, hkxSkinBinding*& writtenSkin, bool forceSkinned );

        static const hkInt32 MAX_UV_SETS = 8;

    protected:

        MStatus extract( const MDagPath& dagPath );
        void cleanup();

        struct AnimatedVertData
        {
            MFloatPointArray    m_vertexArray;
            MFloatVectorArray   m_normalArray;
        };

        MStatus createSection( MObject& component, const hkxMaterial* material, hkArray<class hkxMeshSection*> & outSections, bool forceSkinned );
        hkxVertexAnimation* getVertexAnimation( AnimatedVertData& meshData, const hkxMeshSection* section, hkxVertexAnimationStateCache& c, const hctUserChannelUtil::SectionToGlobalMap& dataMap);
        MStatus createVertexBuffer( MObject& component, hkArray<class hkxVertexBuffer*> & newVBs, hkArray<MIntArray> & triIndices, const MFloatArray& weights, unsigned influenceCount, bool useInt8BoneIndices );
        int getMapUVSet(const MObject& textureNode, int& uniqueUvChooserId);
        MStatus createMaterial( const MObject& shadingGroup, hkxMaterial*& outMaterial );
        MStatus extractDiffuseMaps( MFnDependencyNode & surfaceShaderNode,
                                    hkArray<hkxTextureFile*> & outDiffuseMaps,
                                    hkArray<hkUint32> & outDiffuseMapUVs,
                                    hkArray<int>& uniqueUvChooserIds,
                                    hkxMaterial*& outMaterial);
        MStatus createTexture( const MObject& textureNode, hkxTextureFile*& outTexture );

        MStatus extractSelectionChannels( const MDagPath& dagPath );
        void addExportableSelections( const hkArray<hctUserChannelUtil::GlobalChannel>& candidateSelectionChannels,
                                                                const hkArray<bool>& candidateSelectionHadSuffix, const hkStringOld& meshName );
        MStatus extractFloatChannels( const MDagPath& dagPath );

        // The exporter
        class hctMayaSceneExporter* m_owner;
        int* m_currentUvChooserIdPtr;

        // The current mesh object and it's function sets
        MDagPath        m_dagPath;
        MFnMesh         m_mesh;

        struct Cluster
        {
            MObject cluster; // will have a MFnSkinCluster or a MFnWeightGeometryFilter
            unsigned int clusterPlugIndex;
            hkArray<int> influenceIndexIntoMasterArray; // into m_allSkinInfluences below
            hkArray<int> influenceLogicalIndices;
        };
        hkArray<Cluster> m_skinClusters;
        MDagPathArray m_allSkinInfluences;


        void findSkins();

        // Extracted data for the current mesh
        MString             m_currentColorSetName;  // Maya 7 only
        MStringArray        m_UVSetNames;
        hkInt32             m_numUVSetNames;
        MFloatPointArray    m_vertexArray;
        MFloatVectorArray   m_normalArray;

        MString             m_colorSetNameA;
        MColorArray         m_colorArrayA;

        MString             m_colorSetNameB;
        MColorArray         m_colorArrayB;

        MFloatArray         m_uArray[MAX_UV_SETS];
        MFloatArray         m_vArray[MAX_UV_SETS];

        hkArray<hkBool>     m_exportedPolygons;

        MFloatVectorArray   m_tangentsArray;
        MFloatVectorArray   m_binormalsArray;

        // User channels
        hctUserChannelUtil m_userChannelUtil;

        // All shading groups which have been exported as materials
        // into the owner's hctMayaSceneExporter::ResizableScene
        MObjectArray    m_processedShadingGroups;

};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
