// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Maya/MayaSceneExport/hctMayaSceneExport.h>
#include <Common/Base/System/Io/IStream/hkIStream.h>
#include <Common/Base/Container/String/Deprecated/hkStringOld.h>
#include <ContentTools/Common/SdkUtils/hctSdkUtils.h>
#include <ContentTools/Maya/MayaSceneExport/Commands/ReflectionUtilities/hctCmdOpenChmDocs.h>
#include <sstream>
#include <shellapi.h>

void* hctCommandOpenChmDocs::creator()
{
    return new hctCommandOpenChmDocs();
}


MSyntax hctCommandOpenChmDocs::newSyntax()
{
    MSyntax syntax;
    return syntax;
}


static const char* helpText = \
    "This command is used to bring up the documentation (if available)\n" \
    "for the current node.";


MStatus hctCommandOpenChmDocs::doIt(const MArgList& argList)
{
    MString classNameString;
    MStatus status = argList.get(0, classNameString);
    RETURN_STATUS_IF_FAIL( status, "You must specify a class name.");
    const char* className = classNameString.asChar();

    std::stringstream errorStream;

    hkStringOld documentationPathAndFileName;
    hctSdkUtils::getPathToAndNameOfDocumentationChmFile(documentationPathAndFileName);

    hkIfstream docsFile(documentationPathAndFileName.cString());
    if ( docsFile.isOk() )
    {
        const hkReflect::Type* modifierClass = hctSdkUtils::getTypeByName(className);
        if ( modifierClass )
        {
            if( const hkDocumentationAttribute* documentationAttribute = modifierClass->findAttribute<hkDocumentationAttribute>() )
            {
                const hkAttributeHideCriteria::Types hideCriteria = hctSdkUtils::getUiAttributesHideCriteria(hkAttributeHideCriteria::MODELER_IS_MAYA);
                const char* docsSectionTag = documentationAttribute->m_getDocsSectionTag(hideCriteria);
                if ( docsSectionTag && docsSectionTag[0] != 0 )
                {
                    const char* sectionTag = docsSectionTag;

                    std::stringstream parametersStream;
                    parametersStream << documentationPathAndFileName.cString() << "::" << sectionTag << ".html#" << modifierClass->getName() << "Tag";

                    std::string parametersString;
                    parametersString = parametersStream.str();

                    ShellExecute(NULL, "open", "hh.exe", parametersString.c_str(), NULL, SW_NORMAL);
                }
                else
                {
                    errorStream << "No documentation section defined for class '" << modifierClass->getName() << "'\'.";
                }
            }
            else
            {
                errorStream << "No documentation section defined for class '" << modifierClass->getName() << "'\'.";
            }
        }
        else
        {
            errorStream << "Class '"<< className << "' not registered.";
        }
    }
    else
    {
        errorStream << "Couldn't find documentation file '" << documentationPathAndFileName.cString() << "'.";
    }

    //
    // Print error (if any).
    //
    {
        std::string errorString = errorStream.str();
        char* errorStr = const_cast<char*>(errorString.c_str());
        if ( errorStr && errorStr[0] != 0 )
        {
            MString err(errorStr);
            MGlobal::displayError(err);
        }
    }

    return MStatus::kSuccess;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
