// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#include <maya/MGlobal.h>
#include <maya/MSyntax.h>
#include <maya/MArgList.h>

#include <ContentTools/Maya/MayaSceneExport/hctMayaSceneExport.h>
#include <ContentTools/Maya/MayaSceneExport/Commands/ReflectionUtilities/hctCmdGetMatchingClasses.h>

#include <ContentTools/Common/SdkUtils/hctSdkUtils.h>
#include <Common/Base/Container/String/Deprecated/hkStringOld.h>

void* hctCommandGetMatchingClasses::creator()
{
    return new hctCommandGetMatchingClasses();
}

MSyntax hctCommandGetMatchingClasses::newSyntax()
{
    MSyntax syntax;
    syntax.addArg(MSyntax::kString);
    syntax.addArg(MSyntax::kString);
    return syntax;
}

static const char* helpText = \
"This command is used to get a list of valid havok classes\n" \
"that match the class type specified (so, any class that inherits from it).\n" \
"We return the list of valid classes currently loaded in";

MStatus hctCommandGetMatchingClasses::doIt( const MArgList& argList )
{
    MString targetClass, targetAttribute;
    MStatus status = argList.get(0, targetClass);
    RETURN_STATUS_IF_FAIL( status, "You must specify a node type and the attribute to test.");

    status = argList.get(1, targetAttribute);
    RETURN_STATUS_IF_FAIL( status, "You must specify a node type and the attribute to test.");

    hkArray<hkStringOld> matchingClassNames;
    hctSdkUtils::getMatchingClasses(targetClass.asChar(), targetAttribute.asChar(), matchingClassNames);

    MStringArray result;
    for (int i = 0; i < matchingClassNames.getSize(); i++)
    {
        result.append(matchingClassNames[i].cString());
    }

    setResult(result);

    return MStatus::kSuccess;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
