// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#include <maya/MGlobal.h>
#include <maya/MSyntax.h>
#include <maya/MArgList.h>

#include <ContentTools/Maya/MayaSceneExport/hctMayaSceneExport.h>
#include <ContentTools/Maya/MayaSceneExport/Commands/ReflectionUtilities/hctCmdGetLinkType.h>

#include <ContentTools/Common/SdkUtils/hctSdkUtils.h>
#include <ContentTools/Common/SdkUtils/ClassHierarchy/hctClassHierarchyUtil.h>

void* hctCommandGetLinkType::creator()
{
    return new hctCommandGetLinkType();
}

MSyntax hctCommandGetLinkType::newSyntax()
{
    MSyntax syntax;
    syntax.addArg(MSyntax::kString);
    syntax.addArg(MSyntax::kString);
    return syntax;
}

static const char* helpText = \
"This command is used to get the link type of a linked attribute.\n" \
"Returns the link type, if the attribute specified is a link.\n" \
"Returns a failure if the attribute is a not a link";

static hkReflect::FieldDecl _findMemberRecursively(const hkReflect::Type* klass, const char* memberPath)
{
    

    const hkReflect::Type* classType = klass;
    const char* remainingMemberPath = memberPath;
    const char* colonPos;
    while ((colonPos = hkString::strChr(remainingMemberPath, ':')) != 0)
    {
        hkStringBuf innerMemberName(remainingMemberPath, int(colonPos - remainingMemberPath));
        classType = classType->findField(innerMemberName.cString(), true).getType();
        if (!classType)
        {
            HK_WARN_ALWAYS(0xf0125445, "Cannot find member: " << innerMemberName.cString());
            return hkReflect::FieldDecl();
        }
        remainingMemberPath = colonPos + 1;
    }
    hkReflect::FieldDecl member = classType->findField(remainingMemberPath, true);
    return member;
}

MStatus hctCommandGetLinkType::doIt( const MArgList& argList )
{
    MString targetClassName, targetAttribute;
    MStatus status = argList.get(0, targetClassName);
    RETURN_STATUS_IF_FAIL( status, "You must specify a node type and the attribute to test.");

    status = argList.get(1, targetAttribute);
    RETURN_STATUS_IF_FAIL( status, "You must specify a node type and the attribute to test.");

    const hkReflect::Type* klass = hctSdkUtils::getTypeByName(targetClassName.asChar());

    if (klass)
    {
        HK_ASSERT_NO_MSG(0x60d7e5ef, klass->asRecord());
        hkReflect::FieldDecl member = _findMemberRecursively(klass, targetAttribute.asChar());
        if (member)
        {
            const hkLinkAttribute*      linkAttributes      = member.getType()->findAttribute<hkLinkAttribute>();

            if (linkAttributes)
            {
                MString result;
                switch(linkAttributes->m_type)
                {
                    case hkLinkAttribute::MESH:
                    case hkLinkAttribute::NODE_UUID:
                    {
                        result = "MESH";
                    }
                    break;

                    case hkLinkAttribute::DIRECT_LINK:
                    {
                        result = "DIRECT_LINK";
                    }
                    break;

                    case hkLinkAttribute::CHILD:
                    {
                        result = "CHILD";
                    }
                    break;

                    case hkLinkAttribute::IMGSELECT:
                    {
                        result = "IMGSELECT";
                    }
                    break;

                    case hkLinkAttribute::NONE:
                    default:
                    {
                        RETURN_STATUS_IF_FAIL(MStatus::kFailure, "The attribute specified is not a link.");
                    }
                    break;

                }

                // Return the type
                setResult(result);
            }
            else
            {
                RETURN_STATUS_IF_FAIL(MStatus::kFailure, "The attribute specified is not a link.");
            }
        }
        else
        {
            RETURN_STATUS_IF_FAIL(MStatus::kFailure, "Could not find a member matching the attribute name specified.");
        }

    }
    else
    {
        RETURN_STATUS_IF_FAIL(MStatus::kFailure, "Could not find a class matching the class name specified.");
    }
    return status;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
