// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#include <maya/MGlobal.h>
#include <maya/MSyntax.h>
#include <maya/MArgList.h>

#include <ContentTools/Maya/MayaSceneExport/hctMayaSceneExport.h>
#include <ContentTools/Maya/MayaSceneExport/Commands/ReflectionUtilities/hctCmdGetDerivedClassesInfo.h>

#include <ContentTools/Common/SdkUtils/hctSdkUtils.h>
#include <ContentTools/Common/SdkUtils/ClassHierarchy/hctClassHierarchyUtil.h>

void* hctCommandGetDerivedClassesInfo::creator()
{
    return new hctCommandGetDerivedClassesInfo();
}

MSyntax hctCommandGetDerivedClassesInfo::newSyntax()
{
    MSyntax syntax;
    syntax.addArg(MSyntax::kString);
    return syntax;
}

static const char* helpText = \
"This command is used to get a list of valid Havok classes\n" \
"that match inherit from the supplied baseclass.\n" \
"We return a list with class name and display name for each" \
"matching class found";

MStatus hctCommandGetDerivedClassesInfo::doIt( const MArgList& argList )
{
    MString baseClassName;
    MStatus status = argList.get(0, baseClassName);
    RETURN_STATUS_IF_FAIL( status, "You must specify the base class name.");

    // Output array.
    MStringArray result;

    // Get all classes that are derived from the supplied base class.
    hkArray<hctModelerNodeIdToClassMap> classes;
    hctSdkUtils::getClassesByBaseName(baseClassName.asChar(), classes);

    // Get the UI style and hide all classes that aren't supposed to be visible
    const hkAttributeHideCriteria::Types hideCriteria = hctSdkUtils::getUiAttributesHideCriteria(hkAttributeHideCriteria::MODELER_IS_MAYA);

    // Fill output array with both the class name and the display name.
    {
        for (int i = 0; i < classes.getSize(); i++)
        {
            hctModelerNodeIdToClassMap& classInfo = classes[i];
            const hkReflect::Type* klass            = classInfo.m_class;
            const hkUiAttribute* uiAttrib   = klass ? klass->findAttribute<hkUiAttribute>() : HK_NULL;
            const bool bHidden              = uiAttrib && (uiAttrib->m_hideCriteria & hideCriteria);

            if ( !bHidden )
            {
                result.append(classInfo.m_nodeName);
                result.append(classInfo.m_displayName);

                hkStringBuf classification;
                classification.printf("%d", classInfo.m_internalClassification);
                result.append(classification.cString());
            }
        }
    }

    setResult(result);

    return MStatus::kSuccess;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
