// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <maya/MDagModifier.h>
#include <vector> // STL...

struct hkGeometry;
struct ProgressSceneUpdaterMaya;

// create a convex hull from a selected node with a mesh or nurbs
class hctCmdImportScene : public MPxCommand
{
public:
    static void* creator() { return new hctCmdImportScene; }
    static MSyntax getCommandSyntax();

    virtual MStatus doIt( const MArgList& args );

    virtual MStatus redoIt();
    virtual MStatus undoIt();
    bool isUndoable() const { return true; }

    virtual ~hctCmdImportScene();

    // The plugin object
    static MObject m_pluginObject;

private:

    hctCmdImportScene();

    std::vector<MDagModifier*> m_dagModifiers;
    void cleaupModifiers();

    static ProgressSceneUpdaterMaya* m_progressUpdater;

    // options:
    MString m_filename;
    bool m_importMeshes;
    bool m_importLights;
    bool m_importCameras;

    MStatus removeMeshGeneratedFromNurbs( const MDagPath& generatedMeshPath );
    MStatus getWorldVerticesFromObject( const MDagPath& dagPath, MPointArray& vertexArray );
    MStatus createMultiHull( MPointArray& vertexArray, MString hullName );
    MStatus createHullMesh( hkGeometry& geom, MString hullName );

};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
