// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Maya/MayaSceneExport/hctMayaSceneExport.h>
#include <ContentTools/Maya/MayaSceneExport/Commands/GetVersion/hctCmdGetVersion.h>

// Command flags
#define stringModeFlag              "-s"
#define stringModeFlagLong          "-string"


MSyntax hctCmdGetVersion::getCommandSyntax()
{
    MSyntax syntax;

    syntax.addFlag( stringModeFlag, stringModeFlagLong );

    syntax.setObjectType( MSyntax::kNone );
    syntax.enableQuery( true );

    return syntax;
}


MStatus hctCmdGetVersion::doIt( const MArgList& args )
{
    MArgDatabase argData( syntax(), args );
    if( argData.isFlagSet( stringModeFlag ) )
    {
        setResult( HCT_CURRENT_VERSION_STRING );
    }
    else
    {
        setResult( HCT_CURRENT_VERSION );
    }
    return MStatus::kSuccess;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
