// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Maya/MayaSceneExport/hctMayaSceneExport.h>
#include <ContentTools/Maya/MayaSceneExport/Commands/ExportScene/hctCmdExportScene.h>

#include <ContentTools/Maya/MayaSceneExport/Exporter/hctMayaSceneExporter.h>
#include <ContentTools/Maya/MayaSceneExport/Utilities/hctMayaUtilities.h>

#include <ContentTools/Common/SceneExport/Memory/hctSceneExportMemory.h>

#include <maya/MProgressWindow.h>

// Initialize statics
MObject hctCmdExportScene::m_pluginObject;
MObject hctCmdGetFileDependencies::m_pluginObject;
//
// Command flags
//

#define batchModeFlag               "-b"
#define batchModeFlagLong           "-batchMode"

#define quickConfigModeFlag         "-cz"  // implies batch mode
#define quickConfigModeFlagLong     "-configZero"

#define exportMeshesFlag            "-ms"
#define exportMeshesFlagLong        "-exportMeshes"
#define exportMaterialsFlag         "-mt"
#define exportMaterialsFlagLong     "-exportMaterials"
#define exportAttributesFlag        "-att"
#define exportAttributesFlagLong    "-exportAttributes"
#define exportAnnotationsFlag       "-ann"
#define exportAnnotationsFlagLong   "-exportAnnotations"
#define exportLightsFlag            "-l"
#define exportLightsFlagLong        "-exportLights"
#define exportCamerasFlag           "-c"
#define exportCamerasFlagLong       "-exportCameras"
#define visibleOnlyFlag             "-v"
#define visibleOnlyFlagLong         "-visibleOnly"
#define selectedOnlyFlag            "-s"
#define selectedOnlyFlagLong        "-selectedOnly"

#define startTimeFlag               "-t1"
#define startTimeFlagLong           "-startTime"
#define endTimeFlag                 "-t2"
#define endTimeFlagLong             "-endTime"

#define configurationSetFlag        "-cs"
#define configurationSetFlagLong    "-configurationSet"

#define optionsFileFlag             "-o"
#define optionsFileFlagLong         "-optionsFile"
#define environmentVarsFlag         "-ev"
#define environmentVarsFlagLong     "-environtmentVariables"

#define useRotatePivotFlag          "-rp"
#define useRotatePivotFlagLong      "-useRotatePivot"
#define doNotSplitVerticesFlag      "-nsv"
#define doNotsplitVerticesFlagLong  "-doNotSplitVertices"

#define getAutoSkinAttachmentsFlag      "-asa"
#define getAutoSkinAttachmentsFlagLong  "-getAutoSkinAttachments"

#define storeKeyframeSamplePoints       "-kfs"
#define storeKeyframeSamplePointsLong   "-storeKeyframeSamplePoints"

#define exportTangents      "-evt"
#define exportTangentsLong  "-exportTangents"

#define exportVertexAnimations      "-eva"
#define exportVertexAnimationsLong  "-exportVertexAnimations"


//
// Command implementation
//

MSyntax hctCmdExportScene::getCommandSyntax()
{
    MSyntax syntax;

    syntax.addFlag( batchModeFlag, batchModeFlagLong );
    syntax.addFlag( quickConfigModeFlag, quickConfigModeFlagLong );

    syntax.addFlag( exportMeshesFlag, exportMeshesFlagLong, MSyntax::kBoolean );
    syntax.addFlag( exportMaterialsFlag, exportMaterialsFlagLong, MSyntax::kBoolean );
    syntax.addFlag( exportAttributesFlag, exportAttributesFlagLong, MSyntax::kBoolean );
    syntax.addFlag( exportAnnotationsFlag, exportAnnotationsFlagLong, MSyntax::kBoolean );
    syntax.addFlag( exportLightsFlag, exportLightsFlagLong, MSyntax::kBoolean );
    syntax.addFlag( exportCamerasFlag, exportCamerasFlagLong, MSyntax::kBoolean );
    syntax.addFlag( visibleOnlyFlag, visibleOnlyFlagLong );
    syntax.addFlag( selectedOnlyFlag, selectedOnlyFlagLong );

    syntax.addFlag( startTimeFlag, startTimeFlagLong, MSyntax::kTime );
    syntax.addFlag( endTimeFlag, endTimeFlagLong, MSyntax::kTime );

    syntax.addFlag( configurationSetFlag, configurationSetFlagLong, MSyntax::kString );

    syntax.addFlag( optionsFileFlag, optionsFileFlagLong, MSyntax::kString );
    syntax.addFlag( environmentVarsFlag, environmentVarsFlagLong, MSyntax::kString );

    syntax.addFlag( useRotatePivotFlag, useRotatePivotFlagLong, MSyntax::kBoolean );
    syntax.addFlag( doNotSplitVerticesFlag, doNotsplitVerticesFlagLong, MSyntax::kBoolean );
    syntax.addFlag( getAutoSkinAttachmentsFlag, getAutoSkinAttachmentsFlagLong, MSyntax::kBoolean );
    syntax.addFlag( storeKeyframeSamplePoints, storeKeyframeSamplePointsLong, MSyntax::kBoolean );
    syntax.addFlag( exportTangents, exportTangentsLong, MSyntax::kBoolean);
    syntax.addFlag( exportVertexAnimations, exportVertexAnimationsLong, MSyntax::kBoolean);


    syntax.setObjectType( MSyntax::kNone );
    syntax.enableQuery( false );
    syntax.enableEdit( false );
    return syntax;
}


MStatus hctCmdExportScene::doIt( const MArgList& args )
{
    // Create the default exporter options
    hctMayaSceneExporter::Options options;

    // Override with whatever comes from the command arguments
    {
        MArgDatabase argData( syntax(), args );

        options.m_batchMode = argData.isFlagSet(batchModeFlag) || (MGlobal::mayaState() != MGlobal::kInteractive);
        options.m_runConfig = argData.isFlagSet(quickConfigModeFlag) ? 0 : -1;

        if( argData.isFlagSet( exportMeshesFlag ) )
        {
            argData.getFlagArgument( exportMeshesFlag, 0, options.m_exportMeshes );
        }
        if( argData.isFlagSet( exportMaterialsFlag ) )
        {
            argData.getFlagArgument( exportMaterialsFlag, 0, options.m_exportMaterials );
        }
        if( argData.isFlagSet( exportAttributesFlag ) )
        {
            argData.getFlagArgument( exportAttributesFlag, 0, options.m_exportAttributes );
        }
        if( argData.isFlagSet( exportAnnotationsFlag ) )
        {
            argData.getFlagArgument( exportAnnotationsFlag, 0, options.m_exportAnnotations );
        }
        if( argData.isFlagSet( exportLightsFlag ) )
        {
            argData.getFlagArgument( exportLightsFlag, 0, options.m_exportLights );
        }
        if( argData.isFlagSet( exportCamerasFlag ) )
        {
            argData.getFlagArgument( exportCamerasFlag, 0, options.m_exportCameras );
        }

        options.m_visibleOnly = argData.isFlagSet( visibleOnlyFlag );
        options.m_selectedOnly = argData.isFlagSet( selectedOnlyFlag );

        if( argData.isFlagSet( startTimeFlag ) )
        {
            argData.getFlagArgument( startTimeFlag, 0, options.m_startTime );
        }
        if( argData.isFlagSet( endTimeFlag ) )
        {
            argData.getFlagArgument( endTimeFlag, 0, options.m_endTime );
        }

        if (argData.isFlagSet(configurationSetFlag))
        {
            argData.getFlagArgument(configurationSetFlag, 0, options.m_configurationSet);
        }

        // Make sure end time is not less than start time
        if( options.m_endTime < options.m_startTime )
        {
            displayWarning( "End time is before start time - exporting one frame only" );
            options.m_endTime = options.m_startTime;
        }

        if( argData.isFlagSet( optionsFileFlag ) )
        {
            argData.getFlagArgument( optionsFileFlag, 0, options.m_hkoFile );
        }

        if( argData.isFlagSet( environmentVarsFlag ) )
        {
            argData.getFlagArgument( environmentVarsFlag, 0, options.m_environmentVariables );
        }

        if( argData.isFlagSet( useRotatePivotFlag ) )
        {
            argData.getFlagArgument( useRotatePivotFlag, 0, options.m_useRotatePivot );
        }
        if( argData.isFlagSet( doNotSplitVerticesFlag ) )
        {
            argData.getFlagArgument( doNotSplitVerticesFlag, 0, options.m_doNotSplitVertices );
        }
        if( argData.isFlagSet( getAutoSkinAttachmentsFlag ) )
        {
            argData.getFlagArgument( getAutoSkinAttachmentsFlag, 0, options.m_autoSkinAttachments );
        }
        if( argData.isFlagSet( storeKeyframeSamplePoints ) )
        {
            argData.getFlagArgument( storeKeyframeSamplePoints, 0, options.m_storeKeyframeSamplePoints );
        }
        if (argData.isFlagSet(exportTangents))
        {
            argData.getFlagArgument(exportTangents, 0, options.m_exportVertexTangents);
        }
        if (argData.isFlagSet(exportVertexAnimations))
        {
            argData.getFlagArgument(exportVertexAnimations, 0, options.m_exportVertexAnimations);
        }
    }


    // hctSdkUtils::loadAllClasses();

    // Create an exporter with these options and run it.
    // NOTE that the exporter must go out of scope before
    // we exit the memory manager.
    {
        hkError* origError = &hkError::getInstance();
        origError->addReference();
        hkError* mayaErrorHandler = new hkMayaError();
        hkError::replaceInstance( mayaErrorHandler );

        hctMayaSceneExporter exporter( options );

        MFnPlugin pluginFn( m_pluginObject );
        exporter.m_pluginPath = pluginFn.loadPath().asChar();

        MProgressWindow::setProgressStatus( MString("Waiting for init to finish caching filters..") );



        MStatus result = exporter.doExport();

        setResult( result == MStatus::kSuccess );

        hkError::replaceInstance( origError ); // takes ref
    }

    // Always return successfully.
    // Otherwise this could halt a batch process.
    return MStatus::kSuccess;
}


MSyntax hctCmdWaitForFilterLoad::getCommandSyntax()
{
    MSyntax syntax;
    syntax.setObjectType( MSyntax::kNone );
    syntax.enableQuery( false );
    syntax.enableEdit( false );
    return syntax;
}

MStatus hctCmdWaitForFilterLoad::doIt( const MArgList& args )
{
    hctFilterProcessingUtil::waitOnBackgroundFilterLoad();
    return MStatus::kSuccess;
}

MSyntax hctCmdGetFileDependencies::getCommandSyntax()
{
    MSyntax syntax;

    syntax.addFlag(configurationSetFlag, configurationSetFlagLong, MSyntax::kString);
    syntax.addFlag(optionsFileFlag, optionsFileFlagLong, MSyntax::kString);

    syntax.setObjectType(MSyntax::kNone);
    syntax.enableQuery(false);
    syntax.enableEdit(false);

    return syntax;
}

MStatus hctCmdGetFileDependencies::doIt(const MArgList& args)
{
    // Create the default exporter options
    hctMayaSceneExporter::Options options;

    // Override with whatever comes from the command arguments
    {
        options.m_batchMode = true;

        MArgDatabase argData(syntax(), args);

        if (argData.isFlagSet(configurationSetFlag))
        {
            argData.getFlagArgument(configurationSetFlag, 0, options.m_configurationSet);
        }

        if (argData.isFlagSet(optionsFileFlag))
        {
            argData.getFlagArgument(optionsFileFlag, 0, options.m_hkoFile);
        }
    }

     //hctSdkUtils::loadAllClasses();

    // Create an exporter with these options and run it.
    // NOTE that the exporter must go out of scope before
    // we exit the memory manager.
    {
        hkError* origError = &hkError::getInstance();
        origError->addReference();
        hkError* mayaErrorHandler = new hkMayaError();
        hkError::replaceInstance(mayaErrorHandler);

        hctMayaSceneExporter exporter(options);

        MFnPlugin pluginFn(m_pluginObject);
        exporter.m_pluginPath = pluginFn.loadPath().asChar();

        MProgressWindow::setProgressStatus(MString("Waiting for init to finish caching filters.."));


        hkArray<hkStringPtr> fileDependencies;
        MStatus result = exporter.getFileDependencies(fileDependencies);

        MStringArray resultArray;
        resultArray.setLength(fileDependencies.getSize());

        for (int i = 0; i < fileDependencies.getSize(); i++)
        {
            resultArray[i] = MString(fileDependencies[i].cString());
        }

        setResult(resultArray);

        hkError::replaceInstance(origError); // takes ref
    }

    // Always return successfully.
    // Otherwise this could halt a batch process.
    return MStatus::kSuccess;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
