// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <maya/MDagModifier.h>
#include <ContentTools/Common/ConvexDecompUtils/hctConvexDecompUtils.h>

struct hkGeometry;

//
// Implement progress bar job-handler
//
class hctMayaConvexDecompProgressHandler : hctConvexDecompProgressHandler
{
public:
    hctMayaConvexDecompProgressHandler(){}
    ~hctMayaConvexDecompProgressHandler(){}

    // Update progress bar based on job added by callback function
    virtual void processJobs();
    virtual void setupBar();
    virtual void cleanupBar( const bool result );
};

//
// Implement Maya Convex Decomposition command
//
class hctCmdCreateConvexDecomposition : public MPxCommand
{
public:

    // Results
    struct hctConvexDecompResults
    {
        int nInShapes;
        int nInTriangles;
        int nInPlanes;
        int nOutShapes;
        int nOutPlanes;

        hctConvexDecompResults(){ reset(); }
        void reset()
        {
            nInShapes = nInTriangles = nInPlanes = nOutShapes = nOutPlanes = 0;
        }
    };

    static void* creator() { return new hctCmdCreateConvexDecomposition; }
    static MSyntax getCommandSyntax();
    virtual MStatus doIt(const MArgList& args);
    virtual MStatus redoIt();
    virtual MStatus undoIt();
    bool isUndoable() const { return true; }

    static MObject m_pluginObject;

private:
    MDagModifier            dagMod;
    static const int        m_triangleWarningThreshold = 20000;
    bool                    m_checkValidity;
    bool                    m_detachParts;
    bool                    m_singleOut;
    float                   m_accuracy;
    bool                    m_CDsucc;
    bool                    m_singleOutCombine;
    bool                    m_useExisting;
    bool                    m_generateGuards;
    int                     m_reduceOverlapSteps;
    int                     m_octreeDepth;
    int                     m_decomposeMethod;
    int                     m_reduceMethod;
    int                     m_wrapIterations;
    float                   m_wrapConcavity;
    hctConvexDecompUtils*   m_convexDecompUtils;

    MStatus convexDecomposition( const MSelectionList& commandList );
    MStatus combineConvexShapes( const MSelectionList& commandList );
    MStatus deleteCombinedNodes( MSelectionList& combineList );
    MObject retrieveGroupHead( MSelectionList& combineList, MStatus* status );
    MStatus connectNodesToBaseMesh( MSelectionList& nodeList, MDagPath& baseDagPath );
    MStatus connectNodesToShadingGroup( const MSelectionList& dagList );
    MStatus getVertexArrayFromSelectionList( const MSelectionList& dagList, hkArray<hkArray<hkVector4> >& shapesToCombine, hctConvexDecompResults& results );
    MStatus getVerticesFromDagPath( const MDagPath& baseDagPath, hkArray<hkVector4>& vertices, hctConvexDecompResults& results );
    MStatus getGeometryFromDagPath( const MDagPath& baseDagPath, const MDagPath& dagPath, hkGeometry& combinedGeometry, hctConvexDecompResults& stats );
    MStatus createDagPathFromGeometry( const hkGeometry& geometryIn, const MString& shapeName, MObject& baseShape, MObject& groupHead, MSelectionList& newSelList, MSelectionList& connectList, hctConvexDecompResults& results, const hkTransform* normalizedToWorld = NULL );
    MStatus displayResults( hctConvexDecompResults& results, const bool isDecompose );
    MStatus displayWarning( const int nTriangles, const bool isDecompose );
    MStatus createGeometryFromNodes( MDagPath& baseDagPath, const MSelectionList& commandList, hkGeometry& geometryFromScene, hctConvexDecompResults& results );
    MStatus createOutputNodesFromPoints( MString& baseDagPathName, MDagPath& baseDagPath, MObject& groupHead, hkArray< hkArray<hkVector4> >& shapes, hkTransform& normalizedToWorld, MSelectionList& newSelList, MSelectionList& connectList, hctConvexDecompResults& results );
    static MStatus addNodesToShadingGroup( const MSelectionList& nodeList );
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
