// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT    : COMMON
// VISIBILITY : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <maya/MDagModifier.h>

struct hkGeometry;
struct ProgressUpdaterMaya;

// Optimize geometry for collision or convex decomposition.
/// WARNING: This feature is currently in BETA. Changes in interface, behavior or performance may be expected.
class hctCmdCgo : public MPxCommand
{
    public:

        static void* creator() { return new hctCmdCgo; }
        static MSyntax getCommandSyntax();

        virtual MStatus doIt( const MArgList& args );

        virtual MStatus redoIt();
        virtual MStatus undoIt();
        bool isUndoable() const { return true; }

    private:

        MDagModifier m_dagMod;

        static struct ProgressUpdaterMaya* m_progressUpdater;

        MStatus getGeometryFromDagPath( const MDagPath& dagPath, hkGeometry& geometry );
        MStatus createMesh( const hkGeometry& geom, MDagPath& sourceMeshDagPath );

        MDistance   m_maxDistance;
        double      m_shrinking;
        int         m_targetNumVertices;
        double      m_targetRatio;
        bool        m_protGeo;
        bool        m_protMat;
        bool        m_useVertexWeight;
        bool        m_multipass;
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
