// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>

#include <ContentTools/Max/MaxSceneExport/Utilities/hctSceneExportUtility.h>
#include <ContentTools/Max/MaxSceneExport/GUP/Toolbar/hctToolbarGUP.h>
#include <ContentTools/Max/MaxSceneExport/GUP/SelectionUtil/hctSelectionUtilGUP.h>
#include <ContentTools/Max/MaxSceneExport/GUP/ConversionUtil/hctConversionUtilGUP.h>
#include <ContentTools/Max/MaxSceneExport/Utils/hctMaxUtils.h>
#include <ContentTools/Max/MaxSceneExport/Utils/hctMaxDestructionUtilities.h>
#include <ContentTools/Max/MaxSceneExport/GUP/Viewport/hctMaxViewport.h>

#include <Common/Base/System/hkBaseSystem.h>
#include <Common/Base/System/Io/OStream/hkOStream.h>

#include <ContentTools/Common/SceneExport/Memory/hctSceneExportMemory.h>
#include <ContentTools/Max/MaxFpInterfaces/Colors/hctColorIds.h>

// Connection to Havok SDK through hksdkutils
#include <ContentTools/Common/SdkUtils/hctSdkUtils.h>

#ifdef HAVOK_VISION_EXPORTER
#include <ContentTools/Max/MaxSceneExport/Vision/hctMaxVisionIncludes.h> 
#include <ContentTools/Max/MaxSceneExport/Vision/hctMaxVisionExporterDesc.h> 
#include <Vision/Tools/SceneDataConverter/Processor/hkVisionProcessorOptions.h> 
#include <ContentTools/Common/Vision/ExportHelpers/hctVisionExportHelpers.h> 
#include <ContentTools/Max/MaxSceneExport/Vision/hctMaxVisionUtilitiesPanel.h> 
#include <ContentTools/Max/MaxSceneExport/Vision/hctMaxVisionExporter.h> 
#endif

static void _registerColors();
extern ClassDesc2* GetHctMaxViewportDesc();


// The plugin's DLL instance handle.
HINSTANCE hInstance;

#include <Common/Base/KeyCode.h>
#include <ContentTools/Max/MaxSceneExport/Modifiers/Generic/hctGenericModifierDesc.h>
#include <ContentTools/Maya/MayaSceneExport/hctMayaNodeIds.h>
#include <Common/Base/Serialize/Format/Compat/hkCompatFormats.h>

///////////////////////////////////////////////////////////////////////////////////////////
//
// Required DLL and Library plugin functions.
//
///////////////////////////////////////////////////////////////////////////////////////////

bool CommonControlsInitialized = FALSE;

bool isVisionEnabled();

BOOL WINAPI DllMain(HINSTANCE hinstDLL, ULONG fdwReason, LPVOID lpvReserved)
{
    switch ( fdwReason )
    {
    case DLL_PROCESS_ATTACH:
        {
            // Hang on to this DLL's instance handle.
            hInstance = hinstDLL;

            if ( !CommonControlsInitialized )
            {

#if MAX_VERSION_MAJOR<12
                // Initialize MAX's custom controls.
                InitCustomControls(hInstance);
#endif

                // Initialize Win32 controls.
                InitCommonControls();
                CommonControlsInitialized = TRUE;

                _registerColors();

                hkSceneExportMemory::baseSystemInit();

                hkStringOld filterManagerPath;
                if ( hctMaxUtils::getFilterManagerPath( filterManagerPath ) )
                {
                    hkStringBuf compatPath;
                    compatPath.printf("%s\\utils", filterManagerPath.cString());
                    if (!hkCompatFormats::getInstance().isLoaded())
                    {
                        hkCompatFormats::replaceInstance(new hkCompatFormats(compatPath.cString()));
                    }

                    // Start the background DLL cache for filters
                    #if 0  //EXP-2271. Disable pre load of potentially C# based plugins (delay load until later basically). This delay, along with not including the Vision WinForms GUI will allow error free load in Max 2013 etc as no C# conflicts.
                        hctFilterProcessingUtil::startBackgroundFilterLoad(filterManagerPath.cString());
                    #endif
                }

                hctMaxDestructionUtilities::initDestructionPlugin();

#ifdef HAVOK_VISION_EXPORTER
                if (isVisionEnabled())
                    VFileAccessManager::Init();
#endif
            }
            break;
        }

    case DLL_PROCESS_DETACH:
        {
            if ( CommonControlsInitialized )
            {
                CommonControlsInitialized = FALSE;

                hctMaxDestructionUtilities::quitDestructionPlugin();

                hctSdkUtils::unloadAllClasses();
                hkSceneExportMemory::baseSystemQuit();
            }
        }

    case DLL_THREAD_ATTACH:
    case DLL_THREAD_DETACH:
        break;
    }
    return TRUE;
}

__declspec( dllexport ) const MCHAR* LibDescription()
{
    return GetString(IDS_LIBDESCRIPTION);
}

#define HCT_NUM_HAVOK_3DSMAX_CLASSES 26
#define HCT_NUM_VISION_3DSMAX_CLASSES 6

bool isVisionEnabled()
{
#ifndef HAVOK_VISION_EXPORTER
    return false;
#else
    //[EXP-2413] See if the special envvar is set. If set, disable.
    char* value = getenv("HAVOK_MAX_DISABLE_VISION");
    return value == HK_NULL;
#endif
}

__declspec( dllexport ) int LibNumberClasses()
{
    int getHkNumGenericModifiers();

    int enabledMaxClasses = HCT_NUM_HAVOK_3DSMAX_CLASSES;
    if (isVisionEnabled())
    {
        enabledMaxClasses += HCT_NUM_VISION_3DSMAX_CLASSES;
    }

    int numGenericModifiers = getHkNumGenericModifiers();

    if (getHkdToolbarGUPDesc())
    {
        return (enabledMaxClasses + numGenericModifiers);
    }
    return (enabledMaxClasses + numGenericModifiers - 1); // NOTE: this means the hkd stuff must be at the p_end of the classdesc list
}

extern ClassDesc2* s_HkDestructionUtilityDesc = 0;

__declspec( dllexport ) ClassDesc* LibClassDesc(int i)
{
    ClassDesc2* getHkRigidBodyModifierDesc();
    ClassDesc2* getHkShapeModifierDesc();
    ClassDesc2* getHkBallAndSocketConstraintModifierDesc();
    ClassDesc2* getHkHingeConstraintModifierDesc();
    ClassDesc2* getHkRagdollConstraintModifierDesc();
    ClassDesc2* getHkPrismaticConstraintModifierDesc();
    ClassDesc2* getHkStiffSpringConstraintModifierDesc();
    ClassDesc2* getHkWheelConstraintModifierDesc();
    ClassDesc2* getHkFixedConstraintModifierDesc();

    ClassDesc2* getHkConvexHullUtilityDesc();

    ClassDesc2* getHkExportChannelModifierDesc();
    ClassDesc2* getHkClothCollidableModifierDesc();
    ClassDesc2* getHkLocalFrameModifierDesc();

    ClassDesc2* getHkGenericHelperDesc();
    ClassDesc2* getHkGenericModifierDesc(int i);

    ClassDesc2* getHkConvexDecompUtilityDesc();

    ClassDesc2* getHkTaperedCapsuleClassDesc();

    ClassDesc2* getHkBonesFromMeshUtilityDesc();

#if (defined (HK_FEATURE_PRODUCT_DESTRUCTION_2012) || defined (HK_FEATURE_PRODUCT_DESTRUCTION))
    ClassDesc2* gethkScriptedFractureModifierDesc();
    ClassDesc2* getHkDestructionUtilityDesc();
#endif

    ClassDesc2* getHkCgoUtilityDesc();

    int getHkNumGenericModifiers();

    switch(i)
    {
    case 0:
        return getHkRigidBodyModifierDesc();
    case 1:
        return getHkShapeModifierDesc();
    case 2:
        return getHkBallAndSocketConstraintModifierDesc();
    case 3:
        return getHkHingeConstraintModifierDesc();
    case 4:
        return getHkRagdollConstraintModifierDesc();
    case 5:
        return getHkPrismaticConstraintModifierDesc();
    case 6:
        return getHkStiffSpringConstraintModifierDesc();
    case 7:
        return getHkWheelConstraintModifierDesc();
    case 8:
        return getHkConvexHullUtilityDesc();
    case 9:
        return getHkCgoUtilityDesc();
    case 10:
        return getHkExportChannelModifierDesc();
    case 11:
        return getHkClothCollidableModifierDesc();
    case 12:
        return getHkLocalFrameModifierDesc();
    case 13:
        return getHkGenericHelperDesc();
    case 14:
#if (defined (HK_FEATURE_PRODUCT_DESTRUCTION_2012) || defined (HK_FEATURE_PRODUCT_DESTRUCTION))
        return getHkDestructionUtilityDesc();
#else
        return HK_NULL;
#endif
    case 15:
        return getHkConvexDecompUtilityDesc();
    case 16:
        return getHkTaperedCapsuleClassDesc();
    // hctMaxViewport
    case 17:
        return GetHctMaxViewportDesc();
    // hctMaxSceneExport
    case 18:
        return getHkSceneExportUtilityDesc();
    case 19:
        return getHkOldSceneExporterDesc();
    case 20:
        return getHkToolbarGUPDesc();
    case 21:
        return getHkSelectionUtilGUPDesc();
    case 22:
        return getHkConversionUtilGUPDesc();
    case 23:
        return getHkBonesFromMeshUtilityDesc();
    case 24:
        return getHkFixedConstraintModifierDesc();
    case 25:
#ifdef HAVOK_VISION_EXPORTER
     if (isVisionEnabled()){ return hctMaxVisionExporterDesc<VGVisionImporterExporter::VDF_MESH>::GetInstance(); }
     // else fall through
  case 26: // MODEL file
     if (isVisionEnabled()) { return hctMaxVisionExporterDesc<VGVisionImporterExporter::VDF_MODEL>::GetInstance(); }
     // else fall through
  case 27:
     if (isVisionEnabled()) { return hctMaxVisionExporterDesc<VGVisionImporterExporter::VDF_COLLISION_MESH>::GetInstance(); }
     // else fall through
  case 28:
     if (isVisionEnabled()) { return hctMaxVisionExporterDesc<VGVisionImporterExporter::VDF_ANIM>::GetInstance(); }
     // else fall through
  case 29:
     if (isVisionEnabled()) { return hctMaxVisionExporterDesc<VGVisionImporterExporter::VDF_PREFAB>::GetInstance(); }
     // else fall through
  case 30:
     if (isVisionEnabled()) { return &g_HkVisionNodeUtilDesc; }
       // else fall through
  case 31:
    // Vision on and 31, or vision off and 25, otherwise fallthrough
    if ( (isVisionEnabled() && (i == 31)) || (!isVisionEnabled() && (i == 25)) )
#endif
    {
      ClassDesc2* gupDesc = getHkdToolbarGUPDesc();
      if (gupDesc)
        return gupDesc;
    }
    // fallthrough

  default:
        {
            int totalNumHCTClasses = HCT_NUM_HAVOK_3DSMAX_CLASSES;
            if (isVisionEnabled())
            {
                totalNumHCTClasses += HCT_NUM_VISION_3DSMAX_CLASSES;
            }

            int numGenericModifiers = getHkNumGenericModifiers();

            if (getHkdToolbarGUPDesc() == 0)
            {
                totalNumHCTClasses = totalNumHCTClasses - 1;
            }

            if ( i < (totalNumHCTClasses + numGenericModifiers) )
            {

                // Special case for scripted fracture
#if defined ( HK_FEATURE_PRODUCT_DESTRUCTION_2012 )
                hkGenericModifierDesc* desc = static_cast<hkGenericModifierDesc*>(getHkGenericModifierDesc(i-(totalNumHCTClasses)));
                if ( desc->m_id == hkdScriptedFractureID )
                {
                    return gethkScriptedFractureModifierDesc();
                }
#endif

                return getHkGenericModifierDesc(i-(totalNumHCTClasses));
            }
            return NULL;
        }
    }
}

__declspec( dllexport ) ULONG LibVersion()
{
    return VERSION_3DSMAX;
}

__declspec( dllexport ) ULONG CanAutoDefer()
{
    return 0;
}

static void _registerColors()
{

    IColorManager* theColorManager = GetColorManager();
    if (theColorManager)
    {

        MCHAR colorCategoryStr[200];
        GetStringToBuffer(IDS_HAVOK_PHYSICS_COLOR_CATEGORY, colorCategoryStr, 200);

        theColorManager->RegisterColor(HK_COLOR_CONSTRAINT_PARENT_SPACE,
            GetString(IDS_CONSTRAINT_MODIFIER_COLOR_PARENT_SPACE), colorCategoryStr, RGB(51,255,51));

        theColorManager->RegisterColor(HK_COLOR_CONSTRAINT_CHILD_SPACE,
            GetString(IDS_CONSTRAINT_MODIFIER_COLOR_CHILD_SPACE), colorCategoryStr, RGB(255,51,51));

        theColorManager->RegisterColor(HK_COLOR_CONSTRAINT_VOLUME,
            GetString(IDS_CONSTRAINT_MODIFIER_COLOR_VOLUME), colorCategoryStr, RGB(102,102,102));

        theColorManager->RegisterColor(HK_COLOR_CONSTRAINT_ERROR,
            GetString(IDS_CONSTRAINT_MODIFIER_COLOR_ERROR), colorCategoryStr, RGB(125,21,21));


        theColorManager->RegisterColor(HK_COLOR_RIGIDBODY_LABEL,
            GetString(IDS_RB_MODIFIER_COLOR_LABEL), colorCategoryStr, RGB(255,255,0));

        theColorManager->RegisterColor(HK_COLOR_RIGIDBODY_LABEL_SHADOW,
            GetString(IDS_RB_MODIFIER_COLOR_LABEL_SHADOW), colorCategoryStr, RGB(0,0,0));

        theColorManager->RegisterColor(HK_COLOR_FIXED_RB_LABEL,
            GetString(IDS_RB_MODIFIER_FIXED_COLOR_LABEL), colorCategoryStr, RGB(197,154,0));

        theColorManager->RegisterColor(HK_COLOR_FIXED_RB_LABEL_SHADOW,
            GetString(IDS_RB_MODIFIER_FIXED_COLOR_LABEL_SHADOW), colorCategoryStr, RGB(0,0,0));

        theColorManager->RegisterColor(HK_COLOR_LOCAL_FRAME,
            GetString(IDS_LOCAL_FRAME_COLOR_LABEL), colorCategoryStr, RGB(0,0,0));

        theColorManager->RegisterColor(HK_COLOR_CLOTH,
            GetString(IDS_CLOTH_COLOR), colorCategoryStr, RGB(154, 99, 222)); // NOTE this should be (178,156,219) but it's too pale
    }
}

/*
** UTILITY METHODS
*/

// String table access, returns a string stored in the resources
TCHAR *GetString(int id)
{
    static TCHAR buf[256];

    if (hInstance)
    {
        return LoadString(hInstance, id, buf, sizeof(buf)) ? buf : NULL;
    }

    return NULL;
}

void GetStringToBuffer(int id, TCHAR *buf, int bufSize)
{
    if (hInstance)
    {
        LoadString(hInstance, id, buf, bufSize);
    }
    else
    {
        buf[0] = 0;
    }
}

//COMPAT_REG_ALL

#define HK_EXCLUDE_FEATURE_DestructionRuntime
#define HK_EXCLUDE_FEATURE_hkndAssetProcessing
#define HK_EXCLUDE_FEATURE_hkndDebrisFracture_execute
#define HK_EXCLUDE_FEATURE_hkndParticleEffectFracture_execute
#define HK_EXCLUDE_FEATURE_NewDestructionRuntime
#undef HAVOK_PHYSICS_2012_KEYCODE
#undef HAVOK_PHYSICS_KEYCODE
#undef HK_FEATURE_PRODUCT_PHYSICS
#undef HK_FEATURE_PRODUCT_PHYSICS_2012
#undef HK_FEATURE_PRODUCT_DESTRUCTION
#undef HK_FEATURE_PRODUCT_DESTRUCTION_2012
#undef HK_FEATURE_PRODUCT_FX
// Need to register patches for Cloth Setup Tool
//#undef HK_FEATURE_PRODUCT_CLOTH
#undef HK_FEATURE_PRODUCT_BEHAVIOR
#undef HK_FEATURE_PRODUCT_ANIMATION
#undef HK_FEATURE_PRODUCT_AI
#define HK_CLASSES_FILE <Common/Base/ClassLists/hkCommonClassLists.cxx>
#define HK_EXCLUDE_FEATURE_MemoryTracker
#define HK_EXCLUDE_FEATURE_hkFormatYamlFile
#include <Common/Base/Config/hkProductFeatures.cxx>

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
