// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#pragma warning(disable: 4100) // unused formal param (lots in Max SDK)
#pragma warning(disable: 4458) // declaration of 'XXX' hides class member
#pragma warning(disable: 4238 4239) // nonstandard extension
#pragma warning(disable: 4245) // signed / unsigned
#pragma warning(disable: 4512) // 'DelayedNodeMat' : assignment operator could not be generated
#pragma warning(disable: 4311) // pointer to long
#pragma warning(disable: 4244) // conversion from x to y, possible loss of data
#pragma warning(disable: 4819) // The file contains a character that cannot be represented in the current code page (when building in Japanese OS)

#define _CRT_SECURE_NO_WARNINGS
#if _MSC_VER < 1400
#define USING_VISUAL_STUDIO_7
#endif

// The 3ds Max9 SDK gives warnings when compiling with VS 7.1
#ifdef USING_VISUAL_STUDIO_7
#pragma warning ( disable : 4511)
#endif

#include <maxversion.h>
#if MAX_VERSION_MAJOR>=16
#define WIN64
#endif

#include <Max.h>
#include <istdplug.h>
#include <iparamb2.h>
#include <iparamm2.h>
#include <decomp.h>
#include <Simpmod.h>
#include <Simpobj.h>
#include <modstack.h>
#include <notify.h>
#include <manipulator.h>
#include <splshape.h>
#include <utilapi.h>
#include <gizmo.h>
#include <gizmoimp.h>
#include <iskin.h>
#include <guplib.h>
#include <ActionTable.h> // This is for the keyboard shortcut APIs
#include <imacroscript.h> // This is to use methods of MacroDir and MacroEntry
#include <stdmat.h>
#include <custattrib.h>
#include <dummy.h> // Vision
#include <cs/PhyExp.h>
#include <cs/BipedApi.h>
#define empty _empty

#include <ContentTools/Max/MaxFpInterfaces/hctMaxDefines.h>

// Max incrementally added these M_STD types over version 2010-2013. Define them for previous versions.
#if MAX_VERSION_MAJOR<12

    #include <string>
    typedef std::string M_STD_STRING;

#endif

#if MAX_VERSION_MAJOR<14

    #define M_STD_OSTRINGSTREAM std::ostringstream

#endif

// In Max 2013 (version 15) they decided to rename end to p_end
#if MAX_VERSION_MAJOR<15

    #define p_end end

#endif

// In Max 2013 (version 15) they made the (void*) overload of Write() and Read() private and added WriteVoid() and ReadVoid() public methods instead.
#if MAX_VERSION_MAJOR>=15

    #define WRITEVOID WriteVoid
    #define READVOID ReadVoid

#else

    #define WRITEVOID Write
    #define READVOID Read

#endif

// In max 2013 they switched to Windows UNICODE (UTF-16) from MBCS
#if MAX_VERSION_MAJOR<15

    // MBCS / ANSI
    #define HCT_SCOPED_CONVERSIONS ;
    #define TO_WINDOWS(X)   X
    #define FROM_WINDOWS(X) X
    #define TO_MAX(X)       X

    #define MAX_STRDUP(X)   _strdup(X)

    HK_INLINE const char* FROM_MAX(const MSTR& X) { return X.data(); }
    HK_INLINE const char* FROM_MAX(const char* X) { return X; }

#else

    // UNICODE / UTF-16
    #include <Common/Base/Container/String/hkUtf8.h>

    struct hctScopedConversion
    {
        hctScopedConversion() {}

        ~hctScopedConversion()
        {
            for (int i = 0; i < m_wideStrings.getSize(); i ++)
            {
                free(m_wideStrings[i]);
            }

            for (int i = 0; i < m_utf8Strings.getSize(); i ++)
            {
                free(m_utf8Strings[i]);
            }
        }

        wchar_t* wideFromUtf8(const char* s)
        {
            int count = hkUtf8::wideFromUtf8(HK_NULL, 0, s);
            wchar_t* data = (wchar_t*)malloc(count * sizeof(wchar_t));
            HK_ASSERT_NO_MSG(0x4a1ba49d, data != NULL);

            m_wideStrings.pushBack(data);
            hkUtf8::wideFromUtf8(data, count, s);

            return data;
        }

        const char* utf8FromWide(const wchar_t* s)
        {
            int count = hkUtf8::utf8FromWide(HK_NULL, 0, s);
            char* data = (char*)malloc(count * sizeof(char));
            HK_ASSERT_NO_MSG(0x2506b696, data != NULL);

            m_utf8Strings.pushBack(data);
            hkUtf8::utf8FromWide(data, count, s);

            return data;
        }

        hkArray<wchar_t*> m_wideStrings;
        hkArray<char*> m_utf8Strings;
    };

#define HCT_SCOPED_CONVERSIONS hctScopedConversion __hctScopedConversion;

    #define TO_WINDOWS(X)   __hctScopedConversion.wideFromUtf8(X)
    #define FROM_WINDOWS(X) __hctScopedConversion.utf8FromWide(X)
    #define TO_MAX(X)       TO_WINDOWS(X)
    #define FROM_MAX(X)     FROM_WINDOWS(X)

    #define MAX_STRDUP(X)   _wcsdup(X)

    #if !defined(UNICODE) || !defined(_UNICODE)
    #error "You must define UNICODE and _UNICODE when compiling for max 2013 and later versions"
    #endif

    #if defined(MBCS) || defined(_MBCS)
    #error "You must not define MCBS or _MCBS when compiling for max 2013 and later versions"
    #endif

#endif

#pragma warning (push)
#pragma warning (disable: 4201)

// In max 2010 they moved and renamed the maxscript folders
#if MAX_VERSION_MAJOR>12

    #include <maxscript/maxscript.h>
    #include <maxscript/maxwrapper/maxclasses.h>
    #include <maxscript/foundation/strings.h>   // For some very obscure reason the order of the <Strings.h> include and the <definsfn.h> must not be changed. Otherwise the custom MAXScript functions might not work.
    #include <maxscript/macros/define_instantiation_functions.h>    // For some very obscure reason the order of the <Strings.h> include and the <definsfn.h> must not be changed. Otherwise the custom MAXScript functions might not work.
    #include <maxscript/foundation/arrays.h>
    #include <maxscript/compiler/parser.h>

#else

    #include <maxscrpt/maxscrpt.h>
    #include <maxscrpt/maxclses.h>
    #include <maxscrpt/strings.h>   // For some very obscure reason the order of the <Strings.h> include and the <definsfn.h> must not be changed. Otherwise the custom MAXScript functions might not work.
    #include <maxscrpt/definsfn.h>  // For some very obscure reason the order of the <Strings.h> include and the <definsfn.h> must not be changed. Otherwise the custom MAXScript functions might not work.
    #include <maxscrpt/arrays.h>
    #include <maxscrpt/parser.h>

#endif

#pragma warning (pop)


#undef empty
#if MAX_VERSION_MAJOR<14
#else
#include <INamedSelectionSetManager.h>
#endif

#ifndef FOOTPRINT_CLASS_ID      //max6
#define FOOTPRINT_CLASS_ID Class_ID(0x3011,0)
#endif

#ifndef SKELOBJ_CLASS_ID        //max6
#define SKELOBJ_CLASS_ID Class_ID(0x9125, 0)
#endif

#ifndef BIPED_CLASS_ID          //max6
#define BIPED_CLASS_ID Class_ID(0x9155, 0)
#endif

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
