
@ECHO OFF

REM %1 == The name of the project that called the custom build step
REM %2 == HAVOK_MAX_[VERSION]_PATH (taken from environment variable)
REM %3 == HAVOK_MAX_SAMPLES_PATH (taken from environment variable)
REM %4 == TARGET_PATH (full path to DLL)
REM %5 == "True" if any Destruction support is included, else "False"
REM %6 == "True" if Convex Decomposition support is included, else "False"
REM %7 == "True" if Cloth support is included, else "False"
REM %8 == Project Dir

REM Save re-execution details in redeploy.bat
set REDEPLOY_FILE=%~dp0redeploy_%~n1.bat
if exist %REDEPLOY_FILE% del %REDEPLOY_FILE%
echo %~dpnx0 %* > %REDEPLOY_FILE%

if not "%~3" == "" goto copysamples

REM Only one variant should copy the shared samples files to avoid redundancy and file access failures
echo %~n1 - Shared sample files copy step disabled for this variant.


:copymodellerfiles

if "%~2" == "" goto nomodellerpath

echo %~n1 - Copying modeller-specific files...

set HK_MACROSCRIPTS_DIR=macroscripts

setlocal

REM MaxSceneExport
xcopy scripts\macroscripts\hvkCommon.mcr "%~2\%HK_MACROSCRIPTS_DIR%\" /s /y /r >nul
if errorlevel 1 goto failure

xcopy scripts\startup\hvkCommon.ms "%~2\scripts\startup\" /s /y /r >nul
if errorlevel 1 goto failure

xcopy scripts\havokCommon\*.* "%~2\scripts\havokCommon\" /s /y /r >nul
if errorlevel 1 goto failure

REM Icons
xcopy icons\*.bmp "%~2\UI_ln\Icons\" /s /y /r >nul
xcopy icons\*.bmp "%~2\UI_ln\IconsDark\" /s /y /r >nul
if errorlevel 1 goto failure

REM Physics
xcopy scripts\macroscripts\hvkPhysics.mcr "%~2\%HK_MACROSCRIPTS_DIR%\" /y /r >nul
if errorlevel 1 goto failure

xcopy scripts\startup\hvkPhysics.ms "%~2\scripts\startup\" /y /r >nul
if errorlevel 1 goto failure

xcopy scripts\havokPhysics\*.ms "%~2\scripts\havokPhysics\" /y /s /r >nul
if errorlevel 1 goto failure

xcopy scripts\havokPhysics\*.bmp "%~2\scripts\havokPhysics\" /y /s /r >nul
if errorlevel 1 goto failure

xcopy scripts\havokPhysics\*.txt "%~2\scripts\havokPhysics\" /y /s /r >nul
if errorlevel 1 goto failure

REM Cloth
xcopy scripts\macroscripts\hvkCloth.mcr "%~2\%HK_MACROSCRIPTS_DIR%\" /y /r >nul
if errorlevel 1 goto failure

xcopy scripts\startup\hvkCloth.ms "%~2\scripts\startup\" /y /r >nul
if errorlevel 1 goto failure

xcopy scripts\havokCloth\*.ms "%~2\scripts\havokCloth\" /y /s /r >nul
if errorlevel 1 goto failure

xcopy scripts\havokCloth\*.bmp "%~2\scripts\havokCloth\" /y /s /r >nul
if errorlevel 1 goto failure

REM Destruction
if "%5" == "True" (
	xcopy scripts\macroscripts\hvkDestruction.mcr "%~2\%HK_MACROSCRIPTS_DIR%\" /y /r >nul
	if errorlevel 1 goto failure

	xcopy scripts\startup\hvkDestruction.ms "%~2\scripts\startup\" /y /r >nul
	if errorlevel 1 goto failure

	xcopy scripts\havokDestruction\*.ms "%~2\scripts\havokDestruction\" /y /s /r >nul
	if errorlevel 1 goto failure

	attrib +R "%~2\scripts\havokDestruction\*.*" /s
)

REM Convex Decomposition
if "%6" == "True" (
	xcopy scripts\havokConvexDecomp\convexDecompositionTools\*.ms "%~2\scripts\havokConvexDecomp\convexDecompositionTools\" /y /s /r >nul
	if errorlevel 1 goto failure
	
	attrib +R "%~2\scripts\havokConvexDecomp\convexDecompositionTools\*.*" /s
)

REM Set the destination files to Read Only to make sure we don't change those instead of the originals
attrib +R "%~2\scripts\havokCloth\*.*" /s
attrib +R "%~2\scripts\havokPhysics\*.*" /s
attrib +R "%~2\scripts\startup\hvk*.*"
attrib +R "%~2\%HK_MACROSCRIPTS_DIR%\hvk*.*"

REM copy is used here instead of xcopy so that the file can be renamed.
if not exist "%~2\plugins" mkdir "%~2\plugins"
copy %4 "%~2\plugins\hctMaxSceneExport.dle" /y >nul

REM Copy debug HCT PDBs...
@setlocal enableextensions enabledelayedexpansion
set PDB_SRC_DIR=%~dp4
set PDB_BASENAME=%~n4
set PDB_DEST_DIR="%~2\plugins"
FOR %%a IN ("%PDB_SRC_DIR:~0,-1%") DO SET PDB_SRC_DIR_PARENT=%%~dpa

if %PDB_SRC_DIR%==%PDB_SRC_DIR_PARENT%debug\ if exist "%PDB_SRC_DIR%%PDB_BASENAME%_link.pdb" echo "%PDB_BASENAME%_link.pdb->%PDB_DEST_DIR%"
if %PDB_SRC_DIR%==%PDB_SRC_DIR_PARENT%debug\ if exist "%PDB_SRC_DIR%%PDB_BASENAME%_link.pdb" xcopy "%PDB_SRC_DIR%%PDB_BASENAME%_link.pdb" "%PDB_DEST_DIR%" /s /y /r >nul
endlocal
REM Done copying Debug HCT PDBs

if errorlevel 1 goto failure
echo Files copied to %2

REM Copy the output to file using '>' so that Visual Studio knows that the build step was successful.
echo Files copied to %2 > "%~4.output"
exit /b 0

endlocal


:copysamples

REM Samples
echo %~n1 - Copying shared sample files...

REM Cloth
if "%7" == "True" (
	xcopy "%~8..\..\..\..\Data\ContentTools\Max\MaxSceneExport\Scenes\HavokContentTools\Samples\Cloth\*.*" "%3\Samples\Cloth\" /d /c /s /y /r >nul
	if errorlevel 1 goto failure
)

REM Textures

REM Cloth
if "%7" == "True" (
	xcopy "%~8..\..\..\..\Data\ContentTools\Max\MaxSceneExport\Scenes\HavokContentTools\Textures\*.*" "%3\Textures\" /d /c /s /y /r >nul
	if errorlevel 1 goto failure
)

REM Tutorials

REM Cloth
if "%7" == "True" (
	xcopy "%~8..\..\..\..\Data\ContentTools\Max\MaxSceneExport\Scenes\HavokContentTools\Tutorials\ClothCape\*.*" "%3\Tutorials\ClothCape\" /d /c /s /y /r >nul
	if errorlevel 1 goto failure

	xcopy "%~8..\..\..\..\Data\ContentTools\Max\MaxSceneExport\Scenes\HavokContentTools\Tutorials\ClothRug\*.*" "%3\Tutorials\ClothRug\" /d /c /s /y /r >nul
	if errorlevel 1 goto failure

	xcopy "%~8..\..\..\..\Data\ContentTools\Max\MaxSceneExport\Scenes\HavokContentTools\Tutorials\ClothTrousers\*.*" "%3\Tutorials\ClothTrousers\" /d /c /s /y /r >nul
	if errorlevel 1 goto failure
	
	xcopy "%~8..\..\..\..\Data\ContentTools\Max\MaxSceneExport\Scenes\HavokContentTools\Tutorials\ClothStandalonePipeline\*.*" "%3\Tutorials\ClothStandalonePipeline\" /d /c /s /y /r >nul
	if errorlevel 1 goto failure
)

REM Destruction
if "%5" == "True" (
	xcopy "%~8..\..\..\..\Data\ContentTools\Max\MaxSceneExport\Scenes\HavokContentTools\Tutorials\Destruction\*.*" "%3\Tutorials\Destruction\" /d /c /s /y /r >nul
	if errorlevel 1 goto failure
)

xcopy "%~8..\..\..\..\Data\ContentTools\Max\MaxSceneExport\Scenes\HavokContentTools\Tutorials\ExportBasics\*.*" "%3\Tutorials\ExportBasics\" /d /c /s /y /r >nul
if errorlevel 1 goto failure

xcopy "%~8..\..\..\..\Data\ContentTools\Max\MaxSceneExport\Scenes\HavokContentTools\Tutorials\MoreOnRigidBodies\*.*" "%3\Tutorials\MoreOnRigidBodies\" /d /c /s /y /r >nul
if errorlevel 1 goto failure

xcopy "%~8..\..\..\..\Data\ContentTools\Max\MaxSceneExport\Scenes\HavokContentTools\Tutorials\PhysicsBasics\*.*" "%3\Tutorials\PhysicsBasics\" /d /c /s /y /r >nul
if errorlevel 1 goto failure

xcopy "%~8..\..\..\..\Data\ContentTools\Max\MaxSceneExport\Scenes\HavokContentTools\Tutorials\RagDollToolbox\*.*" "%3\Tutorials\RagDollToolbox\" /d /c /s /y /r >nul
if errorlevel 1 goto failure

xcopy "%~8..\..\..\..\Data\ContentTools\Max\MaxSceneExport\Scenes\HavokContentTools\Tutorials\ToolchainIntegration\*.*" "%3\Tutorials\ToolchainIntegration\" /d /c /s /y /r >nul
if errorlevel 1 goto failure

REM Set the destination files to Read Only to make sure we don't change those instead of the originals
attrib +R "%~3\*.max" /s
attrib +R "%~3\*.xcfg" /s

goto copymodellerfiles


:nomodellerpath

echo WARNING: The relevant HAVOK_MAX_[VERSION]_PATH env var is not defined. The deployment step has been skipped.

REM Copy the output to file using '>' so that Visual Studio knows that the build step was successful.
echo WARNING: The relevant HAVOK_MAX_[VERSION]_PATH env var is not defined. The deployment step has been skipped. > "%~4.output"
exit /b 0


:failure

echo Couldn't copy files to %2... 
echo Make sure 3dsmax is not running and that HAVOK_MAX_[VERSION]_PATH is defined

REM Print an error message for the continuous integration system to detect.
echo ERROR: Custom build step failed.

REM Return an ErrorLevel of 1
exit /b 1

