// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

    // Converts a 3ds max Matrix3 into an hkMatrix4
void hctMaxUtils::convertToMatrix4( Matrix3& in, hkMatrix4& out )
{
    // max matrices are row-major, so we need the transpose
    for (int c=0; c < 4; ++c)
    {
        for (int r=0; r < 3; ++r)
        {
            out(r,c) = in.GetRow(c)[r];
        }
    }
    out(3,0) = 0.0f;
    out(3,1) = 0.0f;
    out(3,2) = 0.0f;
    out(3,3) = 1.0f;
}

void hctMaxUtils::convertToMatrix3( hkMatrix4& in, Matrix3& out )
{
    for (int c=0; c < 4; ++c)
    {
        out.SetRow(c, Point3( in(0,c), in(1,c), in(2,c) ) );
    }
}


hkVector4 hctMaxUtils::asHkVector4 (const Point3& point3)
{
    return hkVector4(point3.x, point3.y, point3.z);
}

float hctMaxUtils::convertHorizontalToVerticalFOV (const float hFov)
{
    const float aspect = GetCOREInterface()->GetRendImageAspect(); // usually 4:3
    const float vFov = float (2.0*atan(tan(hFov/2.0f)/aspect));

    return vFov;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
