// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Max/MaxFpInterfaces/Export/hctSceneExportUtilityInterface.h>


// FUNCTION PUBLISHING

class   hctSceneExportUtilityFPInterfaceImplementation : public hctSceneExportUtilityFPInterface
{
public:
    DECLARE_DESCRIPTOR( hctSceneExportUtilityFPInterfaceImplementation )

    BEGIN_FUNCTION_MAP
        FN_1( FPI_ExportScene, TYPE_BOOL, iExportScene, TYPE_BOOL );

        FN_0 (FPI_OpenVideoBrowser, TYPE_BOOL, iOpenVideoBrowser)
        FN_0 (FPI_OpenContentToolsChm, TYPE_BOOL, iOpenContentToolsChm)
        FN_0 (FPI_GetVersionString, TYPE_STRING, iGetVersionString)
        FN_0 (FPI_GetVersionNumber, TYPE_INT, iGetVersionNumber)
        FN_0 (FPI_WaitForFilterLoad, TYPE_BOOL, iWaitForFilterLoad)
        FN_0(FPI_GetOptionsFileDependencies, TYPE_STRING_TAB, iGetOptionsFileDependencies)

        FN_1( FPI_ImportScene, TYPE_BOOL, iImportScene, TYPE_STRING );

        PROP_FNS (FPI_GetExportVisibleOnly, iGetExportVisibleOnly, FPI_SetExportVisibleOnly, iSetExportVisibleOnly, TYPE_BOOL)
        PROP_FNS (FPI_GetExportSelectedOnly, iGetExportSelectedOnly, FPI_SetExportSelectedOnly, iSetExportSelectedOnly, TYPE_BOOL)
        PROP_FNS (FPI_GetExportMeshes, iGetExportMeshes, FPI_SetExportMeshes, iSetExportMeshes, TYPE_BOOL)
        PROP_FNS (FPI_GetExportMaterials, iGetExportMaterials, FPI_SetExportMaterials, iSetExportMaterials, TYPE_BOOL)
        PROP_FNS (FPI_GetExportAttributes, iGetExportAttributes, FPI_SetExportAttributes, iSetExportAttributes, TYPE_BOOL)
        PROP_FNS (FPI_GetExportAnnotations, iGetExportAnnotations, FPI_SetExportAnnotations, iSetExportAnnotations, TYPE_BOOL)
        PROP_FNS (FPI_GetExportLights, iGetExportLights, FPI_SetExportLights, iSetExportLights, TYPE_BOOL)
        PROP_FNS (FPI_GetExportCameras, iGetExportCameras, FPI_SetExportCameras, iSetExportCameras, TYPE_BOOL)
        PROP_FNS (FPI_GetAddDefaultCamera, iGetAddDefaultCamera, FPI_SetAddDefaultCamera, iSetAddDefaultCamera, TYPE_BOOL)

        PROP_FNS (FPI_GetAnimatedDataExport, iGetAnimatedDataExport, FPI_SetAnimatedDataExport, iSetAnimatedDataExport, TYPE_ENUM)
        PROP_FNS (FPI_GetAnimationStart, iGetAnimationStart, FPI_SetAnimationStart, iSetAnimationStart, TYPE_TIMEVALUE)
        PROP_FNS (FPI_GetAnimationEnd, iGetAnimationEnd, FPI_SetAnimationEnd, iSetAnimationEnd, TYPE_TIMEVALUE)

        PROP_FNS (FPI_GetUseOptionsFile,iGetUseOptionsFile, FPI_SetUseOptionsFile, iSetUseOptionsFile, TYPE_BOOL)
        PROP_FNS (FPI_GetOptionsFile,iGetOptionsFile, FPI_SetOptionsFile, iSetOptionsFile, TYPE_STRING)
        PROP_FNS(FPI_GetUseConfigurationSet, iGetUseConfigurationSet, FPI_SetUseConfigurationSet, iSetUseConfigurationSet, TYPE_BOOL)
        PROP_FNS(FPI_GetConfigurationSet, iGetConfigurationSet, FPI_SetConfigurationSet, iSetConfigurationSet, TYPE_STRING)
        PROP_FNS (FPI_GetEnvironmentVariables, iGetEnvironmentVariables, FPI_SetEnvironmentVariables, iSetEnvironmentVariables, TYPE_STRING)

        PROP_FNS (FPI_GetDoNotSplitVertices, iGetDoNotSplitVertices, FPI_SetDoNotSplitVertices, iSetDoNotSplitVertices, TYPE_BOOL)

        PROP_FNS (FPI_GetRespectModifierSkinPose, iGetRespectModifierSkinPose, FPI_SetRespectModifierSkinPose, iSetRespectModifierSkinPose, TYPE_BOOL)
        PROP_FNS (FPI_GetAutoSkinAttachments, iGetAutoSkinAttachments, FPI_SetAutoSkinAttachments, iSetAutoSkinAttachments, TYPE_BOOL)
        PROP_FNS (FPI_GetExportWireColorsAsVertexColors, iGetExportWireColorsAsVertexColors, FPI_SetExportWireColorsAsVertexColors, iSetExportWireColorsAsVertexColors, TYPE_BOOL)
        PROP_FNS (FPI_GetExportMergeVertsOnlyIfSameSrcId, iGetExportMergeVertsOnlyIfSameSrcId, FPI_SetExportMergeVertsOnlyIfSameSrcId, iSetExportMergeVertsOnlyIfSameSrcId, TYPE_BOOL)
        PROP_FNS (FPI_GetStoreKeyframeSamplePoints, iGetStoreKeyframeSamplePoints, FPI_SetStoreKeyframeSamplePoints, iSetStoreKeyframeSamplePoints, TYPE_BOOL)

    END_FUNCTION_MAP

    /*virtual*/ BOOL iExportScene( BOOL batchMode);
    /*virtual*/ BOOL iImportScene( const MCHAR* pathToHKX );
    /*virtual*/ BOOL iWaitForFilterLoad();

    /*virtual*/ void iSetExportVisibleOnly( BOOL exportHidden );
    /*virtual*/ BOOL iGetExportVisibleOnly();

    /*virtual*/ void iSetExportSelectedOnly( BOOL selectedOnly );
    /*virtual*/ BOOL iGetExportSelectedOnly();

    /*virtual*/ void iSetExportMeshes( BOOL exportMeshes );
    /*virtual*/ BOOL iGetExportMeshes();

    /*virtual*/ void iSetExportMaterials( BOOL exportMaterials );
    /*virtual*/ BOOL iGetExportMaterials();

    /*virtual*/ void iSetExportAttributes( BOOL exportAttributes );
    /*virtual*/ BOOL iGetExportAttributes();

    /*virtual*/ void iSetExportAnnotations( BOOL exportAnnotations );
    /*virtual*/ BOOL iGetExportAnnotations();

    /*virtual*/ void iSetExportLights( BOOL exportLights );
    /*virtual*/ BOOL iGetExportLights();

    /*virtual*/ void iSetExportCameras( BOOL exportCameras );
    /*virtual*/ BOOL iGetExportCameras();

    /*virtual*/ void iSetAddDefaultCamera (BOOL addDefaultCamera);
    /*virtual*/ BOOL iGetAddDefaultCamera();


    /*virtual*/ void iSetAnimatedDataExport (int animatedDataExport);
    /*virtual*/ int iGetAnimatedDataExport ();

    /*virtual*/ void iSetAnimationStart (TimeValue startTick);
    /*virtual*/ TimeValue iGetAnimationStart ();

    /*virtual*/ void iSetAnimationEnd (TimeValue endTick);
    /*virtual*/ TimeValue iGetAnimationEnd ();


    /*virtual*/ void iSetUseOptionsFile( BOOL useOptionsFile );
    /*virtual*/ BOOL iGetUseOptionsFile();

    /*virtual*/ void iSetOptionsFile( CONST15 MCHAR* optionsFile );
    /*virtual*/ CONST12 MCHAR* iGetOptionsFile();

    /*virtual*/ void iSetUseConfigurationSet(BOOL useConfigurationSet);
    /*virtual*/ BOOL iGetUseConfigurationSet();

    /*virtual*/ void iSetConfigurationSet(CONST15 MCHAR* useConfigurationSet);
    /*virtual*/ CONST12 MCHAR* iGetConfigurationSet();

    /*virtual*/ void iSetEnvironmentVariables( CONST15 MCHAR* environmentVars );
    /*virtual*/ CONST12 MCHAR* iGetEnvironmentVariables();

    /*virtual*/  void iSetDoNotSplitVertices (BOOL doNotSplitVertices);
    /*virtual*/  BOOL iGetDoNotSplitVertices ();

    /*virtual*/ const MCHAR* iGetVersionString ();

    /*virtual*/ int iGetVersionNumber ();

    /*virtual*/ BOOL iGetFilterSetOptions(void** optionsBufferPtr, int* size, int* ver  );
    /*virtual*/ BOOL iGetExportOptions(struct hctMaxSceneExportOptions* exportOptions );

    /*virtual*/ BOOL iOpenVideoBrowser();
    /*virtual*/ BOOL iOpenContentToolsChm();

    // EXP-2481 Expose more options
    /*virtual*/ BOOL iGetRespectModifierSkinPose ();
    /*virtual*/ void iSetRespectModifierSkinPose (BOOL );

    /*virtual*/ BOOL iGetAutoSkinAttachments ();
    /*virtual*/ void iSetAutoSkinAttachments (BOOL );

    /*virtual*/ BOOL iGetExportWireColorsAsVertexColors ();
    /*virtual*/ void iSetExportWireColorsAsVertexColors (BOOL );

    /*virtual*/ BOOL iGetExportMergeVertsOnlyIfSameSrcId ();
    /*virtual*/ void iSetExportMergeVertsOnlyIfSameSrcId (BOOL);

    /*virtual*/ BOOL iGetStoreKeyframeSamplePoints ();
    /*virtual*/ void iSetStoreKeyframeSamplePoints (BOOL);

    /*virtual*/ Tab<MSTR>* iGetOptionsFileDependencies();
};

// ACTIONS

class hctSceneExportUtilityActionsImplementation : public hctSceneExportUtilityActions
{
    public:

        DECLARE_DESCRIPTOR(hctSceneExportUtilityActionsImplementation)

        BEGIN_FUNCTION_MAP
            FN_ACTION(ACT_Export, doExport);
            FN_PRED(ACT_Export_Enabled, isExportEnabled);
        END_FUNCTION_MAP

        /*virtual*/ FPStatus doExport();
        /*virtual*/ BOOL isExportEnabled();
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
