// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>

#include <ContentTools/Max/MaxSceneExport/Utilities/hctSceneExportUtility.h>
#include <ContentTools/Max/MaxSceneExport/Utilities/hctSceneExportUtility_FPI.h>

/* FP INTERFACES */

static hctSceneExportUtilityFPInterfaceImplementation theFPInterfaceImplementation (
    HK_SCENE_EXPORT_UTILITY_FPINTERFACE_ID, _T("hkSceneExportUtilityInterface"), 0, getHkSceneExportUtilityDesc(), 0,

    FPI_ExportScene, _T("exportScene"), IDS_EXPORT_UTILITY_ACTION_EXPORT_SCENE, TYPE_BOOL, 0, 1, _T("batchMode"), IDS_EXPORT_UTILITY_PA_BATCH_MODE, TYPE_BOOL,
    FPI_GetOptionsFileDependencies, _T("getFileDependencies"), IDS_EXPORT_UTILITY_GET_FILE_DEPENDENCIES, TYPE_STRING_TAB, 0, 0,
    FPI_OpenVideoBrowser, _T("openVideoBrowser"), IDS_EXPORT_UTILITY_ACTION_OPEN_VIDEOBROWSER, TYPE_BOOL, 0, 0,
    FPI_OpenContentToolsChm, _T("openContentToolsChm"), IDS_EXPORT_UTILITY_ACTION_OPEN_CONTENTTOOLS_CHM, TYPE_BOOL, 0, 0,

    FPI_GetVersionString, _T("getVersionString"), IDS_EXPORT_UTILITY_PA_VERSION_STRING, TYPE_STRING, 0, 0,
    FPI_GetVersionNumber, _T("getVersionNumber"), IDS_EXPORT_UTILITY_PA_VERSION_NUMBER, TYPE_INT, 0, 0,
    FPI_WaitForFilterLoad, _T("waitForFilterLoad"), IDS_EXPORT_UTILITY_ACTION_WAIT_FOR_FILTER_LOAD, TYPE_BOOL, 0, 0,

    FPI_ImportScene, _T("importScene"), IDS_EXPORT_UTILITY_ACTION_IMPORT_SCENE, TYPE_BOOL, 0, 1, _T("path"), IDS_EXPORT_UTILITY_PA_IMPORT_PATH, TYPE_STRING,

    properties,

    FPI_GetExportVisibleOnly, FPI_SetExportVisibleOnly, _T("exportVisibleOnly"), IDS_EXPORT_UTILITY_PA_VISIBLE_ONLY  , TYPE_BOOL,
    FPI_GetExportSelectedOnly, FPI_SetExportSelectedOnly, _T("exportSelectedOnly"), IDS_EXPORT_UTILITY_PA_SELECTED_ONLY  , TYPE_BOOL,
    FPI_GetExportMeshes, FPI_SetExportMeshes, _T("exportMeshes"), IDS_EXPORT_UTILITY_PA_EXPORT_MESHES  , TYPE_BOOL,
    FPI_GetExportMaterials, FPI_SetExportMaterials, _T("exportMaterials"), IDS_EXPORT_UTILITY_PA_EXPORT_MATERIALS  , TYPE_BOOL,
    FPI_GetExportAttributes, FPI_SetExportAttributes, _T("exportAttributes"), IDS_EXPORT_UTILITY_PA_EXPORT_ATTRIBUTES  , TYPE_BOOL,
    FPI_GetExportAnnotations, FPI_SetExportAnnotations, _T("exportAnnotations"), IDS_EXPORT_UTILITY_PA_EXPORT_ANNOTATIONS  , TYPE_BOOL,
    FPI_GetExportLights, FPI_SetExportLights, _T("exportLights"), IDS_EXPORT_UTILITY_PA_EXPORT_LIGHTS  , TYPE_BOOL,
    FPI_GetExportCameras, FPI_SetExportCameras, _T("exportCameras"), IDS_EXPORT_UTILITY_PA_EXPORT_CAMERAS  , TYPE_BOOL,
    FPI_GetAddDefaultCamera, FPI_SetAddDefaultCamera, _T("addDefaultCamera"), IDS_EXPORT_UTILITY_PA_ADD_DEFAULT_CAMERA, TYPE_BOOL,

    FPI_GetAnimatedDataExport, FPI_SetAnimatedDataExport, _T("animatedDataExport"), IDS_EXPORT_UTILITY_PA_ANIMATED_DATA_EXPORT, TYPE_ENUM, FPI_ENUM_AnimatedDataExport,
    FPI_GetAnimationStart, FPI_SetAnimationStart, _T("animationStart"), IDS_EXPORT_UTILITY_PA_ANIMATION_START, TYPE_TIMEVALUE,
    FPI_GetAnimationEnd, FPI_SetAnimationEnd, _T("animationEnd"), IDS_EXPORT_UTILITY_PA_ANIMATION_END, TYPE_TIMEVALUE,

    FPI_GetUseOptionsFile, FPI_SetUseOptionsFile, _T("useOptionsFile"), IDS_EXPORT_UTILITY_PA_USE_OPTIONS_FILE, TYPE_BOOL,
    FPI_GetOptionsFile, FPI_SetOptionsFile, _T("optionsFile"), IDS_EXPORT_UTILITY_PA_OPTIONS_FILE, TYPE_STRING,
    FPI_GetUseConfigurationSet, FPI_SetUseConfigurationSet, _T("useConfigurationSet"), IDS_EXPORT_UTILITY_PA_USE_CONFIGURATION_SET, TYPE_BOOL,
    FPI_GetConfigurationSet, FPI_SetConfigurationSet, _T("configurationSet"), IDS_EXPORT_UTILITY_PA_CONFIGURATION_SET, TYPE_STRING,

    FPI_GetEnvironmentVariables, FPI_SetEnvironmentVariables, _T("environmentVariables"), IDS_EXPORT_UTILITY_PA_ENVIRONMENT_VARIABLES, TYPE_STRING,

    FPI_GetDoNotSplitVertices, FPI_SetDoNotSplitVertices, _T("doNotSplitVertices"), IDS_EXPORT_UTILITY_PA_DO_NOT_SPLIT_VERTICES, TYPE_BOOL,

    FPI_GetRespectModifierSkinPose, FPI_SetRespectModifierSkinPose, _T("respectModifierSkinPose"), IDS_EXPORT_UTILITY_PA_RESPECT_MODIFIER_SKIN_POSE, TYPE_BOOL,
    FPI_GetAutoSkinAttachments, FPI_SetAutoSkinAttachments, _T("autoSkinAttachments"), IDS_EXPORT_UTILITY_PA_AUTO_SKIN_ATTACHMENTS, TYPE_BOOL,
    FPI_GetExportWireColorsAsVertexColors, FPI_SetExportWireColorsAsVertexColors, _T("exportWireColorsAsVertexColors"), IDS_EXPORT_UTILITY_PA_EXPORT_WIRE_COLORS_AS_VERTEX_COLORS, TYPE_BOOL,
    FPI_GetExportMergeVertsOnlyIfSameSrcId, FPI_SetExportMergeVertsOnlyIfSameSrcId, _T("exportMergeVertsOnlyIfSameSrcId"), IDS_EXPORT_UTILITY_PA_EXPORT_MERGE_VERTS_ONLY_IF_SAME_SRC_ID, TYPE_BOOL,
    FPI_GetStoreKeyframeSamplePoints, FPI_SetStoreKeyframeSamplePoints, _T("storeKeyframeSamplePoints"), IDS_EXPORT_UTILITY_PA_KEYFRAME_SAMPLE_POINTS, TYPE_BOOL,

    enums,

    FPI_ENUM_AnimatedDataExport, 3,
        _T("current"), ADE_CURRENT_FRAME,
        _T("currentRange"), ADE_CURRENT_RANGE,
        _T("specificRange"), ADE_SPECIFIC_RANGE,

    p_end
);


// EXPORT

BOOL hctSceneExportUtilityFPInterfaceImplementation::iExportScene( BOOL batchMode)
{
    bool okVal = getSceneExportUtilityInstance()->exportScene(batchMode);
    return okVal ? TRUE : FALSE;
}

BOOL hctSceneExportUtilityFPInterfaceImplementation::iImportScene( const MCHAR* path)
{
    bool okVal = getSceneExportUtilityInstance()->importScene(path);
    return okVal ? TRUE : FALSE;
}

BOOL hctSceneExportUtilityFPInterfaceImplementation::iOpenVideoBrowser()
{
    bool okVal = getSceneExportUtilityInstance()->openVideoBrowser();
    return okVal ? TRUE : FALSE;
}

BOOL hctSceneExportUtilityFPInterfaceImplementation::iOpenContentToolsChm()
{
    bool okVal = getSceneExportUtilityInstance()->openContentToolsChm();
    return okVal ? TRUE : FALSE;
}

BOOL hctSceneExportUtilityFPInterfaceImplementation::iWaitForFilterLoad()
{
    bool okVal = getSceneExportUtilityInstance()->waitOnBackgroundFilterLoad();
    return okVal ? TRUE : FALSE;
}

const MCHAR* hctSceneExportUtilityFPInterfaceImplementation::iGetVersionString ()
{
    return TEXT(HCT_CURRENT_VERSION_STRING);
}

int hctSceneExportUtilityFPInterfaceImplementation::iGetVersionNumber ()
{
    return HCT_CURRENT_VERSION;
}

// SCENE DATA

void hctSceneExportUtilityFPInterfaceImplementation::iSetExportVisibleOnly( BOOL exportHidden )
{
    getSceneExportUtilityInstance()->m_pbSceneExport->SetValue( PA_VisibleOnly, 0, exportHidden );
}

BOOL hctSceneExportUtilityFPInterfaceImplementation::iGetExportVisibleOnly()
{
    return ( getSceneExportUtilityInstance()->m_pbSceneExport->GetInt( PA_VisibleOnly ) );
}

void hctSceneExportUtilityFPInterfaceImplementation::iSetExportSelectedOnly( BOOL selectedOnly )
{
    getSceneExportUtilityInstance()->m_pbSceneExport->SetValue( PA_SelectedOnly, 0, selectedOnly );
}

BOOL hctSceneExportUtilityFPInterfaceImplementation::iGetExportSelectedOnly()
{
    return ( getSceneExportUtilityInstance()->m_pbSceneExport->GetInt( PA_SelectedOnly ) );
}

void hctSceneExportUtilityFPInterfaceImplementation::iSetExportMeshes( BOOL exportMeshes )
{
    getSceneExportUtilityInstance()->m_pbSceneExport->SetValue( PA_ExportMeshes, 0, exportMeshes );
}

BOOL hctSceneExportUtilityFPInterfaceImplementation::iGetExportMeshes()
{
    return ( getSceneExportUtilityInstance()->m_pbSceneExport->GetInt( PA_ExportMeshes )  );
}

void hctSceneExportUtilityFPInterfaceImplementation::iSetExportMaterials( BOOL exportMaterials )
{
    getSceneExportUtilityInstance()->m_pbSceneExport->SetValue( PA_ExportMaterials, 0, exportMaterials );
}

BOOL hctSceneExportUtilityFPInterfaceImplementation::iGetExportMaterials()
{
    return ( getSceneExportUtilityInstance()->m_pbSceneExport->GetInt( PA_ExportMaterials ) );
}

void hctSceneExportUtilityFPInterfaceImplementation::iSetExportAttributes( BOOL exportAttributes )
{
    getSceneExportUtilityInstance()->m_pbSceneExport->SetValue( PA_ExportAttributes, 0, exportAttributes );
}

BOOL hctSceneExportUtilityFPInterfaceImplementation::iGetExportAttributes()
{
    return ( getSceneExportUtilityInstance()->m_pbSceneExport->GetInt( PA_ExportAttributes ) );
}

void hctSceneExportUtilityFPInterfaceImplementation::iSetExportAnnotations( BOOL exportAnnotations )
{
    getSceneExportUtilityInstance()->m_pbSceneExport->SetValue( PA_ExportAnnotations, 0, exportAnnotations );
}

BOOL hctSceneExportUtilityFPInterfaceImplementation::iGetExportAnnotations()
{
    return ( getSceneExportUtilityInstance()->m_pbSceneExport->GetInt( PA_ExportAnnotations ) );
}

void hctSceneExportUtilityFPInterfaceImplementation::iSetExportLights( BOOL exportLights )
{
    getSceneExportUtilityInstance()->m_pbSceneExport->SetValue( PA_ExportLights, 0, exportLights );
}

BOOL hctSceneExportUtilityFPInterfaceImplementation::iGetExportLights()
{
    return ( getSceneExportUtilityInstance()->m_pbSceneExport->GetInt( PA_ExportLights ) );
}

void hctSceneExportUtilityFPInterfaceImplementation::iSetExportCameras( BOOL exportCameras )
{
    getSceneExportUtilityInstance()->m_pbSceneExport->SetValue( PA_ExportCameras, 0, exportCameras );
}

BOOL hctSceneExportUtilityFPInterfaceImplementation::iGetExportCameras()
{
    return ( getSceneExportUtilityInstance()->m_pbSceneExport->GetInt( PA_ExportCameras ) );
}

void hctSceneExportUtilityFPInterfaceImplementation::iSetAddDefaultCamera( BOOL addDefaultCamera )
{
    getSceneExportUtilityInstance()->m_pbSceneExport->SetValue( PA_AddDefaultCamera, 0, addDefaultCamera );
}

BOOL hctSceneExportUtilityFPInterfaceImplementation::iGetAddDefaultCamera()
{
    return ( getSceneExportUtilityInstance()->m_pbSceneExport->GetInt( PA_AddDefaultCamera ) );
}

// FILTER SETUP

void hctSceneExportUtilityFPInterfaceImplementation::iSetUseOptionsFile( BOOL useOptionsFile )
{
    getSceneExportUtilityInstance()->m_pbSceneExport->SetValue( PA_UseOptionsFile, 0, useOptionsFile );
}

BOOL hctSceneExportUtilityFPInterfaceImplementation::iGetUseOptionsFile()
{
    return ( getSceneExportUtilityInstance()->m_pbSceneExport->GetInt( PA_UseOptionsFile )  );
}

void hctSceneExportUtilityFPInterfaceImplementation::iSetOptionsFile( CONST15 MCHAR* optionsFile )
{
    getSceneExportUtilityInstance()->m_pbSceneExport->SetValue( PA_OptionsFile, 0, optionsFile );
}

CONST12 MCHAR* hctSceneExportUtilityFPInterfaceImplementation::iGetOptionsFile()
{
    return getSceneExportUtilityInstance()->m_pbSceneExport->GetStr( PA_OptionsFile );
}

void hctSceneExportUtilityFPInterfaceImplementation::iSetUseConfigurationSet(BOOL useConfigurationSet)
{
    getSceneExportUtilityInstance()->m_pbSceneExport->SetValue(PA_UseConfigurationSet, 0, useConfigurationSet);
}

BOOL hctSceneExportUtilityFPInterfaceImplementation::iGetUseConfigurationSet()
{
    return (getSceneExportUtilityInstance()->m_pbSceneExport->GetInt(PA_UseConfigurationSet));
}

void hctSceneExportUtilityFPInterfaceImplementation::iSetConfigurationSet(CONST15 MCHAR* configurationSet)
{
    getSceneExportUtilityInstance()->m_pbSceneExport->SetValue(PA_ConfigurationSet, 0, configurationSet);
}

CONST12 MCHAR* hctSceneExportUtilityFPInterfaceImplementation::iGetConfigurationSet()
{
    return getSceneExportUtilityInstance()->m_pbSceneExport->GetStr(PA_ConfigurationSet);
}

void hctSceneExportUtilityFPInterfaceImplementation::iSetEnvironmentVariables( CONST15 MCHAR* optionsFile )
{
    getSceneExportUtilityInstance()->m_pbSceneExport->SetValue( PA_EnvironmentVariables, 0, optionsFile );
}

CONST12 MCHAR* hctSceneExportUtilityFPInterfaceImplementation::iGetEnvironmentVariables()
{
    return getSceneExportUtilityInstance()->m_pbSceneExport->GetStr( PA_EnvironmentVariables );
}


// ADVANCED

void hctSceneExportUtilityFPInterfaceImplementation::iSetDoNotSplitVertices( BOOL doNotSplitVertices )
{
    getSceneExportUtilityInstance()->m_pbSceneExport->SetValue( PA_DoNotSplitVertices, 0, doNotSplitVertices );
}

BOOL hctSceneExportUtilityFPInterfaceImplementation::iGetDoNotSplitVertices()
{
    return getSceneExportUtilityInstance()->m_pbSceneExport->GetInt( PA_DoNotSplitVertices ) ;
}

// EXP-2481 More options

void hctSceneExportUtilityFPInterfaceImplementation::iSetRespectModifierSkinPose( BOOL respectModifierSkinPose )
{
    getSceneExportUtilityInstance()->m_pbSceneExport->SetValue( PA_RespectModifierSkinPose, 0, respectModifierSkinPose );
}

BOOL hctSceneExportUtilityFPInterfaceImplementation::iGetRespectModifierSkinPose()
{
    return getSceneExportUtilityInstance()->m_pbSceneExport->GetInt( PA_RespectModifierSkinPose ) ;
}

void hctSceneExportUtilityFPInterfaceImplementation::iSetAutoSkinAttachments( BOOL autoSkinAttachments )
{
    getSceneExportUtilityInstance()->m_pbSceneExport->SetValue( PA_AutoSkinAttachments, 0, autoSkinAttachments );
}

BOOL hctSceneExportUtilityFPInterfaceImplementation::iGetAutoSkinAttachments()
{
    return getSceneExportUtilityInstance()->m_pbSceneExport->GetInt( PA_AutoSkinAttachments ) ;
}

void hctSceneExportUtilityFPInterfaceImplementation::iSetExportWireColorsAsVertexColors( BOOL exportWireColorsAsVertexColors )
{
    getSceneExportUtilityInstance()->m_pbSceneExport->SetValue( PA_ExportWireColorsAsVertexColors, 0, exportWireColorsAsVertexColors );
}

BOOL hctSceneExportUtilityFPInterfaceImplementation::iGetExportWireColorsAsVertexColors()
{
    return getSceneExportUtilityInstance()->m_pbSceneExport->GetInt( PA_ExportWireColorsAsVertexColors ) ;
}

void hctSceneExportUtilityFPInterfaceImplementation::iSetExportMergeVertsOnlyIfSameSrcId( BOOL exportMergeVertsOnlyIfSameSrcId )
{
    getSceneExportUtilityInstance()->m_pbSceneExport->SetValue( PA_ExportMergeVertsOnlyIfSameSrcId, 0, exportMergeVertsOnlyIfSameSrcId );
}

BOOL hctSceneExportUtilityFPInterfaceImplementation::iGetExportMergeVertsOnlyIfSameSrcId()
{
    return getSceneExportUtilityInstance()->m_pbSceneExport->GetInt( PA_ExportMergeVertsOnlyIfSameSrcId ) ;
}

void hctSceneExportUtilityFPInterfaceImplementation::iSetStoreKeyframeSamplePoints( BOOL storeKeyframeSamplePoints )
{
    getSceneExportUtilityInstance()->m_pbSceneExport->SetValue( PA_StoreKeyframeSamplePoints, 0, storeKeyframeSamplePoints );
}

BOOL hctSceneExportUtilityFPInterfaceImplementation::iGetStoreKeyframeSamplePoints()
{
    return getSceneExportUtilityInstance()->m_pbSceneExport->GetInt( PA_StoreKeyframeSamplePoints ) ;
}

// FRAME RANGE

void hctSceneExportUtilityFPInterfaceImplementation::iSetAnimatedDataExport (int animatedDataExport)
{
    getSceneExportUtilityInstance()->m_pbSceneExport->SetValue( PA_AnimatedDataExport, 0, animatedDataExport );
}

int hctSceneExportUtilityFPInterfaceImplementation::iGetAnimatedDataExport ()
{
    return ( getSceneExportUtilityInstance()->m_pbSceneExport->GetInt( PA_AnimatedDataExport ) );
}

void hctSceneExportUtilityFPInterfaceImplementation::iSetAnimationStart (TimeValue startTick)
{
    getSceneExportUtilityInstance()->m_pbSceneExport->SetValue( PA_AnimationStart, 0, startTick );
}
TimeValue hctSceneExportUtilityFPInterfaceImplementation::iGetAnimationStart ()
{
    return ( getSceneExportUtilityInstance()->m_pbSceneExport->GetInt( PA_AnimationStart ) );
}

void hctSceneExportUtilityFPInterfaceImplementation::iSetAnimationEnd (TimeValue endTick)
{
    getSceneExportUtilityInstance()->m_pbSceneExport->SetValue( PA_AnimationEnd, 0, endTick );
}

TimeValue hctSceneExportUtilityFPInterfaceImplementation::iGetAnimationEnd ()
{
    return ( getSceneExportUtilityInstance()->m_pbSceneExport->GetInt( PA_AnimationEnd ) );
}

/* C++ only I/f */

BOOL hctSceneExportUtilityFPInterfaceImplementation::iGetFilterSetOptions(void** optionsBufferPtr, int* size, int* ver )
{
    hctSceneExportUtility* util = getSceneExportUtilityInstance();
    *size = util->m_filterSetOptions.m_data.Count();
    if (*size > 0)
    {
        *optionsBufferPtr = util->m_filterSetOptions.m_data.Addr(0);
    }
    else
    {
        *optionsBufferPtr = HK_NULL;
    }
    *ver = (int)util->m_filterSetOptions.m_version;
    return TRUE;
}

BOOL hctSceneExportUtilityFPInterfaceImplementation::iGetExportOptions(struct hctMaxSceneExportOptions* exportOptions )
{
    hctSceneExportUtility* util = getSceneExportUtilityInstance();
    util->getExportOptions(*exportOptions);
    return TRUE;
}

Tab<MSTR>* hctSceneExportUtilityFPInterfaceImplementation::iGetOptionsFileDependencies()
{
    hctSceneExportUtility* util = getSceneExportUtilityInstance();

    Tab<MSTR*> fileDependencies;
    {
        util->getOptionsFileDependencies(fileDependencies);
    }

    Tab<MSTR> tmp;
    for (int i = 0; i < fileDependencies.Count(); i++)
    {
        tmp.Append(1, &(fileDependencies[i]->ToMSTR()));
    }

    // copy the array
    return new Tab<MSTR>(tmp);
}

/* ACTIONS */

static hctSceneExportUtilityActionsImplementation theActionsImplementation (
    HK_SCENE_EXPORT_UTILITY_ACTIONS_ID, _T("hkSceneExportUtilityActions"), 0, getHkSceneExportUtilityDesc(), FP_ACTIONS, kActionMainUIContext,

    ACT_Export, _T("doExport"), IDS_EXPORT_UTILITY_ACTION_EXPORT_SCENE, 0,
    f_isEnabled, ACT_Export_Enabled,
    f_category, _T("havokExport"), IDS_EXPORT_UTILITY_CATEGORY_ACTIONS,
    //f_iconRes, IDI_CREATE_ICON.
    f_ui, PB_SceneExport, 0, TYPE_BUTTON, IDC_B_EXPORT_SCENE,
    p_end,
p_end);


FPStatus hctSceneExportUtilityActionsImplementation::doExport()
{
    // Export in non-batch mode
    bool success = getSceneExportUtilityInstance()->exportScene(FALSE);

    return success ? FPS_OK: FPS_FAIL;
}

BOOL hctSceneExportUtilityActionsImplementation::isExportEnabled()
{
    // TEST
    return TRUE;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
