// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>

#include <ContentTools/Max/MaxSceneExport/Utilities/hctSceneExportUtility.h>
#include <ContentTools/Max/MaxFpInterfaces/Export/hctSceneExportUtilityInterface.h>
#include <ContentTools/Max/MaxSceneExport/Importer/MeshImport/hctMaxMeshImport.h>
#include <ContentTools/Max/MaxSceneExport/Utils/hctMaxUtils.h>

#include <Common/GeometryUtilities/Mesh/Converters/SceneDataToMesh/hkSceneDataToMeshConverter.h>
#include <Common/GeometryUtilities/Mesh/hkMeshBody.h>
#include <Common/GeometryUtilities/Mesh/Memory/hkMemoryMeshBody.h>
#include <Common/GeometryUtilities/Mesh/Memory/hkMemoryMeshSystem.h>
#include <Common/GeometryUtilities/Mesh/Default/hkDefaultMeshMaterialRegistry.h>

#include <Common/SceneData/Scene/hkxSceneUtils.h>
#include <Common/Base/Serialize/Resource/hkResource.h>
#include <ContentTools/Common/SdkUtils/Scene/hctSceneUtils.h>

static void _createMeshNodesRecursive(hkxScene* scene, hkxNode* node, hkMeshSystem* meshSys )
{
    hkxMesh* mesh = hkxSceneUtils::getMeshFromNode(node);
    if (mesh)
    {
        hkMeshShape* meshShape = hkSceneDataToMeshConverter::convert(meshSys, HK_NULL, scene, node, hkSceneDataToMeshConverter::SPACE_ONLY_USING_SCALE_SKEW);
        if (meshShape)
        {
            hkMeshBody* meshObject = new hkMemoryMeshBody(meshSys, meshShape, node->m_keyFrames[0], HK_NULL );

            Tab<INode*> emptyScene;
            INode* newNode = hctMaxSceneConvertUtilities::createNodeFromMesh( *meshObject, HK_NULL, emptyScene, HK_NULL );
            if (newNode == HK_NULL)
            {
                HK_WARN_ALWAYS(0xabbaf964, "Could not create mesh node for " << node->m_name);
            }
            else
            {
                // in scene now, so not much to do here.
            }
        }
        else
        {
            HK_WARN_ALWAYS(0xabbab0bc, "Could not create mesh interface for " << node->m_name);
        }
    }

    for (int c=0; c < node->m_children.getSize(); ++c)
    {
        _createMeshNodesRecursive( scene, node->m_children[c], meshSys);
    }
}

static hctFilterProcessingUtil* loadAllAvailableClasses()
{
    hkStringOld filterManagerPath;
    hctFilterProcessingUtil* filterUtil = new hctFilterProcessingUtil();
    if ( hctMaxUtils::getFilterManagerPath( filterManagerPath ) )
    {
        filterUtil->load( filterManagerPath.cString() );
    }
    else
    {
        filterUtil->load( HK_NULL );
    }

    return filterUtil;
}

static void unloadAllAvailableClasses(hctFilterProcessingUtil* filterUtil)
{
    if (filterUtil)
    {
        filterUtil->unload();
        delete filterUtil;
    }
}

bool hctSceneExportUtility::importScene( const MCHAR* path )
{
    HCT_SCOPED_CONVERSIONS;

    hctFilterProcessingUtil* filterUtil = loadAllAvailableClasses();

    Interface* ip = GetCOREInterface();

    SetCursor(LoadCursor(NULL, IDC_WAIT));
    {
#ifdef _UNICODE
        wchar_t buffer[1000];
        swprintf_s<1000>(buffer, L"Importing meshes from : %s ", path);
#else
        char buffer[1000];
        sprintf_s<1000>(buffer, "Importing meshes from : %s ", path);
#endif
        ip->PushPrompt( buffer );
    }

    // Load HKX
    hkResource* scenePackfileData = HK_NULL;


    hkRootLevelContainer* root = hctSceneUtils::loadSceneFromFile( FROM_MAX(path), scenePackfileData );

    bool retStat = false;
    if (root && scenePackfileData)
    {
        // Iterate hkxNodes
        hkxScene* scene = root->findObject<hkxScene>();
        if (scene && scene->m_rootNode)
        {
            hkMemoryMeshSystem meshSystem;

            hkxNode* node = scene->m_rootNode;
            if (/*m_importMeshes && */ node)
            {
                _createMeshNodesRecursive( scene, node, &meshSystem);
            }

            retStat = true;
        }
        else
        {
            HK_WARN_ALWAYS(0xabba5686, "No scene graph data in HKX file. Currently unsupported import." );
        }
    }
    else
    {
        HK_WARN_ALWAYS(0xabba1fc4, "File does not exist, or no root level container. Check path and file type." );
    }

    // cleanup
    if (scenePackfileData)
    {
        scenePackfileData->removeReference();
    }

    if (filterUtil)
    {
        unloadAllAvailableClasses(filterUtil);
    }

    return retStat;
}

bool hctSceneExportUtility::waitOnBackgroundFilterLoad()
{
    hctFilterProcessingUtil::waitOnBackgroundFilterLoad();

    return true;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
