// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Max/MaxSceneExport/Exporter/hctMaxSceneExporter.h>

//
// A reference to the SceneExport param block, used by the implemented ReferenceMaker methods.
#define PBLOCK_SceneExport  0

// Param block IDs.
enum
{
    PB_SceneExport,
};

// Parameter IDs.
enum
{
    // SceneExport params.
    PA_UseOptionsFile,
    PA_OptionsFile,
    PA_UseConfigurationSet,
    PA_ConfigurationSet,
    PA_VisibleOnly,
    PA_SelectedOnly,
    PA_ExportMeshes,
    PA_ExportMaterials,
    PA_ExportAttributes,
    PA_ExportAnnotations,
    PA_ExportLights,
    PA_ExportCameras,
    PA_AddDefaultCamera,
    PA_UseOldPhysics_DEPRECATED,
    PA_AnimatedDataExport,
    PA_AnimationStart,
    PA_AnimationEnd,
    PA_EnvironmentVariables,
    PA_DoNotSplitVertices,

    PA_RespectModifierSkinPose,
    PA_AutoSkinAttachments,
    PA_ExportWireColorsAsVertexColors,
    PA_ExportMergeVertsOnlyIfSameSrcId,
    PA_StoreKeyframeSamplePoints,

    PA_ExpandSelectionToSkeleton,
    PA_ExpandSelectionToParents,
    PA_ExpandSelectionToChildren,

    PA_ExportTangents
};


// Access to the old exporter class desc
ClassDesc2* getHkOldSceneExporterDesc();

// Access to the new export class desc
ClassDesc2* getHkSceneExportUtilityDesc();

// Access the only instance of the utility
class hctSceneExportUtility* getSceneExportUtilityInstance ();

//
// The hctSceneExportUtility utility plugin.
//
class hctSceneExportUtility : public UtilityObj, public ReferenceMaker
{
    // Give the mesh writer access to the scene.
    friend class hctMaxMeshWriter;

    public:

        // Constructor and destructor.
        hctSceneExportUtility();
        ~hctSceneExportUtility();

        // Save & Load Methods (called by hkSceneExportUtilityClassDesc).
        IOResult Save(ISave *s);
        IOResult Load(ILoad *l);

        // Exports the scene (called by hctSceneExportUtility.exportScene())
        bool exportScene(BOOL batchMode);
        bool openVideoBrowser();
        bool openContentToolsChm();
        bool importScene(const MCHAR* path);
        bool waitOnBackgroundFilterLoad();

        void getOptionsFileDependencies(Tab<MSTR*>& dependencies);

        // ReferenceMaker methods for ParamBlock access (maxsdk stuff)
        int NumRefs();
        int NumParamBlocks();
        IParamBlock2* GetParamBlock( int id );
        IParamBlock2* GetParamBlockByID( BlockID id );
        RefTargetHandle GetReference( int i );
        void SetReference( int i, RefTargetHandle rtarg );
#if MAX_VERSION_MAJOR>=17
        RefResult NotifyRefChanged( const Interval& changeInt, RefTargetHandle hTarget, PartID& partID,  RefMessage message, BOOL propagate );
#else
        RefResult NotifyRefChanged( Interval changeInt, RefTargetHandle hTarget, PartID& partID,  RefMessage message );
#endif
        // UtilityObj methods (maxsdk stuff)
        void BeginEditParams( Interface *ip, IUtil *iu );
        void EndEditParams( Interface *ip, IUtil *iu );
        void DeleteThis() {}

        // Updates the UI
        void updateUI();

        // Checks whether the legacy physics exporter is present
        static bool isOldPhysicsExporterPresent ();

    public:

        IUtil *m_iutil;
        Interface *m_interface;

        static IParamBlock2* m_pbSceneExport;

        hctFilterSetOptions m_filterSetOptions;
        void getExportOptions (hctMaxSceneExportOptions& exportOptionsOut);

    private:

        void setExportOptions (const hctMaxSceneExportOptions& exportOptions);

        struct UtilityData
        {
            Tab<PB2Value> m_paramValues;
            hctFilterSetOptions m_filterSetOptions;

            UtilityData () {}
        };

        UtilityData m_utilityDataBackup;

    public:

        // EXP-1047 : Avoid overriding the utility data during scene merges
        void backupUtilityData ();
        void restoreUtilityData ();


};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
