// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Max/MaxFpInterfaces/Physics/DestructionUtility/hctDestructionUtilityInterface.h>

// Functions

class hctDestructionUtilityFPInterfaceImplementation : public hctDestructionUtilityFPInterface
{
    public:

        DECLARE_DESCRIPTOR( hctDestructionUtilityFPInterfaceImplementation )

        BEGIN_FUNCTION_MAP

            FN_0( FPI_CanDoDestruction,   TYPE_BOOL, iCanDoDestruction );

            FN_2( FPI_Destruct,           TYPE_BOOL, iDestruct,           TYPE_INODE_TAB_BR, TYPE_INODE_TAB_BR);
            FN_1( FPI_DestructionPreview, TYPE_BOOL, iDestructionPreview, TYPE_INODE_TAB_BR );
            FN_2( FPI_DestructionOptions, TYPE_BOOL, iDestructionOptions, TYPE_INODE_TAB_BR, TYPE_INODE_TAB_BR);
            FN_1( FPI_DestructionDelete,  TYPE_BOOL, iDestructionDelete,  TYPE_INODE_TAB_BR );

            FN_0( FPI_DestructionMessageLog, TYPE_BOOL, iDestructionMessageLog );

        END_FUNCTION_MAP

        /*virtual*/ BOOL iCanDoDestruction();

        /*virtual*/ BOOL iDestruct(Tab<INode*>& nodes, Tab<INode*>& newNodes);
        /*virtual*/ BOOL iDestructionPreview(Tab<INode*>& nodes);
        /*virtual*/ BOOL iDestructionOptions(Tab<INode*>& nodes, Tab<INode*>& newNodes);
        /*virtual*/ BOOL iDestructionDelete(Tab<INode*>& searchNodes);
        /*virtual*/ BOOL iDestructionMessageLog();
};


// Actions

class hctDestructionUtilityActionsImplementation : public hctDestructionUtilityActions
{
    public:

        DECLARE_DESCRIPTOR( hctDestructionUtilityActionsImplementation )

        BEGIN_FUNCTION_MAP

            FN_PRED( ACT_DestructionPossible, iDestructionPossible );

            FN_ACTION( ACT_Destruct, iDestruct );
            FN_ACTION( ACT_DestructionPreview, iDestructionPreview);
            FN_ACTION( ACT_DestructionOptions, iDestructionOptions);
            FN_ACTION( ACT_DestructionDelete, iDestructionDelete);

            FN_ACTION( ACT_DestructionMessageLog, iDestructionMessageLog );

        END_FUNCTION_MAP

        /*virtual*/ BOOL iDestructionPossible();

        /*virtual*/ FPStatus iDestruct();
        /*virtual*/ FPStatus iDestructionPreview();
        /*virtual*/ FPStatus iDestructionOptions();
        /*virtual*/ FPStatus iDestructionDelete();
        /*virtual*/ FPStatus iDestructionMessageLog();
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
