// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>

#include <ContentTools/Max/MaxSceneExport/Utilities/Destruction/hctDestructionUtility_FPI.h>
#include <ContentTools/Max/MaxSceneExport/Utilities/Destruction/hctDestructionUtility.h>

// Functions

static hctDestructionUtilityFPInterfaceImplementation theDestructionFPInterfaceImplementation
(
    HK_DESTRUCTION_UTILITY_FPINTERFACE_ID, _T("hkDestructionUtilityInterface"), 0, getHkDestructionUtilityDesc(), 0,

    /*methods*/

        FPI_CanDoDestruction, _T("canDoDestruction"), IDS_DESTRUCTION_UTILITY_CAN_DESTRUCT, TYPE_BOOL, 0, 0,

        FPI_Destruct, _T("destruct"), IDS_DESTRUCTION_UTILITY_METHOD_DESTRUCT, TYPE_BOOL, 0, 2,
            _T("nodes"),    0, TYPE_INODE_TAB_BR,
            _T("newNodes"), 0, TYPE_INODE_TAB_BR,

        FPI_DestructionPreview, _T("destructionPreview"), IDS_DESTRUCTION_UTILITY_METHOD_PREVIEW, TYPE_BOOL, 0, 1,
            _T("nodes"),    0, TYPE_INODE_TAB_BR,

        FPI_DestructionOptions, _T("destructionOptions"), IDS_DESTRUCTION_UTILITY_METHOD_OPTIONS, TYPE_INODE, 0, 2,
            _T("nodes"),    0, TYPE_INODE_TAB_BR,
            _T("newNodes"), 0, TYPE_INODE_TAB_BR,

        FPI_DestructionDelete,  _T("destructionDelete"),  IDS_DESTRUCTION_UTILITY_METHOD_DELETE, TYPE_INODE, 0, 1,
            _T("searchNodes"),  0, TYPE_INODE_TAB_BR,

        FPI_DestructionMessageLog, _T("destructionMessageLog"), IDS_DESTRUCTION_UTILITY_MESSAGE_LOG, TYPE_BOOL, 0, 0,

    /*properties,*/

    p_end
);

static void _getChildNodesRecursive(INode* root, Tab<INode*>& nodesOut)
{
    for (int c=0; c<root->NumberOfChildren(); ++c)
    {
        INode* child = root->GetChildNode(c);
        _getChildNodesRecursive(child, nodesOut);
    }
    nodesOut.Append(1, &root);
}

BOOL hctDestructionUtilityFPInterfaceImplementation::iCanDoDestruction()
{
    return getDestructionUtilityInstance()->canDoDestruction();
}

BOOL hctDestructionUtilityFPInterfaceImplementation::iDestructionMessageLog()
{
    return getDestructionUtilityInstance()->destructionMessageLog();
}

BOOL hctDestructionUtilityFPInterfaceImplementation::iDestruct(Tab<INode*>& selectedNodes, Tab<INode*>& newNodes)
{
    Interface* ip = GetCOREInterface();

    Tab<INode*> allNodes;
    INode* root = ip->GetRootNode();
    _getChildNodesRecursive(root, allNodes);

    return getDestructionUtilityInstance()->destruct(selectedNodes, allNodes, newNodes, hctMaxDestructionUtility::QUICK_RETURN_RUN );
}

BOOL hctDestructionUtilityFPInterfaceImplementation::iDestructionPreview(Tab<INode*>& selectedNodes)
{
    Tab<INode*> dummyNodes;
    return getDestructionUtilityInstance()->destruct(selectedNodes, dummyNodes, dummyNodes, hctMaxDestructionUtility::PREVIEW_RUN );
}

BOOL hctDestructionUtilityFPInterfaceImplementation::iDestructionOptions(Tab<INode*>& selectedNodes, Tab<INode*>& newNodes)
{
    Tab<INode*> dummyNodes;
    return getDestructionUtilityInstance()->destruct(selectedNodes, dummyNodes, newNodes, hctMaxDestructionUtility::DEFAULT_RUN );
}

BOOL hctDestructionUtilityFPInterfaceImplementation::iDestructionDelete(Tab<INode*>& selectedNodes)
{
    return getDestructionUtilityInstance()->deleteCreatedChildren( selectedNodes );
}

// Actions

static hctDestructionUtilityActionsImplementation theDestructionActionsImplementation
(
    HK_DESTRUCTION_UTILITY_ACTIONS_ID, _T("hkDestructionUtilityActions"), 0, getHkDestructionUtilityDesc(),
    FP_ACTIONS,

    kActionMainUIContext,

    ACT_Destruct, _T("destruct"), IDS_DESTRUCTION_UTILITY_ACTION_DESTRUCT, 0,
        f_isEnabled, ACT_DestructionPossible,
        f_category, _T("havokDestruction"), IDS_DESTRUCTION_UTILITY_CATEGORY_ACTIONS,
        f_ui, PB_DESTRUCTION_UTILITY_PBLOCK, 0, TYPE_BUTTON, IDC_B_DESTRUCTION_DESTRUCT,
        p_end,

    ACT_DestructionPreview, _T("destructionPreview"), IDS_DESTRUCTION_UTILITY_ACTION_PREVIEW, 0,
        f_isEnabled, ACT_DestructionPossible,
        f_category, _T("havokDestruction"), IDS_DESTRUCTION_UTILITY_CATEGORY_ACTIONS,
        f_ui, PB_DESTRUCTION_UTILITY_PBLOCK, 0, TYPE_BUTTON, IDC_B_DESTRUCTION_PREVIEW,
        p_end,

    ACT_DestructionOptions, _T("destructionOptions"), IDS_DESTRUCTION_UTILITY_ACTION_OPTIONS, 0,
        f_category, _T("havokDestruction"), IDS_DESTRUCTION_UTILITY_CATEGORY_ACTIONS,
        f_ui, PB_DESTRUCTION_UTILITY_PBLOCK, 0, TYPE_BUTTON, IDC_B_DESTRUCTION_OPTIONS,
        p_end,

    ACT_DestructionDelete, _T("destructionDelete"), IDS_DESTRUCTION_UTILITY_ACTION_DELETE, 0,
        f_isEnabled, ACT_DestructionPossible,
        f_category, _T("havokDestruction"), IDS_DESTRUCTION_UTILITY_CATEGORY_ACTIONS,
        f_ui, PB_DESTRUCTION_UTILITY_PBLOCK, 0, TYPE_BUTTON, IDC_B_DESTRUCTION_DELETE,
        p_end,

    ACT_DestructionMessageLog, _T("destructionMessageLog"), IDS_DESTRUCTION_UTILITY_MESSAGE_LOG, 0,
        f_isEnabled, ACT_DestructionPossible,
        f_category, _T("havokDestruction"), IDS_DESTRUCTION_UTILITY_CATEGORY_ACTIONS,
        f_ui, PB_DESTRUCTION_UTILITY_PBLOCK, 0, TYPE_BUTTON, IDC_B_DESTRUCTION_MESSAGE_LOG,
        p_end,

    p_end
);

BOOL hctDestructionUtilityActionsImplementation::iDestructionPossible()
{
    return getDestructionUtilityInstance()->canDoDestruction();
}

FPStatus hctDestructionUtilityActionsImplementation::iDestructionMessageLog()
{
    BOOL result = getDestructionUtilityInstance()->destructionMessageLog();
    return result ? FPS_OK: FPS_FAIL;
}

FPStatus hctDestructionUtilityActionsImplementation::iDestruct()
{
    Interface* ip = GetCOREInterface();

    Tab<INode*> selectedNodes;
    for (int i=0; i<ip->GetSelNodeCount(); i++)
    {
        INode* anotherSel = ip->GetSelNode(i);
        selectedNodes.Append(1, &anotherSel);
    }

    Tab<INode*> allNodes;
    INode* root = ip->GetRootNode();
    _getChildNodesRecursive(root, allNodes);

    Tab<INode*> newNodes;
    BOOL result = getDestructionUtilityInstance()->destruct(selectedNodes, allNodes, newNodes, hctMaxDestructionUtility::QUICK_RETURN_RUN );
    return (result && (newNodes.Count() > 0))? FPS_OK: FPS_FAIL;
}

FPStatus hctDestructionUtilityActionsImplementation::iDestructionPreview()
{
    Interface* ip = GetCOREInterface();

    Tab<INode*> selectedNodes;
    for (int i=0; i<ip->GetSelNodeCount(); i++)
    {
        INode* anotherSel = ip->GetSelNode(i);
        selectedNodes.Append(1, &anotherSel);
    }

    Tab<INode*> dummyNodes;
    Tab<INode*> newNodes;
    BOOL result = getDestructionUtilityInstance()->destruct(selectedNodes, dummyNodes, newNodes, hctMaxDestructionUtility::PREVIEW_RUN );
    return result? FPS_OK: FPS_FAIL;
}

FPStatus hctDestructionUtilityActionsImplementation::iDestructionOptions()
{
    Interface* ip = GetCOREInterface();

    Tab<INode*> selectedNodes;
    for (int i=0; i<ip->GetSelNodeCount(); i++)
    {
        INode* anotherSel = ip->GetSelNode(i);
        selectedNodes.Append(1, &anotherSel);
    }

    Tab<INode*> dummyNodes;
    Tab<INode*> newNodes;
    BOOL result = getDestructionUtilityInstance()->destruct(selectedNodes, dummyNodes, newNodes, hctMaxDestructionUtility::DEFAULT_RUN );
    return result? FPS_OK: FPS_FAIL;
}


FPStatus hctDestructionUtilityActionsImplementation::iDestructionDelete()
{
    Interface* ip = GetCOREInterface();

    Tab<INode*> selectedNodes;
    for (int i=0; i<ip->GetSelNodeCount(); i++)
    {
        INode* anotherSel = ip->GetSelNode(i);
        selectedNodes.Append(1, &anotherSel);
    }

    BOOL result = getDestructionUtilityInstance()->deleteCreatedChildren( selectedNodes );
    return result? FPS_OK: FPS_FAIL;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
