// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>

#include <ContentTools/Max/MaxSceneExport/Utilities/Destruction/hctDestructionUtility.h>
#include <ContentTools/Max/MaxSceneExport/Utilities/Destruction/hctDestructionUtilityMessageLogDlg.h>

#include <ContentTools/Max/MaxSceneExport/resource.h>

#include <shlwapi.h>

#include <richedit.h>

extern HINSTANCE hInstance;
INT_PTR CALLBACK hctDestructionUtilityMessageLogProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    hctMaxDestructionUtility* util = reinterpret_cast<hctMaxDestructionUtility*> ( (hkUlong) GetWindowLongPtr(hWnd,GWLP_USERDATA) );

    switch(message)
    {
        case WM_INITDIALOG:
        {
            SetWindowLongPtr(hWnd, GWLP_USERDATA, (LONG_PTR)lParam); // so that it can be retrieved later

            HWND richEditControl = GetDlgItem(hWnd, IDC_RICHEDIT_DESTRUCTION_MESSAGE_LOG);

            // Output current log entries whenever we open the Message window (otherwise the log viewer would be empty)
            util = (hctMaxDestructionUtility*)lParam;
            util->printMessages(richEditControl);

            return TRUE;
        }

        case WM_SIZE:
        {
            RECT dialogRect;
            GetClientRect( hWnd, (LPRECT)&dialogRect );

            int borderSpacing = 10;

            {
                HWND closeButtonControl = GetDlgItem(hWnd, IDCLOSE);
                int buttonWidth = 80;
                int buttonHeight = 25;
                SetWindowPos(closeButtonControl, NULL, (dialogRect.right) - borderSpacing - buttonWidth, dialogRect.bottom - borderSpacing - buttonHeight, buttonWidth, buttonHeight, SWP_NOZORDER);
            }

            {
                HWND richEditControl = GetDlgItem(hWnd, IDC_RICHEDIT_DESTRUCTION_MESSAGE_LOG);
                SetWindowPos(richEditControl, NULL, borderSpacing, borderSpacing, dialogRect.right - (2*borderSpacing), dialogRect.bottom - 35- (2*borderSpacing), SWP_NOZORDER);
            }

            return TRUE;
        }

        case WM_COMMAND:
        {
            switch ( LOWORD(wParam) )
            {
                case IDC_UPDATE:
                {
                    HWND richEditControl = GetDlgItem(hWnd, IDC_RICHEDIT_DESTRUCTION_MESSAGE_LOG);

                    // Clear the log viewer first. Pretty awkward, but works.
                    LRESULT options = SendMessage(richEditControl, EM_GETOPTIONS, 0, 0);
                    options &= ~ECO_READONLY;
                    SendMessage(richEditControl, EM_SETOPTIONS, ECOOP_SET, options);
                    SendMessage(richEditControl, EM_SETSEL, 0, -1);
                    SendMessage(richEditControl, WM_CLEAR, 0, 0);
                    SendMessage(richEditControl, EM_SETOPTIONS, ECOOP_SET, ECO_READONLY);

                    // Print the log entries.
                    util->printMessages(richEditControl);
                    break;
                }

                case IDCLOSE:
                {
                    util->destructionMessageLogClosed();
                    EndDialog( hWnd, 0 );
                    break;
                }
            }

            break;
        }

        case WM_DESTROY:
        {
            // all exits will p_end here, place any wait func
            util->destructionMessageLogClosed();
            EndDialog( hWnd, 0 );
            break;
        }

    }

    return FALSE;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
