// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Max/MaxFpInterfaces/Physics/DestructionUtility/hctDestructionUtilityInterface.h>

#include <ContentTools/Common/SdkUtils/hctSdkUtils.h>

// Access to the class description and the single utility instance
class hctMaxDestructionUtility* getDestructionUtilityInstance();
ClassDesc2* getHkDestructionUtilityDesc();

struct ProgressUpdaterMax;

// Convex Hull utility
class hctMaxDestructionUtility : public UtilityObj, public ReferenceMaker
{
    public:

        hctMaxDestructionUtility();
        virtual ~hctMaxDestructionUtility();

        // Custom methods
        bool canDoDestruction();
        bool destructionMessageLog();
        void destructionMessageLogClosed() { m_logDialogWindow = 0; }
        void destructionMessageLogUpdated() const;
        void getMessageLogString(hkStringOld& logString) const;
        bool isWarningOrErrorInLog() const;
        void printMessages(HWND richEditControl) const;

        enum RunOptions
        {
            DEFAULT_RUN = 0, // with options dlg
            PREVIEW_RUN = 1, // no options dlg, direct to Preview
            QUICK_RETURN_RUN = 2 // no options dlg, direct break and return
        };

        bool destruct( const Tab<INode*>& selectedNodes, Tab<INode*>& allNodes, Tab<INode*>& newNodes, RunOptions options);
        bool deleteCreatedChildren( Tab<INode*>& selectedNodes );

        void updateUI();

        // Inherited methods
        int NumParamBlocks() { return 1; }
        IParamBlock2* GetParamBlock( int id ) { return m_pblock; }
        IParamBlock2* GetParamBlockByID( BlockID id ) { return ( PB_DESTRUCTION_UTILITY_PBLOCK == id )? m_pblock: NULL; }

        int NumRefs() { return 1; }
        RefTargetHandle GetReference( int i ) { return ( i== PBLOCK_DestructionUtility ) ? m_pblock: NULL; }
        void SetReference( int i, RefTargetHandle rtarg ) { if( i== PB_DESTRUCTION_UTILITY_PBLOCK ) m_pblock = (IParamBlock2*)rtarg; }
#if MAX_VERSION_MAJOR>=17
        RefResult NotifyRefChanged( const Interval& changeInt, RefTargetHandle hTarget, PartID& partID,  RefMessage message, BOOL propagate );
#else
        RefResult NotifyRefChanged( Interval changeInt, RefTargetHandle hTarget, PartID& partID,  RefMessage message );
#endif

        void BeginEditParams( Interface *ip, IUtil *iu );
        void EndEditParams( Interface *ip, IUtil *iu );
        void DeleteThis() {}

    public:

        Interface *m_interface;
        IParamBlock2* m_pblock;

        hkMaxSceneError m_errorHandler;
        HWND m_logDialogWindow;
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
