// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Max/MaxFpInterfaces/Physics/ConvexHullUtility/hctConvexHullUtilityInterface.h>


// Functions

class hctConvexHullUtilityFPInterfaceImplementation : public hctConvexHullUtilityFPInterface
{
    public:

        DECLARE_DESCRIPTOR( hctConvexHullUtilityFPInterfaceImplementation )

        BEGIN_FUNCTION_MAP
            FN_0( FPI_CanCreateHull, TYPE_BOOL, iCanCreateHull );
            FN_1( FPI_CreateHull, TYPE_INODE, iCreateHull, TYPE_INODE);
            FN_1( FPI_CreateMultiHull, TYPE_INODE, iCreateMultiHull, TYPE_INODE_TAB_BR);
            FN_1( FPI_CreateSkinHull, TYPE_INODE, iCreateSkinHull, TYPE_INODE);
            FN_1( FPI_CreateSkinMultiHull, TYPE_INODE, iCreateSkinMultiHull, TYPE_INODE_TAB_BR);

            PROP_FNS (FPI_GetMaxVerts, iGetMaxVerts, FPI_SetMaxVerts, iSetMaxVerts, TYPE_INT);
            PROP_FNS (FPI_GetEncloseInputs, iGetEncloseInputs, FPI_SetEncloseInputs, iSetEncloseInputs, TYPE_BOOL);
            PROP_FNS (FPI_GetMinWeight, iGetMinWeight, FPI_SetMinWeight, iSetMinWeight, TYPE_FLOAT);

        END_FUNCTION_MAP

        /*virtual*/ BOOL iCanCreateHull();

        /*virtual*/ INode* iCreateHull (INode* node);
        /*virtual*/ INode* iCreateMultiHull (Tab<INode*>& nodes);

        /*virtual*/ INode* iCreateSkinHull (INode* node);
        /*virtual*/ INode* iCreateSkinMultiHull (Tab<INode*>& nodes);

        /*virtual*/ void iSetMaxVerts (int maxVerts);
        /*virtual*/ int iGetMaxVerts ();

        /*virtual*/ void iSetEncloseInputs (BOOL encloseInputs);
        /*virtual*/ BOOL iGetEncloseInputs ();

        /*virtual*/ void iSetMinWeight (float minWeight);
        /*virtual*/ float iGetMinWeight ();

};


// Actions

class hctConvexHullUtilityActionsImplementation : public hctConvexHullUtilityActions
{
    public:

        DECLARE_DESCRIPTOR( hctConvexHullUtilityActionsImplementation )

        BEGIN_FUNCTION_MAP
            FN_PRED( ACT_GenerateHullEnabled, iGenerateHullEnabled );
            FN_PRED( ACT_GenerateSkinHullEnabled, iGenerateSkinHullEnabled);

            FN_ACTION( ACT_GenerateHull, iGenerateHull );
            FN_ACTION( ACT_GenerateSkinHull, iGenerateSkinHull);
        END_FUNCTION_MAP

        /*virtual*/ BOOL iGenerateHullEnabled();
        /*virtual*/ BOOL iGenerateSkinHullEnabled();

        /*virtual*/ FPStatus iGenerateHull();
        /*virtual*/ FPStatus iGenerateSkinHull();
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
