// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>

#include <ContentTools/Max/MaxSceneExport/Utilities/ConvexHull/hctConvexHullUtility_FPI.h>
#include <ContentTools/Max/MaxSceneExport/Utilities/ConvexHull/hctConvexHullUtility.h>


// Functions

static hctConvexHullUtilityFPInterfaceImplementation theFPInterfaceImplementation
(
    HK_CONVEX_HULL_UTILITY_FPINTERFACE_ID, _T("hkConvexHullUtilityInterface"), 0, getHkConvexHullUtilityDesc(), 0,

    /*methods*/

        FPI_CanCreateHull, _T("canCreateHull"), IDS_CONVEX_HULL_UTILITY_CAN_CREATE_HULL, TYPE_BOOL, 0, 0,

        FPI_CreateHull, _T("createHull"), IDS_CONVEX_HULL_UTILITY_METHOD_CREATE_HULL, TYPE_INODE, 0, 1,
            _T("node"),     0, TYPE_INODE,
        FPI_CreateMultiHull, _T("createMultiHull"), IDS_CONVEX_HULL_UTILITY_METHOD_CREATE_HULL, TYPE_INODE, 0, 1,
            _T("nodes"),    0, TYPE_INODE_TAB_BR,

        FPI_CreateSkinHull, _T("createSkinHull"), IDS_CONVEX_HULL_UTILITY_METHOD_CREATE_HULL, TYPE_INODE, 0, 1,
            _T("bone"),     0, TYPE_INODE,
        FPI_CreateSkinMultiHull, _T("createSkinMultiHull"), IDS_CONVEX_HULL_UTILITY_METHOD_CREATE_HULL, TYPE_INODE, 0, 1,
            _T("bones"),    0, TYPE_INODE_TAB_BR,


    /* no properties, yet anyway */

    p_end
);

BOOL hctConvexHullUtilityFPInterfaceImplementation::iCanCreateHull()
{
    return getConvexHullUtilityInstance()->canCreateHulls();
}

INode* hctConvexHullUtilityFPInterfaceImplementation::iCreateHull (INode* node)
{

    INode* result = getConvexHullUtilityInstance()->createHull (node);
    return result;
}

INode* hctConvexHullUtilityFPInterfaceImplementation::iCreateMultiHull (Tab<INode*>& nodes)
{
    INode* result = getConvexHullUtilityInstance()->createMultiHull (nodes);
    return result;
}

INode* hctConvexHullUtilityFPInterfaceImplementation::iCreateSkinHull (INode* node)
{

    INode* result = getConvexHullUtilityInstance()->createSkinHull (node);
    return result;
}

INode* hctConvexHullUtilityFPInterfaceImplementation::iCreateSkinMultiHull (Tab<INode*>& nodes)
{
    INode* result = getConvexHullUtilityInstance()->createSkinMultiHull (nodes);
    return result;
}

// GET/SET

int hctConvexHullUtilityFPInterfaceImplementation::iGetMaxVerts()
{
    IParamBlock2* pblock = getConvexHullUtilityInstance()->m_pblock;

    return pblock->GetInt(PA_CONVEX_HULL_UTILITY_MAXVERTS);
}

void hctConvexHullUtilityFPInterfaceImplementation::iSetMaxVerts (int maxVerts)
{
    IParamBlock2* pblock = getConvexHullUtilityInstance()->m_pblock;

    pblock->SetValue(PA_CONVEX_HULL_UTILITY_MAXVERTS,0,maxVerts);
}

BOOL hctConvexHullUtilityFPInterfaceImplementation::iGetEncloseInputs()
{
    IParamBlock2* pblock = getConvexHullUtilityInstance()->m_pblock;

    return (pblock->GetInt(PA_CONVEX_HULL_UTILITY_ENCLOSE_INPUTS) != FALSE);
}

void hctConvexHullUtilityFPInterfaceImplementation::iSetEncloseInputs(BOOL encloseInputs)
{
    IParamBlock2* pblock = getConvexHullUtilityInstance()->m_pblock;

    pblock->SetValue(PA_CONVEX_HULL_UTILITY_ENCLOSE_INPUTS,0,encloseInputs);
}

float hctConvexHullUtilityFPInterfaceImplementation::iGetMinWeight()
{
    IParamBlock2* pblock = getConvexHullUtilityInstance()->m_pblock;

    return pblock->GetFloat(PA_CONVEX_HULL_UTILITY_MIN_WEIGHT);
}

void hctConvexHullUtilityFPInterfaceImplementation::iSetMinWeight (float minWeight)
{
    IParamBlock2* pblock = getConvexHullUtilityInstance()->m_pblock;

    pblock->SetValue(PA_CONVEX_HULL_UTILITY_MIN_WEIGHT,0,minWeight);
}


// Actions

static hctConvexHullUtilityActionsImplementation theActionsImplementation
(
    HK_CONVEX_HULL_UTILITY_ACTIONS_ID, _T("hkConvexHullUtilityActions"), 0, getHkConvexHullUtilityDesc(),
    FP_ACTIONS,

    kActionMainUIContext,

    ACT_GenerateHull, _T("generateHull"), IDS_CONVEX_HULL_UTILITY_ACTION_GENERATE_HULL, 0,
        f_isEnabled, ACT_GenerateHullEnabled,
        f_category, _T("havokPhysics"), IDS_CONVEX_HULL_UTILITY_CATEGORY_ACTIONS,
        f_ui, PB_CONVEX_HULL_UTILITY_PBLOCK, 0, TYPE_BUTTON, IDC_B_GENERATE_HULL,
        p_end,

    ACT_GenerateSkinHull, _T("generateSkinHull"), IDS_CONVEX_HULL_UTILITY_ACTION_GENERATE_SKIN_HULL, 0,
        f_isEnabled, ACT_GenerateSkinHullEnabled,
        f_category, _T("havokPhysics"), IDS_CONVEX_HULL_UTILITY_CATEGORY_ACTIONS,
        //f_ui, PB_CONVEX_HULL_UTILITY_PBLOCK, 0, TYPE_BUTTON, IDC_B_GENERATE_SKIN_HULL,
        p_end,
    p_end
);

BOOL hctConvexHullUtilityActionsImplementation::iGenerateHullEnabled()
{
    return getConvexHullUtilityInstance()->canCreateHulls();
}

FPStatus hctConvexHullUtilityActionsImplementation::iGenerateHull()
{
    Interface* ip = GetCOREInterface();

    INode* result= NULL;
    if (ip->GetSelNodeCount()==1)
    {
        result = getConvexHullUtilityInstance()->createHull(ip->GetSelNode(0));
    }
    else
    {
        Tab<INode*> nodes;
        for (int i=0; i<ip->GetSelNodeCount(); i++)
        {
            INode* anotherSel = ip->GetSelNode(i);
            nodes.Append(1, &anotherSel);
        }

        result = getConvexHullUtilityInstance()->createMultiHull(nodes);
    }

    return result ? FPS_OK: FPS_FAIL;
}

BOOL hctConvexHullUtilityActionsImplementation::iGenerateSkinHullEnabled()
{
    // TODO
    return getConvexHullUtilityInstance()->canCreateSkinHulls();
}

FPStatus hctConvexHullUtilityActionsImplementation::iGenerateSkinHull()
{
    Interface* ip = GetCOREInterface();

    INode* result= NULL;
    if (ip->GetSelNodeCount()==1)
    {
        result = getConvexHullUtilityInstance()->createSkinHull(ip->GetSelNode(0));
    }
    else
    {
        Tab<INode*> nodes;
        for (int i=0; i<ip->GetSelNodeCount(); i++)
        {
            INode* anotherSel = ip->GetSelNode(i);
            nodes.Append(1, &anotherSel);
        }

        result = getConvexHullUtilityInstance()->createSkinMultiHull(nodes);
    }

    return result ? FPS_OK: FPS_FAIL;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
