// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Max/MaxFpInterfaces/Physics/ConvexHullUtility/hctConvexHullUtilityInterface.h>

// Connection to Havok SDK through hksdkutils
#include <ContentTools/Common/SdkUtils/hctSdkUtils.h>

// Access to the class description and the single utility instance
ClassDesc2* getHkConvexHullUtilityDesc();
class hctConvexHullUtility* getConvexHullUtilityInstance();

struct ProgressUpdaterMax;

// Convex Hull utility
class hctConvexHullUtility : public UtilityObj, public ReferenceMaker
{
    public:

        hctConvexHullUtility();
        ~hctConvexHullUtility();

        // Custom methods
        bool canCreateHulls();
        bool canCreateSkinHulls();
        INode* createHull (INode* node);
        INode* createMultiHull (const Tab<INode*>& nodes);
        INode* createSkinHull (INode* node);
        INode* createSkinMultiHull (const Tab<INode*>& nodes);

        void updateUI();

        // Inherited methods
        int NumParamBlocks() { return 1; }
        IParamBlock2* GetParamBlock( int id ) { return m_pblock; }
        IParamBlock2* GetParamBlockByID( BlockID id ) { return ( PB_CONVEX_HULL_UTILITY_PBLOCK == id )? m_pblock: NULL; }

        int NumRefs() { return 1; }
        RefTargetHandle GetReference( int i ) { return ( i== PBLOCK_ConvexHullUtility ) ? m_pblock: NULL; }
        void SetReference( int i, RefTargetHandle rtarg ) { if( i== PB_CONVEX_HULL_UTILITY_PBLOCK ) m_pblock = (IParamBlock2*)rtarg; }
#if MAX_VERSION_MAJOR>=17
        RefResult NotifyRefChanged( const Interval& changeInt, RefTargetHandle hTarget, PartID& partID,  RefMessage message, BOOL propagate );
#else
        RefResult NotifyRefChanged( Interval changeInt, RefTargetHandle hTarget, PartID& partID,  RefMessage message );
#endif

        void BeginEditParams( Interface *ip, IUtil *iu );
        void EndEditParams( Interface *ip, IUtil *iu );
        void DeleteThis() {}

        //void doTheTest();

    public:

        ClassDesc2* m_classDesc;
        ParamMap2UserDlgProc* m_dlgProc;
        ParamBlockDesc2 *m_pBlock2;

        Interface *m_interface;

        IParamBlock2* m_pblock;

    private:

        INode* createHullNodeFromWorldVertices (const Tab<Point3>& worldVertices, INode* mainNode);


        bool getWorldVerticesFromNode (INode* node, Tab<Point3>& worldVerticesOut);
        void addPhysiqueVertices (IPhysiqueExport* physiqueMod, INode* skinNode, INode* boneNode,  Tab<Point3>& vertsWorldInOut);
        void addSkinVertices (ISkin* skin, INode* skinNode, INode* boneNode, Tab<Point3>& vertsWorldInOut);

};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
