// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Max/MaxFpInterfaces/Physics/CgoUtility/hctCgoUtilityInterface.h>


// Functions

class hctCgoUtilityFPInterfaceImplementation : public hctCgoUtilityFPInterface
{
    public:

        DECLARE_DESCRIPTOR( hctCgoUtilityFPInterfaceImplementation )

        BEGIN_FUNCTION_MAP
            FN_0( FPI_CanOptimize, TYPE_BOOL, iCanOptimize );
            FN_1( FPI_Optimize, TYPE_INODE, iOptimize, TYPE_INODE);

            PROP_FNS (FPI_GetMaxError, iGetMaxError, FPI_SetMaxError, iSetMaxError, TYPE_FLOAT);
            PROP_FNS (FPI_GetTargetNumVertices, iGetTargetNumVertices, FPI_SetTargetNumVertices, iSetTargetNumVertices, TYPE_INT);
            PROP_FNS (FPI_GetRetainTargetNumVertices, iGetRetainTargetNumVertices, FPI_SetRetainTargetNumVertices, iSetRetainTargetNumVertices, TYPE_BOOL);
            PROP_FNS (FPI_GetTargetRatio, iGetTargetRatio, FPI_SetTargetRatio, iSetTargetRatio, TYPE_FLOAT);
            PROP_FNS (FPI_GetRetainTargetRatio, iGetRetainTargetRatio, FPI_SetRetainTargetRatio, iSetRetainTargetRatio, TYPE_BOOL);
            PROP_FNS (FPI_GetRetainmentType, iGetRetainmentType, FPI_SetRetainmentType, iSetRetainmentType, TYPE_INT);
            PROP_FNS (FPI_GetKeepRatio, iGetKeepRatio, FPI_SetKeepRatio, iSetKeepRatio, TYPE_BOOL);
            PROP_FNS (FPI_GetShrinking, iGetShrinking, FPI_SetShrinking, iSetShrinking, TYPE_FLOAT);
            PROP_FNS (FPI_GetProtectMaterials, iGetProtectMaterials, FPI_SetProtectMaterials, iSetProtectMaterials, TYPE_BOOL);
            PROP_FNS (FPI_GetProtectEdges, iGetProtectEdges, FPI_SetProtectEdges, iSetProtectEdges, TYPE_BOOL);
            PROP_FNS (FPI_GetUseWeights, iGetUseWeights, FPI_SetUseWeights, iSetUseWeights, TYPE_BOOL);
            PROP_FNS (FPI_GetDeleteInput, iGetDeleteInput, FPI_SetDeleteInput, iSetDeleteInput, TYPE_BOOL);
            PROP_FNS (FPI_GetMultipass, iGetMultipass, FPI_SetMultipass, iSetMultipass, TYPE_BOOL);

        END_FUNCTION_MAP

        /*virtual*/ BOOL    iCanOptimize();

        /*virtual*/ INode*  iOptimize (INode* node);

        /*virtual*/ void    iSetMaxError (float value);
        /*virtual*/ float   iGetMaxError ();

        /*virtual*/ void    iSetTargetNumVertices (int value);
        /*virtual*/ int     iGetTargetNumVertices ();

        /*virtual*/ void    iSetRetainTargetNumVertices(bool value);
        /*virtual*/ bool    iGetRetainTargetNumVertices();

        /*virtual*/ void    iSetTargetRatio(float value);
        /*virtual*/ float   iGetTargetRatio();

        /*virtual*/ void    iSetRetainTargetRatio(bool value);
        /*virtual*/ bool    iGetRetainTargetRatio();

        /*virtual*/ void    iSetRetainmentType(int value);
        /*virtual*/ int     iGetRetainmentType();

        /*virtual*/ void    iSetKeepRatio(bool value);
        /*virtual*/ bool    iGetKeepRatio();

        /*virtual*/ void    iSetShrinking (float value);
        /*virtual*/ float   iGetShrinking ();

        /*virtual*/ void    iSetProtectMaterials (bool value);
        /*virtual*/ bool    iGetProtectMaterials ();

        /*virtual*/ void    iSetProtectEdges (bool value);
        /*virtual*/ bool    iGetProtectEdges ();

        /*virtual*/ void    iSetUseWeights (bool value);
        /*virtual*/ bool    iGetUseWeights ();

        /*virtual*/ void    iSetDeleteInput (bool value);
        /*virtual*/ bool    iGetDeleteInput ();

        /*virtual*/ void    iSetMultipass (bool value);
        /*virtual*/ bool    iGetMultipass ();

};


// Actions

class hctCgoUtilityActionsImplementation : public hctCgoUtilityActions
{
    public:

        DECLARE_DESCRIPTOR( hctCgoUtilityActionsImplementation )

        BEGIN_FUNCTION_MAP
            FN_PRED( ACT_OptimizeEnabled, iOptimizeEnabled );
            FN_ACTION( ACT_Optimize, iOptimize);
        END_FUNCTION_MAP

        /*virtual*/ BOOL        iOptimizeEnabled();
        /*virtual*/ FPStatus    iOptimize();
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
