// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>

#include <ContentTools/Max/MaxSceneExport/Utilities/Cgo/hctCgoUtility_FPI.h>
#include <ContentTools/Max/MaxSceneExport/Utilities/Cgo/hctCgoUtility.h>


// Functions

static hctCgoUtilityFPInterfaceImplementation theFPInterfaceImplementation
(
    HK_CGO_UTILITY_FPINTERFACE_ID, _T("hkCgoUtilityInterface"), 0, getHkCgoUtilityDesc(), 0,

    /*methods*/

        FPI_CanOptimize, _T("canOptimize"), IDS_CGO_UTILITY_CAN_OPTIMIZE, TYPE_BOOL, 0, 0,

        FPI_Optimize, _T("optimize"), IDS_CGO_UTILITY_METHOD_OPTIMIZE, TYPE_INODE, 0, 1,
            _T("node"),     0, TYPE_INODE,

    /* no properties, yet anyway */

    p_end
);

BOOL hctCgoUtilityFPInterfaceImplementation::iCanOptimize()
{
    return getCgoUtilityInstance()->canOptimize();
}

INode* hctCgoUtilityFPInterfaceImplementation::iOptimize (INode* node)
{
    INode* result = getCgoUtilityInstance()->optimize(node);
    return result;
}

// GET/SET

float hctCgoUtilityFPInterfaceImplementation::iGetMaxError()
{
    IParamBlock2* pblock = getCgoUtilityInstance()->m_pblock;

    return pblock->GetFloat(PA_CGO_UTILITY_MAXERROR);
}

void hctCgoUtilityFPInterfaceImplementation::iSetMaxError (float value)
{
    IParamBlock2* pblock = getCgoUtilityInstance()->m_pblock;

    pblock->SetValue(PA_CGO_UTILITY_MAXERROR,0,value);
}

int hctCgoUtilityFPInterfaceImplementation::iGetTargetNumVertices()
{
    IParamBlock2* pblock = getCgoUtilityInstance()->m_pblock;

    return pblock->GetInt(PA_CGO_UTILITY_TARGET_NUM_VERTICES);
}

void hctCgoUtilityFPInterfaceImplementation::iSetTargetNumVertices (int value)
{
    IParamBlock2* pblock = getCgoUtilityInstance()->m_pblock;

    pblock->SetValue(PA_CGO_UTILITY_TARGET_NUM_VERTICES,0,value);
}

bool hctCgoUtilityFPInterfaceImplementation::iGetRetainTargetNumVertices()
{
    IParamBlock2* pblock = getCgoUtilityInstance()->m_pblock;

    return pblock->GetInt(PA_CGO_UTILITY_RETAIN_TARGET_NUM_VERTICES) ? true : false;
}

void hctCgoUtilityFPInterfaceImplementation::iSetRetainTargetNumVertices(bool value)
{
    IParamBlock2* pblock = getCgoUtilityInstance()->m_pblock;

    pblock->SetValue(PA_CGO_UTILITY_RETAIN_TARGET_NUM_VERTICES, 0, value);
}

float hctCgoUtilityFPInterfaceImplementation::iGetTargetRatio()
{
    IParamBlock2* pblock = getCgoUtilityInstance()->m_pblock;

    return pblock->GetFloat(PA_CGO_UTILITY_TARGET_RATIO);
}

void hctCgoUtilityFPInterfaceImplementation::iSetTargetRatio(float value)
{
    IParamBlock2* pblock = getCgoUtilityInstance()->m_pblock;

    pblock->SetValue(PA_CGO_UTILITY_TARGET_RATIO, 0, value);
}

bool hctCgoUtilityFPInterfaceImplementation::iGetRetainTargetRatio()
{
    IParamBlock2* pblock = getCgoUtilityInstance()->m_pblock;

    return pblock->GetInt(PA_CGO_UTILITY_RETAIN_TARGET_RATIO) ? true : false;
}

void hctCgoUtilityFPInterfaceImplementation::iSetRetainTargetRatio(bool value)
{
    IParamBlock2* pblock = getCgoUtilityInstance()->m_pblock;

    pblock->SetValue(PA_CGO_UTILITY_RETAIN_TARGET_RATIO, 0, value);
}

int hctCgoUtilityFPInterfaceImplementation::iGetRetainmentType()
{
    IParamBlock2* pblock = getCgoUtilityInstance()->m_pblock;

    return pblock->GetInt(PA_CGO_UTILITY_RETAINMENT_TYPE);
}

void hctCgoUtilityFPInterfaceImplementation::iSetRetainmentType(int value)
{
    IParamBlock2* pblock = getCgoUtilityInstance()->m_pblock;

    pblock->SetValue(PA_CGO_UTILITY_RETAINMENT_TYPE, 0, value);
}

void hctCgoUtilityFPInterfaceImplementation::iSetKeepRatio(bool value)
{
    IParamBlock2* pblock = getCgoUtilityInstance()->m_pblock;

    pblock->SetValue(PA_CGO_UTILITY_KEEP_RATIO, 0, value);
}

bool hctCgoUtilityFPInterfaceImplementation::iGetKeepRatio()
{
    IParamBlock2* pblock = getCgoUtilityInstance()->m_pblock;

    return pblock->GetInt(PA_CGO_UTILITY_KEEP_RATIO) ? true : false;
}

float hctCgoUtilityFPInterfaceImplementation::iGetShrinking()
{
    IParamBlock2* pblock = getCgoUtilityInstance()->m_pblock;

    return pblock->GetFloat(PA_CGO_UTILITY_SHRINKING);
}

void hctCgoUtilityFPInterfaceImplementation::iSetShrinking (float value)
{
    IParamBlock2* pblock = getCgoUtilityInstance()->m_pblock;

    pblock->SetValue(PA_CGO_UTILITY_SHRINKING,0,value);
}

void    hctCgoUtilityFPInterfaceImplementation::iSetProtectMaterials (bool value)
{
    IParamBlock2* pblock = getCgoUtilityInstance()->m_pblock;

    pblock->SetValue(PA_CGO_UTILITY_PROTECT_MATERIALS,0,value);
}

bool    hctCgoUtilityFPInterfaceImplementation::iGetProtectMaterials ()
{
    IParamBlock2* pblock = getCgoUtilityInstance()->m_pblock;

    return pblock->GetInt(PA_CGO_UTILITY_PROTECT_MATERIALS) ? true : false;
}

void    hctCgoUtilityFPInterfaceImplementation::iSetProtectEdges (bool value)
{
    IParamBlock2* pblock = getCgoUtilityInstance()->m_pblock;

    pblock->SetValue(PA_CGO_UTILITY_PROTECT_EDGES,0,value);
}

bool    hctCgoUtilityFPInterfaceImplementation::iGetProtectEdges ()
{
    IParamBlock2* pblock = getCgoUtilityInstance()->m_pblock;

    return pblock->GetInt(PA_CGO_UTILITY_PROTECT_EDGES) ? true : false;
}

void    hctCgoUtilityFPInterfaceImplementation::iSetUseWeights (bool value)
{
    IParamBlock2* pblock = getCgoUtilityInstance()->m_pblock;

    pblock->SetValue(PA_CGO_UTILITY_USE_WEIGHTS,0,value);
}

bool    hctCgoUtilityFPInterfaceImplementation::iGetUseWeights ()
{
    IParamBlock2* pblock = getCgoUtilityInstance()->m_pblock;

    return pblock->GetInt(PA_CGO_UTILITY_USE_WEIGHTS) ? true : false;
}

void    hctCgoUtilityFPInterfaceImplementation::iSetDeleteInput (bool value)
{
    IParamBlock2* pblock = getCgoUtilityInstance()->m_pblock;

    pblock->SetValue(PA_CGO_UTILITY_DELETE_INPUT,0,value);
}

bool    hctCgoUtilityFPInterfaceImplementation::iGetDeleteInput ()
{
    IParamBlock2* pblock = getCgoUtilityInstance()->m_pblock;

    return pblock->GetInt(PA_CGO_UTILITY_DELETE_INPUT) ? true : false;
}

void    hctCgoUtilityFPInterfaceImplementation::iSetMultipass (bool value)
{
    IParamBlock2* pblock = getCgoUtilityInstance()->m_pblock;

    pblock->SetValue(PA_CGO_UTILITY_MULTIPASS,0,value);
}

bool    hctCgoUtilityFPInterfaceImplementation::iGetMultipass ()
{
    IParamBlock2* pblock = getCgoUtilityInstance()->m_pblock;

    return pblock->GetInt(PA_CGO_UTILITY_MULTIPASS) ? true : false;
}

// Actions

static hctCgoUtilityActionsImplementation theActionsImplementation
(
    HK_CGO_UTILITY_ACTIONS_ID, _T("hkCgoUtilityActions"), 0, getHkCgoUtilityDesc(),
    FP_ACTIONS,

    kActionMainUIContext,

    ACT_Optimize, _T("optimize"), IDS_CGO_UTILITY_ACTION_OPTIMIZE, 0,
        f_isEnabled, ACT_OptimizeEnabled,
        f_category, _T("havokPhysics"), IDS_CGO_UTILITY_CATEGORY_ACTIONS,
        f_ui, PB_CGO_UTILITY_PBLOCK, 0, TYPE_BUTTON, IDC_B_OPTIMIZE,
        p_end,

    p_end
);

BOOL hctCgoUtilityActionsImplementation::iOptimizeEnabled()
{
    return getCgoUtilityInstance()->canOptimize();
}

FPStatus hctCgoUtilityActionsImplementation::iOptimize()
{
    Interface* ip = GetCOREInterface();

    // We need to make a local copy of the selected nodes as the call to optimize() might clear the current selection.
    hkArray<INode*> m_selectedNodes;
    for (int i = 0; i < ip->GetSelNodeCount(); i++)
    {
        m_selectedNodes.pushBack(ip->GetSelNode(i));
    }

    INode* result= NULL;
    for (int i = 0; i < m_selectedNodes.getSize(); i++)
    {
        result = getCgoUtilityInstance()->optimize(m_selectedNodes[i]);
    }

    return result ? FPS_OK: FPS_FAIL;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
