// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Max/MaxFpInterfaces/Physics/CgoUtility/hctCgoUtilityInterface.h>

// Connection to Havok SDK through hksdkutils
#include <ContentTools/Common/SdkUtils/hctSdkUtils.h>

#include <ISceneEventManager.h>

// Access to the class description and the single utility instance
ClassDesc2*             getHkCgoUtilityDesc();
class hctCgoUtility*    getCgoUtilityInstance();

struct ProgressUpdaterMax;

// Cgo utility
/// WARNING: This feature is currently in BETA. Changes in interface, behavior or performance are to be expected.
class hctCgoUtility : public UtilityObj, public ReferenceMaker, public INodeEventCallback
{
    public:

        hctCgoUtility();
        ~hctCgoUtility();

        // Custom methods
        bool    canOptimize();
        INode*  optimize(INode* node);

        void    updateUI();

        // Inherited methods
        int NumParamBlocks() { return 1; }
        IParamBlock2* GetParamBlock( int id ) { return m_pblock; }
        IParamBlock2* GetParamBlockByID( BlockID id ) { return ( PB_CGO_UTILITY_PBLOCK == id )? m_pblock: NULL; }

        int             NumRefs()                                       { return 1; }
        RefTargetHandle GetReference( int i )                           { return ( i== PBLOCK_CgoUtility ) ? m_pblock: NULL; }
        void            SetReference( int i, RefTargetHandle rtarg )    { if( i== PB_CGO_UTILITY_PBLOCK ) m_pblock = (IParamBlock2*)rtarg; }
#if MAX_VERSION_MAJOR>=17
        RefResult NotifyRefChanged( const Interval& changeInt, RefTargetHandle hTarget, PartID& partID,  RefMessage message, BOOL propagate );
#else
        RefResult NotifyRefChanged( Interval changeInt, RefTargetHandle hTarget, PartID& partID,  RefMessage message );
#endif

        void TopologyChanged(NodeKeyTab& nodes);

        void BeginEditParams( Interface *ip, IUtil *iu );
        void EndEditParams( Interface *ip, IUtil *iu );
        void DeleteThis() {}

        void selectionChanged();
        int targetNumVerticesModified(int targetNumVertices);
        void targetVertexRatioModified();

    public:

        ClassDesc2*         m_classDesc;
        ParamMap2UserDlgProc* m_dlgProc;
        PBAccessor*         m_pBAccessor;
        ParamBlockDesc2 *   m_pBlock2;
        Interface*          m_interface;
        IParamBlock2*       m_pblock;
        NodeEventNamespace::CallbackKey m_callbackKey;

        ISpinnerControl*    m_targetNumVerticesSpinnerCtrl;
        ICustEdit*          m_targetNumVerticesEditCtrl;
        ISpinnerControl*    m_targetRatioSpinnerCtrl;
        ICustEdit*          m_targetRatioEditCtrl;
        ICustButton*        m_optimizeButtonCtrl;
        int                 m_retainmentType;
        float               m_targetVertexRatio;

        int m_targetNumVerticesUpperLimit;
        int m_targetRetainmentType;
        int m_manualTargetNumVertices;

        bool m_ignoreSetValueCallback;

};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
