// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>

#include <ContentTools/Max/MaxSceneExport/Utilities/BonesFromMesh/hctBonesFromMeshUtility.h>
#include <ContentTools/Max/MaxSceneExport/Utilities/BonesFromMesh/hctBonesFromMeshUtility_FPI.h>

/* FP INTERFACES */

static hctBonesFromMeshUtilityFPInterfaceImplementation theFPInterfaceImplementation (
    HK_BONES_FROM_MESH_UTILITY_FPINTERFACE_ID, _T("hkBonesFromMeshUtilityInterface"), 0, getHkBonesFromMeshUtilityDesc(), 0,

    FPI_CreateBonesFromMesh, _T("CreateBonesFromMesh"), IDS_BONES_FROM_MESH_UTILITY_CREATE_BONES, TYPE_BOOL, 0, 0,

    properties,

    FPI_GetBoneCreationMethod, FPI_SetBoneCreationMethod, _T("boneCreationMethod"), IDS_BONES_FROM_MESH_UTILITY_PA_BONECREATIONMETHOD, TYPE_ENUM, FPI_ENUM_BoneCreationMethod,
    FPI_GetBoneNormalAxis, FPI_SetBoneNormalAxis, _T("boneNormalAxis"), IDS_BONES_FROM_MESH_UTILITY_PA_BONENORMALAXIS, TYPE_ENUM, FPI_ENUM_BoneAxis,
    FPI_GetBoneTangentAxis, FPI_SetBoneTangentAxis, _T("boneTangentAxis"), IDS_BONES_FROM_MESH_UTILITY_PA_BONETANGENTAXIS, TYPE_ENUM, FPI_ENUM_BoneAxis,
    FPI_GetGlobalTangentAxis, FPI_SetGlobalTangentAxis, _T("globalTangentAxis"), IDS_BONES_FROM_MESH_UTILITY_PA_GLOBALTANGENTAXIS, TYPE_ENUM, FPI_ENUM_GlobalAxis,

    enums,

    FPI_ENUM_BoneCreationMethod, 2,
        _T("Per Vertex Bones"), 0,
        _T("Per Triangle Bones"), 1,

    FPI_ENUM_BoneAxis, 3,
        _T("+X"), 0,
        _T("+Y"), 1,
        _T("+Z"), 2,

    FPI_ENUM_GlobalAxis, 6,
        _T("+X"), 0,
        _T("-X"), 1,
        _T("+Y"), 2,
        _T("-Y"), 3,
        _T("+Z"), 4,
        _T("-Z"), 5,

    p_end
);

BOOL hctBonesFromMeshUtilityFPInterfaceImplementation::iCreateBonesFromMesh()
{
    bool okVal = getBonesFromMeshUtilityInstance()->createBonesFromMesh();
    return okVal ? TRUE : FALSE;
}

void hctBonesFromMeshUtilityFPInterfaceImplementation::iSetBoneCreationMethod (int boneCreationMethod)
{
    getBonesFromMeshUtilityInstance()->m_pblock->SetValue( PA_BONES_FROM_MESH_UTILITY_BONECREATIONMETHOD, 0, boneCreationMethod );
}

int hctBonesFromMeshUtilityFPInterfaceImplementation::iGetBoneCreationMethod ()
{
    return ( getBonesFromMeshUtilityInstance()->m_pblock->GetInt( PA_BONES_FROM_MESH_UTILITY_BONECREATIONMETHOD ) );
}

void hctBonesFromMeshUtilityFPInterfaceImplementation::iSetBoneNormalAxis(int boneNormalAxis)
{
    getBonesFromMeshUtilityInstance()->m_pblock->SetValue( PA_BONES_FROM_MESH_UTILITY_BONENORMALAXIS, 0, boneNormalAxis );
}

int hctBonesFromMeshUtilityFPInterfaceImplementation::iGetBoneNormalAxis ()
{
    return ( getBonesFromMeshUtilityInstance()->m_pblock->GetInt( PA_BONES_FROM_MESH_UTILITY_BONENORMALAXIS ) );
}

void hctBonesFromMeshUtilityFPInterfaceImplementation::iSetBoneTangentAxis (int boneTangentAxis)
{
    getBonesFromMeshUtilityInstance()->m_pblock->SetValue( PA_BONES_FROM_MESH_UTILITY_BONETANGENTAXIS, 0, boneTangentAxis );
}

int hctBonesFromMeshUtilityFPInterfaceImplementation::iGetBoneTangentAxis ()
{
    return ( getBonesFromMeshUtilityInstance()->m_pblock->GetInt( PA_BONES_FROM_MESH_UTILITY_BONETANGENTAXIS ) );
}

void hctBonesFromMeshUtilityFPInterfaceImplementation::iSetGlobalTangentAxis (int globalTangentAxis)
{
    getBonesFromMeshUtilityInstance()->m_pblock->SetValue( PA_BONES_FROM_MESH_UTILITY_GLOBALTANGENTAXIS, 0, globalTangentAxis );
}

int hctBonesFromMeshUtilityFPInterfaceImplementation::iGetGlobalTangentAxis ()
{
    return ( getBonesFromMeshUtilityInstance()->m_pblock->GetInt( PA_BONES_FROM_MESH_UTILITY_GLOBALTANGENTAXIS ) );
}

static hctBonesFromMeshUtilityActionsImplementation theActionsImplementation
(
 HK_BONES_FROM_MESH_UTILITY_ACTIONS_ID, _T("hkBonesFromMeshUtilityActions"), 0, getHkBonesFromMeshUtilityDesc(),
 FP_ACTIONS,

 kActionMainUIContext,

 ACT_CreateBonesFromMesh, _T("CreateBonesFromMesh"), IDS_BONES_FROM_MESH_UTILITY_ACTION_CREATE_BONES, 0,
 f_category, _T("havokCloth"), IDS_BONES_FROM_MESH_UTILITY_CATEGORY_ACTIONS,
 f_ui, PB_BONES_FROM_MESH_UTILITY_PBLOCK, 0, TYPE_BUTTON, IDC_B_CREATE_SIMULATION_BONES,
 p_end,

 p_end
 );

BOOL hctBonesFromMeshUtilityActionsImplementation::iCreateBonesFromMesh()
{
    bool okVal = getBonesFromMeshUtilityInstance()->createBonesFromMesh();
    return okVal ? TRUE : FALSE;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
