// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once


#include <ContentTools/Max/MaxSceneExport/Modifiers/hctBasicModifier.h>

#include <ContentTools/Max/MaxFpInterfaces/BonesFromMesh/hctBonesFromMeshUtilityInterface.h>

// Access to the class description and the single utility instance
class hctBonesFromMeshUtility* getBonesFromMeshUtilityInstance();
ClassDesc2* getHkBonesFromMeshUtilityDesc();

struct ProgressUpdaterMax;
//Bones From Mesh Utility
class hctBonesFromMeshUtility : public UtilityObj, public ReferenceMaker
{
public:

    hctBonesFromMeshUtility();

    // Custom methods
    bool createBonesFromMesh();

    void updateUI();

    // Inherited methods
    int NumParamBlocks() { return 1; }
    IParamBlock2* GetParamBlock( int id ) { return m_pblock; }
    IParamBlock2* GetParamBlockByID( BlockID id ) { return ( PB_BONES_FROM_MESH_UTILITY_PBLOCK == id )? m_pblock: NULL; }

    int NumRefs() { return 1; }
    RefTargetHandle GetReference( int i ) { return ( i== PBLOCK_BonesFromMeshUtility ) ? m_pblock: NULL; }
    void SetReference( int i, RefTargetHandle rtarg ) { if( i== PB_BONES_FROM_MESH_UTILITY_PBLOCK ) m_pblock = (IParamBlock2*)rtarg; }
#if MAX_VERSION_MAJOR>=17
    RefResult NotifyRefChanged( const Interval& changeInt, RefTargetHandle hTarget, PartID& partID,  RefMessage message, BOOL propagate );
#else
    RefResult NotifyRefChanged( Interval changeInt, RefTargetHandle hTarget, PartID& partID,  RefMessage message );
#endif

    void BeginEditParams( Interface *ip, IUtil *iu );
    void EndEditParams( Interface *ip, IUtil *iu );
    void DeleteThis() {}

public:

    Interface *m_interface;

    IParamBlock2* m_pblock;
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
