// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0



#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>
#include <ContentTools/Max/MaxSceneExport/Utilities/BonesFromMesh/hctBonesFromMeshUtility.h>
#include <ContentTools/Max/MaxFpInterfaces/BonesFromMesh/hctBonesFromMeshUtilityInterface.h>
#include <ContentTools/Common/SdkUtils/Cloth/BonesFromMesh/hctBonesFromMeshUtil.h>

// Connection to Havok SDK through hksdkutils
#include <ContentTools/Common/SdkUtils/hctSdkUtils.h>
#include <Common/Base/Types/Geometry/hkGeometry.h>

hctBonesFromMeshUtility* getBonesFromMeshUtilityInstance()
{
    static hctBonesFromMeshUtility theInstance;
    return &theInstance;
}


///////////////////////////////////////////////////////////////////////////////////////////
//
// The class descriptor
//
///////////////////////////////////////////////////////////////////////////////////////////

class hkCreateBonesFromMeshUtilityClassDesc : public ClassDesc2
{
public:
    int             IsPublic() { return TRUE; }
    void*           Create( BOOL loading = FALSE ) { return getBonesFromMeshUtilityInstance(); }
    const MCHAR *   ClassName() { return GetString( IDS_BONES_FROM_MESH_UTILITY_CLASS_NAME ); }
    SClass_ID       SuperClassID() { return UTILITY_CLASS_ID; }
    Class_ID        ClassID() { return HK_BONES_FROM_MESH_UTILITY_CLASS_ID; }
    const MCHAR*    Category() { return GetString( IDS_BONES_FROM_MESH_UTILITY_CATEGORY ); }
    const MCHAR*    InternalName() { return _T("hkBonesFromMeshUtility"); } // Returns fixed parsable name (scripter-visible name)
    HINSTANCE       HInstance() { return hInstance; }                    // Returns owning module handle
};

ClassDesc2* getHkBonesFromMeshUtilityDesc()
{
    static hkCreateBonesFromMeshUtilityClassDesc maxBonesFromMeshDesc;
    return &maxBonesFromMeshDesc;
}


///////////////////////////////////////////////////////////////////////////////////////////
//
// The dialog
//
///////////////////////////////////////////////////////////////////////////////////////////

class CreateBonesFromMeshDlgProc : public ParamMap2UserDlgProc
{
public:
    INT_PTR DlgProc( TimeValue t, IParamMap2 *map, HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam );
    void DeleteThis() {}
};

INT_PTR CreateBonesFromMeshDlgProc::DlgProc( TimeValue t, IParamMap2 *map, HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
    switch (msg)
    {
    case WM_INITDIALOG:
        {
            HCT_SCOPED_CONVERSIONS

            HWND comboBoxHwnd = GetDlgItem(hWnd, IDC_COMBO_BONE_NORMAL);
            ComboBox_AddString(comboBoxHwnd, TO_WINDOWS("+X"));
            ComboBox_AddString(comboBoxHwnd, TO_WINDOWS("+Y"));
            ComboBox_AddString(comboBoxHwnd, TO_WINDOWS("+Z"));

            Interval interval;
            int boneNormalAxis;
            getBonesFromMeshUtilityInstance()->m_pblock->GetValue(PA_BONES_FROM_MESH_UTILITY_BONENORMALAXIS, t, boneNormalAxis, interval);
            ComboBox_SetCurSel(comboBoxHwnd, boneNormalAxis);

            comboBoxHwnd = GetDlgItem(hWnd, IDC_COMBO_BONE_TANGENT);
            ComboBox_AddString(comboBoxHwnd, TO_WINDOWS("+X"));
            ComboBox_AddString(comboBoxHwnd, TO_WINDOWS("+Y"));
            ComboBox_AddString(comboBoxHwnd, TO_WINDOWS("+Z"));

            int boneTangentAxis;
            getBonesFromMeshUtilityInstance()->m_pblock->GetValue(PA_BONES_FROM_MESH_UTILITY_BONETANGENTAXIS, t, boneTangentAxis, interval);
            ComboBox_SetCurSel(comboBoxHwnd, boneTangentAxis);

            comboBoxHwnd = GetDlgItem(hWnd, IDC_COMBO_BONE_GLOBAL_TANGENT);
            ComboBox_AddString(comboBoxHwnd, TO_WINDOWS("+X"));
            ComboBox_AddString(comboBoxHwnd, TO_WINDOWS("-X"));
            ComboBox_AddString(comboBoxHwnd, TO_WINDOWS("+Y"));
            ComboBox_AddString(comboBoxHwnd, TO_WINDOWS("-Y"));
            ComboBox_AddString(comboBoxHwnd, TO_WINDOWS("+Z"));
            ComboBox_AddString(comboBoxHwnd, TO_WINDOWS("-Z"));

            int globalTangentAxis;
            getBonesFromMeshUtilityInstance()->m_pblock->GetValue(PA_BONES_FROM_MESH_UTILITY_GLOBALTANGENTAXIS, t, globalTangentAxis, interval);
            ComboBox_SetCurSel(comboBoxHwnd, globalTangentAxis);
        }

    case WM_LBUTTONDOWN:
    case WM_LBUTTONUP:
    case WM_MOUSEMOVE:
        getBonesFromMeshUtilityInstance()->m_interface->RollupMouseMessage( hWnd, msg, wParam, lParam );
        break;
    case WM_COMMAND:
        {
            switch (LOWORD(wParam))
            {
            case IDC_COMBO_BONE_NORMAL:
                {
                    HWND comboBoxHwnd = GetDlgItem(hWnd, IDC_COMBO_BONE_NORMAL);

                    Interval interval;
                    int boneAxis;
                    getBonesFromMeshUtilityInstance()->m_pblock->GetValue(PA_BONES_FROM_MESH_UTILITY_BONENORMALAXIS, t, boneAxis, interval);
                    LRESULT currentSelectedItem = SendMessage(comboBoxHwnd, CB_GETCURSEL, 0, 0);

                    if (currentSelectedItem != boneAxis)
                    {
                        boneAxis = currentSelectedItem;
                        getBonesFromMeshUtilityInstance()->m_pblock->SetValue(PA_BONES_FROM_MESH_UTILITY_BONENORMALAXIS, t, boneAxis);
                    }

                    break;
                }
            case IDC_COMBO_BONE_TANGENT:
                {
                    HWND comboBoxHwnd = GetDlgItem(hWnd, IDC_COMBO_BONE_TANGENT);

                    Interval interval;
                    int boneAxis;
                    getBonesFromMeshUtilityInstance()->m_pblock->GetValue(PA_BONES_FROM_MESH_UTILITY_BONETANGENTAXIS, t, boneAxis, interval);
                    LRESULT currentSelectedItem = SendMessage(comboBoxHwnd, CB_GETCURSEL, 0, 0);

                    if (currentSelectedItem != boneAxis)
                    {
                        boneAxis = currentSelectedItem;
                        getBonesFromMeshUtilityInstance()->m_pblock->SetValue(PA_BONES_FROM_MESH_UTILITY_BONETANGENTAXIS, t, boneAxis);
                    }

                    break;
                }
            case IDC_COMBO_BONE_GLOBAL_TANGENT:
                {
                    HWND comboBoxHwnd = GetDlgItem(hWnd, IDC_COMBO_BONE_GLOBAL_TANGENT);

                    Interval interval;
                    int boneAxis;
                    getBonesFromMeshUtilityInstance()->m_pblock->GetValue(PA_BONES_FROM_MESH_UTILITY_GLOBALTANGENTAXIS, t, boneAxis, interval);
                    LRESULT currentSelectedItem = SendMessage(comboBoxHwnd, CB_GETCURSEL, 0, 0);

                    if (currentSelectedItem != boneAxis)
                    {
                        boneAxis = currentSelectedItem;
                        getBonesFromMeshUtilityInstance()->m_pblock->SetValue(PA_BONES_FROM_MESH_UTILITY_GLOBALTANGENTAXIS, t, boneAxis);
                    }

                    break;
                }
            }
        }
        break;
    /*case CB_ADDSTRING:
        return DefWindowProcA(hWnd, msg, wParam, lParam);
        break;*/
    default:
        return FALSE;
    //  return DefWindowProc(hWnd, msg, wParam, lParam);
    }

    return TRUE;
}


///////////////////////////////////////////////////////////////////////////////////////////
//
// The param block descriptor
//
///////////////////////////////////////////////////////////////////////////////////////////

static CreateBonesFromMeshDlgProc g_theBonesFromMeshUtilityDlgProc;

enum
{
    MAP_GENERAL_PROPERTIES_ROLLOUT
};

/*
** Accessor : Used to update the subobjects when changes to locking checkboxes happen
*/

static ParamBlockDesc2 pbdCreateBonesFromMesh
(
    PB_BONES_FROM_MESH_UTILITY_PBLOCK, _T("CreateBonesFromMesh"), 0, getHkBonesFromMeshUtilityDesc(),
    P_AUTO_CONSTRUCT + P_AUTO_UI + P_MULTIMAP, PB_BONES_FROM_MESH_UTILITY_PBLOCK,

    // One rollout
    1,
    MAP_GENERAL_PROPERTIES_ROLLOUT,
    IDD_BONES_FROM_MESH_UTILITY_ROLLOUT_PARAMS,
    IDS_BONES_FROM_MESH_UTILITY_ROLLOUT_PARAMS,
    0, 0,
    &g_theBonesFromMeshUtilityDlgProc,

    // parameters
    PA_BONES_FROM_MESH_UTILITY_BONENORMALAXIS,
        _T("boneNormalAxis"), TYPE_INT, P_ANIMATABLE | P_RESET_DEFAULT, IDS_BONES_FROM_MESH_UTILITY_PA_BONENORMALAXIS,
        p_default,      hctBonesFromMeshUtil::B_Z_AXIS,
        p_range,        hctBonesFromMeshUtil::B_X_AXIS, hctBonesFromMeshUtil::B_Z_AXIS,
    p_end,

    PA_BONES_FROM_MESH_UTILITY_BONETANGENTAXIS,
        _T("boneTangentAxis"), TYPE_INT, P_ANIMATABLE | P_RESET_DEFAULT, IDS_BONES_FROM_MESH_UTILITY_PA_BONETANGENTAXIS,
        p_default,      hctBonesFromMeshUtil::B_X_AXIS,
        p_range,        hctBonesFromMeshUtil::B_X_AXIS, hctBonesFromMeshUtil::B_Z_AXIS,
        p_end,

    PA_BONES_FROM_MESH_UTILITY_GLOBALTANGENTAXIS,
        _T("globalTangentAxis"), TYPE_INT, P_ANIMATABLE | P_RESET_DEFAULT, IDS_BONES_FROM_MESH_UTILITY_PA_GLOBALTANGENTAXIS,
        p_default,      hctBonesFromMeshUtil::GT_Y_POSITIVE_AXIS,
        p_range,        hctBonesFromMeshUtil::GT_X_POSITIVE_AXIS, hctBonesFromMeshUtil::GT_Z_NEGATIVE_AXIS,
        p_end,

    PA_BONES_FROM_MESH_UTILITY_BONECREATIONMETHOD,
        _T("boneCreationMethod"), TYPE_INT, P_RESET_DEFAULT, IDS_BONES_FROM_MESH_UTILITY_PA_BONECREATIONMETHOD,
        p_default, 0,
        p_ui, MAP_GENERAL_PROPERTIES_ROLLOUT, TYPE_RADIO, 2, IDC_RB_PER_VERTEX_BONES, IDC_RB_PER_TRIANGLE_BONES,
        p_vals, 0, 1,

        p_end,

    p_end
);

///////////////////////////////////////////////////////////////////////////////////////////
//
// The utility implementation
//
///////////////////////////////////////////////////////////////////////////////////////////

hctBonesFromMeshUtility::hctBonesFromMeshUtility()
{
    m_pblock = NULL;
    getHkBonesFromMeshUtilityDesc()->MakeAutoParamBlocks(this);
}

#if MAX_VERSION_MAJOR>=17
    RefResult hctBonesFromMeshUtility::NotifyRefChanged( const Interval& changeInt, RefTargetHandle hTarget, PartID& partID,  RefMessage message, BOOL propagate )
#else
    RefResult hctBonesFromMeshUtility::NotifyRefChanged( Interval changeInt, RefTargetHandle hTarget, PartID& partID, RefMessage message )
#endif
{
    switch (message)
    {
    case REFMSG_CHANGE:
        pbdCreateBonesFromMesh.InvalidateUI();
        updateUI();
        break;
    }
    return REF_SUCCEED;
}

// Declare the callback function
static void _selectionChanged (void *param, NotifyInfo *info)
{
    getBonesFromMeshUtilityInstance()->updateUI();
}

void hctBonesFromMeshUtility::BeginEditParams( Interface *ip, IUtil *iu )
{
    m_interface = ip;

    // Add the rollups owned by param blocks
    getHkBonesFromMeshUtilityDesc()->BeginEditParams( (IObjParam *)ip, this, 0, this );
    updateUI();

    RegisterNotification(_selectionChanged, this, NOTIFY_SELECTIONSET_CHANGED);

}

void hctBonesFromMeshUtility::EndEditParams( Interface *ip, IUtil *iu )
{

    // Clean up the rollups owned by param blocks
    getHkBonesFromMeshUtilityDesc()->EndEditParams( (IObjParam *)ip, this, 0, this );

    m_interface = NULL;

    UnRegisterNotification(_selectionChanged, this, NOTIFY_SELECTIONSET_CHANGED);

}
void hctBonesFromMeshUtility::updateUI()
{
    if( !m_interface )
    {
        return;
    }

    getHkBonesFromMeshUtilityDesc()->InvalidateUI();
}

bool hctBonesFromMeshUtility::createBonesFromMesh()
{
    Interface* ip = GetCOREInterface();
    const TimeValue now = ip->GetTime();

    int boneCreationMethod;
    int boneNormalAxis;
    int boneTangentAxis;
    int globalTangentAxis;

    Interval interval;
    getBonesFromMeshUtilityInstance()->m_pblock->GetValue(PA_BONES_FROM_MESH_UTILITY_BONENORMALAXIS, now, boneNormalAxis, interval);
    getBonesFromMeshUtilityInstance()->m_pblock->GetValue(PA_BONES_FROM_MESH_UTILITY_BONETANGENTAXIS, now, boneTangentAxis, interval);
    getBonesFromMeshUtilityInstance()->m_pblock->GetValue(PA_BONES_FROM_MESH_UTILITY_GLOBALTANGENTAXIS, now, globalTangentAxis, interval);
    getBonesFromMeshUtilityInstance()->m_pblock->GetValue(PA_BONES_FROM_MESH_UTILITY_BONECREATIONMETHOD, now, boneCreationMethod, interval);

    // Only create bone for one selected object
    if(ip->GetSelNodeCount() == 0)
    {
        hkStringBuf errorMsg("Failed to create bones: no object was selected.");
        MessageBoxA (0, errorMsg.cString(), "Bones From Mesh Utility Error", MB_ICONEXCLAMATION | MB_OK);
        return false;
    }

    if(boneNormalAxis == boneTangentAxis)
    {
        hkStringBuf errorMsg("Failed to create bones: bone normal and tangent axis cannot be the same.");
        MessageBoxA (0, errorMsg.cString(), "Bones From Mesh Utility Error", MB_ICONEXCLAMATION | MB_OK);
        return false;
    }

    for(int objIdx = 0; objIdx < ip->GetSelNodeCount(); objIdx++)
    {
        HCT_SCOPED_CONVERSIONS;

        INode* currNode = ip->GetSelNode(objIdx);

        Object* curObject = currNode->EvalWorldState(now).obj;

        //Check if we can convert the object to an editable mesh
        if(!curObject->ConvertToType( now, Class_ID( TRIOBJ_CLASS_ID, 0 )))
        {
            hkStringBuf errorMsg("Failed to create bones for ");
            errorMsg.append(FROM_MAX(currNode->GetName()));
            errorMsg.append(" :cannot convert object into an editable mesh.");
            MessageBoxA (0, errorMsg.cString(), "Bones From Mesh Utility Error", MB_ICONEXCLAMATION | MB_OK);
            continue;
        }

        TriObject *triObject = (TriObject*) curObject->ConvertToType( now, Class_ID( TRIOBJ_CLASS_ID, 0 ) );
        Mesh& nodeMesh = triObject->mesh;

        const int numVerts = nodeMesh.getNumVerts();
        const int numFaces = nodeMesh.getNumFaces();

        //Create the geometry
        hkGeometry nodeGeometry;
        {
            // copy vertices to geometry
            hkArray<hkVector4>& nodeVertices = nodeGeometry.m_vertices;
            nodeVertices.setSize( numVerts );

            const Matrix3 objectToWorld = currNode->GetObjTMAfterWSM(now);

            for ( int vi = 0; vi < numVerts; ++vi )
            {
                //Verts are in objectSpace, so place them in world space for the bones
                Point3 pWorld = nodeMesh.verts[vi] * objectToWorld;

                hkVector4 v( pWorld.x, pWorld.y, pWorld.z );
                nodeVertices[vi] = v;
            }

            // copy triangles to geometry
            hkArray<hkGeometry::Triangle>& nodeTriangles = nodeGeometry.m_triangles;
            nodeTriangles.setSize( numFaces );

            for ( int ti = 0; ti < numFaces; ++ti )
            {
                Face& f = nodeMesh.faces[ti];
                nodeTriangles[ti].m_a = f.getVert(0);
                nodeTriangles[ti].m_b = f.getVert(1);
                nodeTriangles[ti].m_c = f.getVert(2);
            }

            for ( int ti = 0; ti < numFaces; ++ti )
            {
                Face& f = nodeMesh.faces[ti];
                nodeTriangles[ti].m_a = f.getVert(0);
                nodeTriangles[ti].m_b = f.getVert(1);
                nodeTriangles[ti].m_c = f.getVert(2);
            }
        }

        //Initialise the size of the array of transforms for the bones (depends on bone creation method used)
        hkArray<hkTransform> transformsOut;
        hkArray<hkBool> boneAxisChanged;
        {
            int numBones = 0;

            if(boneCreationMethod == hctBonesFromMeshUtil::CREATE_BONE_PER_VERTEX)
            {
                numBones = numVerts;
            }
            else if(boneCreationMethod == hctBonesFromMeshUtil::CREATE_BONE_PER_TRIANGLE)
            {
                numBones = numFaces;
            }
            transformsOut.setSize(numBones);
            boneAxisChanged.setSize(numBones, false);
        }

        if( hctBonesFromMeshUtil::createBones(nodeGeometry, transformsOut, (hctBonesFromMeshUtil::BoneAxis)boneNormalAxis,
                                                    (hctBonesFromMeshUtil::BoneAxis)boneTangentAxis, (hctBonesFromMeshUtil::GlobalTangentAxis)globalTangentAxis,
                                                        boneAxisChanged, (hctBonesFromMeshUtil::BoneCreationMethod)boneCreationMethod) )
        {
            //Create an instance of a point Helper object to represent the bone
            Object *pointObj = (Object *)ip->CreateInstance(HELPER_CLASS_ID,Class_ID(POINTHELP_CLASS_ID,0));

            // Set the "axis tripod" parameter to true
            {
                IParamBlock2* pblock2 = pointObj->GetParamBlockByID(pointobj_params);
                pblock2->SetValue(pointobj_axistripod, 0, TRUE);
            }

            int numBoneAxesChanged = 0;
            //Create the bone nodes and set their transform
            for(int boneIdx = 0; boneIdx < transformsOut.getSize(); boneIdx++)
            {
                INode* pointNode = ip->CreateObjectNode(pointObj);

                Matrix3 tm;
                hkMatrix4 transform; transform.set(transformsOut[boneIdx]);
                hctMaxUtils::convertToMatrix3( transform, tm );

                MSTR newNodeName = MSTR( currNode->GetName() ) + TEXT("_BoneSim");
                ip->MakeNameUnique(newNodeName);

                pointNode->SetNodeTM(now, tm);
                pointNode->SetName(newNodeName);

                if( boneAxisChanged[boneIdx] )
                {
                    numBoneAxesChanged++;
                }
            }

            if(numBoneAxesChanged > 0)
            {
                hkStringBuf warningMsg;
                warningMsg.printf("Global tangent axis was the same as the vertex/triangle normal for %d joints, new global tangent axis picked in these cases", numBoneAxesChanged);
                MessageBoxA (0, warningMsg.cString(), "Bones From Mesh Utility Error", MB_ICONEXCLAMATION | MB_OK);
            }
        }

        if ( curObject != triObject )
        {
            triObject->DeleteThis();
        }
    }

    return true;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
