-- Havok Physics Scripts
global hvkPhysics_createConstraintFromSelection
global hvkPhysics_createSingleRigidBody
global hvkPhysics_createCompoundRigidBody
global hvkPhysics_canCreateConstraintFromSelection
global hvkPhysics_isRigidBody
global hvkPhysics_canCreateShape
global hvkPhysics_isLocalFrame
global hvkPhysics_openRagdollTools
global hvkCommon_removeHavokModifiers

macroScript mcrPhysics_createSingleRigidBody 
	buttonText:"Create Rigid Body" 
	category:"Havok Physics" 
	tooltip:"Create Single Rigid Body"
	icon:#("HavokCT",19)	
(
	global hvkPhysics_createSingleRigidBody
	global hvkPhysics_isRigidBody
	global hvkPhysics_canCreateShape
	global hvkPhysics_isLocalFrame

	on execute do 
	(	
		undo "Create Rigid Body" on
		(
			
			hvkPhysics_createSingleRigidBody $selection updateSelection:($selection.count==1)
			
			-- force a refresh
			select $selection
		)
	)

	on isEnabled do
	(
	
		if (selection.count == 0) then return false
		
		for selNode in $selection do
		(
			if (not hvkPhysics_canCreateShape selNode) then return false
			if (hvkPhysics_isRigidBody selNode) then return false
			if (hvkPhysics_isLocalFrame selNode) then return false
		)
		
		return true
	)
)

macroScript mcrPhysics_createCompoundRigidBody 
	buttonText:"Create Compound Rigid Body" 
	category:"Havok Physics" 
	tooltip:"Create Compound Rigid Body"
	icon:#("HavokCT",9)	
(
	global hvkPhysics_createCompoundRigidBody
	global hvkPhysics_isRigidBody
	global hvkPhysics_canCreateShape
	global hvkPhysics_isLocalFrame

	on execute do 
	(	
		undo "Create Compound Rigid Body" on
		(
			hvkPhysics_createCompoundRigidBody $selection
		)
	)

	on isEnabled do
	(
		global hvkPhysics_isRigidBody
		global hvkPhysics_canCreateShape

		if (selection.count < 2) then return false
		
		for selNode in $selection do
		(
			if (not hvkPhysics_canCreateShape selNode) then return false
			if (hvkPhysics_isRigidBody selNode) then return false
		)
		
		return true
	)
)

macroScript mcrPhysics_createCapsule 
	buttonText:"Create Capsule"  
	category:"Havok Physics" 
	tooltip:"Create a capsule"
(
	on execute do
	(
		undo "Create Capsule" on
		(
			local newCapsule = TaperCapsule ()
			newCapsule.radius = 1.0
			newCapsule.taper = 1.0
			newCapsule.height = 1.0
		)
	)
)

macroScript mcrPhysics_createRigidBodyWithProxy 
	buttonText:"Create Rigid Body with Proxy(s)"  
	category:"Havok Physics" 
	tooltip:"Create a rigid body made up of other object mesh(es)"
	icon:#("HavokCT",15)	
(
	global hvkPhysics_createRigidBodyWithProxy
	global hvkPhysics_isRigidBody
	global hvkPhysics_canCreateShape
	global hvkPhysics_isLocalFrame

	on execute do
	(
		undo "Create Rigid Body with Proxy" on
		(
			hvkPhysics_createRigidBodyWithProxy $selection
		)
	)
	
	on isEnabled do
	(
		global hvkPhysics_isRigidBody
		global hvkPhysics_canCreateShape

		if (selection.count < 2) then return false
		
		for selNode in $selection do
		(
			if (not hvkPhysics_canCreateShape selNode) then return false
			if (hvkPhysics_isRigidBody selNode) then return false
		)
		
		return true
	
	)
)

macroScript mcrPhysics_removeHavokData
	buttonText:"Remove Havok Data" 
	category:"Havok Physics" 
	tooltip:"Remove Havok Data"
	icon:#("HavokCT",18)	
(
	global hvkCommon_removeHavokData

	on execute do
	(
		undo "Remove Havok Data" on
		(
			hvkCommon_removeHavokData $selection
		)
	)
	
	on isEnabled return ($selection.count>0)
)
macroScript mcrPhysics_openRagdollTools 
	buttonText:"Open Rag Doll Toolbox..."
	category:"Havok Physics" 
	tooltip:"Open Havok Rag Doll Toolbox"
	icon:#("HavokCT",17)	
(
	global hvkPhysics_openRagdollTools

	on execute do
	(
		hvkPhysics_openRagdollTools()
	)
	
	on isEnabled return (hvkPhysics_openRagdollTools != undefined)
)

macroScript mcrPhysics_createBallAndSocketConstraint 
	buttonText:"Create Ball And Socket Constraint" 
	category:"Havok Physics" 
	tooltip:"Create Ball And Socket Constraint"
	icon:#("HavokCT",8)	
(
	global hvkPhysics_createConstraintFromSelection
	global hvkPhysics_canCreateConstraintFromSelection

	on execute do
	(
		undo "Create Ball And Socket Contraint" on
		(
			hvkPhysics_createConstraintFromSelection hkBallAndSocketConstraintModifier
		)
	)
	
	on isEnabled do
	(
		return (hvkPhysics_canCreateConstraintFromSelection())
	)
)

macroScript mcrPhysics_createHingeConstraint 
	buttonText:"Create Hinge Constraint" 
	category:"Havok Physics" 
	tooltip:"Create Hinge Constraint"
	icon:#("HavokCT",13)	
(
	global hvkPhysics_createConstraintFromSelection
	global hvkPhysics_canCreateConstraintFromSelection

	on execute do
	(
		undo "Create Hinge Constraint" on
		(
			hvkPhysics_createConstraintFromSelection hkHingeConstraintModifier
		)
	)
	
	on isEnabled do
	(
		return (hvkPhysics_canCreateConstraintFromSelection())
	)
)

macroScript mcrPhysics_createRagdollConstraint 
	buttonText:"Create Rag Doll Constraint" 
	category:"Havok Physics" 
	tooltip:"Create Rag Doll Constraint"
	icon:#("HavokCT",16)	
(
	global hvkPhysics_createConstraintFromSelection
	global hvkPhysics_canCreateConstraintFromSelection

	on execute do
	(
		undo "Create Rag Doll Contraint" on
		(
			hvkPhysics_createConstraintFromSelection hkRagdollConstraintModifier
		)
	)
	
	on isEnabled do
	(
		return (hvkPhysics_canCreateConstraintFromSelection())
	)
)

macroScript mcrPhysics_createStiffSpringConstraint 
	buttonText:"Create Stiff Spring Constraint" 
	category:"Havok Physics" 
	tooltip:"Create Stiff Spring Constraint"
	icon:#("HavokCT",20)	
(
	global hvkPhysics_createConstraintFromSelection
	global hvkPhysics_canCreateConstraintFromSelection

	on execute do
	(
		undo "Create Stiff Spring Contraint" on
		(
			hvkPhysics_createConstraintFromSelection hkStiffSpringConstraintModifier
		)
	)
	
	on isEnabled do
	(
		return (hvkPhysics_canCreateConstraintFromSelection())
	)
)

macroScript mcrPhysics_createPrismaticConstraint 
	buttonText:"Create Prismatic Constraint" 
	category:"Havok Physics" 
	tooltip:"Create Prismatic Constraint"
	icon:#("HavokCT",14)	
(
	global hvkPhysics_createConstraintFromSelection
	global hvkPhysics_canCreateConstraintFromSelection

	on execute do
	(
		undo "Create Prismatic Contraint" on
		(
			hvkPhysics_createConstraintFromSelection hkPrismaticConstraintModifier
		)
	)
	
	on isEnabled do
	(
		return (hvkPhysics_canCreateConstraintFromSelection())
	)
)

macroScript mcrPhysics_createWheelConstraint 
	buttonText:"Create Wheel Constraint" 
	category:"Havok Physics" 
	tooltip:"Create Wheel Constraint"
	icon:#("HavokCT",21)	
(
	global hvkPhysics_createConstraintFromSelection
	global hvkPhysics_canCreateConstraintFromSelection

	on execute do
	(
		undo "Create Wheel Contraint" on
		(
			hvkPhysics_createConstraintFromSelection hkWheelConstraintModifier
		)
	)
	
	on isEnabled do
	(
		return (hvkPhysics_canCreateConstraintFromSelection())
	)
)

macroScript mcrPhysics_createFixedConstraint 
	buttonText:"Create Fixed Constraint" 
	category:"Havok Physics" 
	tooltip:"Create Fixed Constraint"
	icon:#("HavokCT",29)	
(
	global hvkPhysics_createConstraintFromSelection
	global hvkPhysics_canCreateConstraintFromSelection

	on execute do
	(
		undo "Create Fixed Contraint" on
		(
			hvkPhysics_createConstraintFromSelection hkFixedConstraintModifier
		)
	)
	
	on isEnabled do
	(
		return (hvkPhysics_canCreateConstraintFromSelection())
	)
)

macroScript mcrPhysics_createLocalFrame
	buttonText:"Create Local Frame"
	category:"Havok Physics"
	tooltip:"Create Local Frame"
	icon:#("HavokCT",24)
(
	global hvkPhysics_createLocalFrame
	global hvkPhysics_isRigidBody
	global hvkPhysics_canCreateShape
	global hvkPhysics_isLocalFrame

	on execute do
	(
		undo "Create Local Frame" on
		(
			hvkPhysics_createLocalFrame $selection updateSelection:($selection.count==1)
			
			-- force a refresh
			select $selection
		)
	)
	
	on isEnabled do
	(
		if (selection.count == 0) then return false
		
		for selNode in $selection do
		(
			if (not hvkPhysics_canCreateShape selNode) then return false
			if (hvkPhysics_isLocalFrame selNode) then return false
			if (hvkPhysics_isRigidBody selNode) then return false
		)
		
		return true;
	)
)

macroScript mcrPhysics_openConvexHullUtility 
	buttonText:"Open Convex Hull Utility" 
	category:"Havok Physics" 
	tooltip:"Open Convex Hull Utility" 
	icon:#("HavokCT",11)
(
	UtilityPanel.OpenUtility hkConvexHullUtility
)

macroScript mcrPhysics_openCgoUtility 
	buttonText:"Open Collision Geometry Optimizer Utility" 
	category:"Havok Physics" 
	tooltip:"Open Collision Geometry Optimizer Utility" 
	icon:#("HavokCT",30)
(
	UtilityPanel.OpenUtility hkCgoUtility
)

macroScript mcrPhysics_openConvexDecompUtility
	buttonText:"Open Convex Decomposition Toolbox"
	category:"Havok Physics" 
	tooltip:"Open Havok Convex Decomposition Toolbox"
	icon:#("HavokCT",25)
(
	global hvkPhysics_openConvexDecompositionTools

	on execute do
	(
		if ( undefined != hkConvexDecompUtility ) then
		(
			hvkPhysics_openConvexDecompositionTools()
		)
	)
	
	on isEnabled return ( hvkPhysics_openConvexDecompositionTools != undefined )
)


