-- Havok Physics Scripts
global hvkDestruction_createGenericModifier


macroScript mcrDestruction_removeHavokDestructionData
	buttonText:"Remove Havok Destruction Data" 
	category:"Havok Destruction" 
	tooltip:"Remove Havok Destruction Data"
	icon:#("HavokCT",18)	
(
	global hvkDestruction_removeHavokDestructionData
	
	on execute do
	(
		undo "Remove Havok Destruction Data" on
		(
			hvkDestruction_removeHavokDestructionData $selection
		)
	)
	
	on isEnabled return ($selection.count>0)
)


macroScript mcrDestruction_enableExplodedView
	buttonText:"Enable Exploded View for selected Breakable Body" 
	category:"Havok Destruction" 
	tooltip:"Displays an exploded view for the selected Breakable Body"
	icon:#("HavokCT",18)
(
	global hvkDestruction_enableExplodedViewForSelectedBreakableBody
	
	on execute do
	(
		undo "Enable Breakable Body Exploded View" on
		(
			hvkDestruction_enableExplodedViewForSelectedBreakableBody()
		)
	)
)


macroScript mcrDestruction_disableExplodedView
	buttonText:"Disable Exploded View for selected Breakable Body" 
	category:"Havok Destruction" 
	tooltip:"Disables the exploded view for the selected Breakable Body"
	icon:#("HavokCT",18)
(
	global hvkDestruction_disableExplodedViewForSelectedBreakableBody
	
	on execute do
	(
		undo "Disable Breakable Body Exploded View" on
		(
			hvkDestruction_disableExplodedViewForSelectedBreakableBody()
		)
	)
)


macroScript mcrDestruction_addSharedBreakableShapeModifierToSelection
	buttonText:"Add a new shared Breakable Shape modifier to all nodes in selection"
	category:"Havok Destruction" 
	tooltip:"Adds a new shared Breakable Shape modifier to all nodes in selection"
	icon:#("HavokCT",18)
(
	global hvkDestruction_addNewSharedBreakableShapeModifierToSelectedNodes
	
	on execute do
	(
		undo "Add New Shared Breakable Shape Modifier" on
		(
			hvkDestruction_addNewSharedBreakableShapeModifierToSelectedNodes()
		)
	)
)


macroScript mcrDestruction_shareExistingBreakableShapeModifierWithSelection
	buttonText:"Share an existing Breakable Shape modifier with all nodes in selection"
	category:"Havok Destruction" 
	tooltip:"Shares an existing Breakable Shape modifier with all nodes in selection"
	icon:#("HavokCT",18)
(
	global hvkDestruction_shareExistingBreakableShapeModifierWithSelectedNodes
	
	on execute do
	(
		undo "Share Existing Breakable Shape Modifier" on
		(
			hvkDestruction_shareExistingBreakableShapeModifierWithSelectedNodes()
		)
	)
)


macroScript mcrDestruction_modifierUtility
	buttonText:"Havok Modifier Utility"
	category:"Havok Destruction"
	tooltip:"Opens the Havok Modifier Utility."
	icon:#("HavokDestruction",21)
(
	global hvkModifierUtility
	
	on execute do
	(
		hvkModifierUtility()
	)
)


-- ============================================================================


macroScript mcrDestruction_Export 
	buttonText:"Export" 
	category:"Havok Destruction" 
	tooltip:"Export..." 
	icon:#("HavokCT",1)
 (
 	hkSceneExportUtility.ExportScene(false)
 )


macroScript mcrDestruction_BatchExport 
	buttonText:"Batch Export" 
	category:"Havok Destruction" 
	tooltip:"Quick Export" 
	icon:#("HavokDestruction",11)
 (
 	hkSceneExportUtility.ExportScene(true)
 )


-- ============================================================================


macroScript mcrDestruction_createSplitInHalfFracture 
	buttonText:"Split In Half" 
	category:"Havok Destruction" 
	tooltip:"Create a new Split-in-Half Fracture"
	icon:#("HavokDestruction",5)
(
	global hvkDestruction_createNewFracture
	
	on execute do 
	(
		undo "Create SplitInHalf Fracture" on
		(
			hvkDestruction_createNewFracture hkdSplitInHalfFracture "Create SplitInHalf Fracture..."
		)
	)
)


macroScript mcrDestruction_createRandomSplitFracture 
	buttonText:"Random Split" 
	category:"Havok Destruction" 
	tooltip:"Create a new Random Split Fracture"
	icon:#("HavokDestruction",4)	
(
	global hvkDestruction_createNewFracture

	on execute do 
	(	
		undo "Create Random Split Fracture" on
		(
			hvkDestruction_createNewFracture hkdRandomSplitFracture "Create Random Split Fracture..."
		)
	)
)


macroScript mcrDestruction_createWoodFracture
	buttonText:"Wood" 
	category:"Havok Destruction" 
	tooltip:"Create a new Wood Fracture"
	icon:#("HavokDestruction",3)	
(
	global hvkDestruction_createNewFracture

	on execute do 
	(	
		undo "Create Wood Fracture" on
		(
			hvkDestruction_createNewFracture hkdWoodFracture "Create Wood Fracture..."
		)
	)
)


macroScript mcrDestruction_createSliceFracture
	buttonText:"Slice" 
	category:"Havok Destruction" 
	tooltip:"Create a new Slice Fracture"
	icon:#("HavokDestruction",7)	
(
	global hvkDestruction_createNewFracture

	on execute do 
	(	
		undo "Create Slice Fracture" on
		(
			hvkDestruction_createNewFracture hkdSliceFracture "Create Slice Fracture..."
		)
	)
)


macroScript mcrDestruction_createPieFracture
	buttonText:"Pie" 
	category:"Havok Destruction" 
	tooltip:"Create a new Pie Fracture"
	icon:#("HavokDestruction",6)
(
	global hvkDestruction_createNewFracture

	on execute do 
	(	
		undo "Create Pie Fracture" on
		(
			hvkDestruction_createNewFracture hkdPieFracture "Create Pie Fracture..."
		)
	)
)


macroScript mcrDestruction_createVoronoiFracture
	buttonText:"Voronoi" 
	category:"Havok Destruction" 
	tooltip:"Create a new Voronoi Fracture"
	icon:#("HavokDestruction",14)	
(
	global hvkDestruction_createNewFracture

	on execute do 
	(	
		undo "Create Voronoi Fracture" on
		(
			hvkDestruction_createNewFracture hkdVoronoiFracture "Create Voronoi Fracture..."
		)
	)
)


macroScript mcrDestruction_createDebrisFracture
	buttonText:"Debris" 
	category:"Havok Destruction" 
	tooltip:"Create a new Debris Fracture"
	icon:#("HavokDestruction",17)	
(
	global hvkDestruction_createNewFracture

	on execute do 
	(	
		undo "Create Debris Fracture" on
		(
			hvkDestruction_createNewFracture hkdDebrisFracture "Create Debris Fracture..."
		)
	)
)


macroScript mcrDestruction_createDecomposeFracture
	buttonText:"Decompose" 
	category:"Havok Destruction" 
	tooltip:"Create a new Decompose Fracture"
	icon:#("HavokDestruction",19)
(
	global hvkDestruction_createNewFracture

	on execute do 
	(	
		undo "Create Decompose Fracture" on
		(
			hvkDestruction_createNewFracture hkdDecomposeFracture "Create Decompose Fracture..."
		)
	)
)


macroScript mcrDestruction_createCutOutFracture
	buttonText:"Cut Out" 
	category:"Havok Destruction" 
	tooltip:"Create a new Cut Out Fracture"
	icon:#("HavokDestruction",20)
(
	global hvkDestruction_createNewFracture

	on execute do 
	(	
		undo "Create Cut Out Fracture" on
		(
			hvkDestruction_createNewFracture hkdCutOutFracture "Create Cut Out Fracture..."
		)
	)
)


macroScript mcrDestruction_createScriptedFracture 
	buttonText:"Scripted" 
	category:"Havok Destruction" 
	tooltip:"Create a new Scripted Fracture"
	icon:#("HavokDestruction",23)	
(
	global hvkDestruction_createNewFracture

	on execute do 
	(	
		undo "Create Scripted Fracture" on
		(
			hvkDestruction_createNewFracture hkdScriptedFracture "Create Scripted Fracture..."
		)
	)
)


-- ============================================================================


macroScript mcrDestruction_createContactRegionController 
	buttonText:"Contact Region" 
	category:"Havok Destruction" 
	tooltip:"Attach a contact region controller to an existing Breakable Body"
	icon:#("HavokDestruction",10)	
(
	global hvkDestruction_newControllerPreCheck
	global hvkDestruction_createNewController

	on execute do 
	(
		linkFlag = 0
		userInput = hvkDestruction_newControllerPreCheck "hkdContactRegionController" "Create Contact Region Controller" &linkFlag
		if ( userInput == -1 ) then
		(
			-- internal abort or manually cancelled by user
			return true
		)

		undo "Create Contact Region Controller" on
		(
			hvkDestruction_createNewController hkdContactRegionController userInput linkFlag
		)
	)
)


macroScript mcrDestruction_createWoodController 
	buttonText:"Wood" 
	category:"Havok Destruction" 
	tooltip:"Attach a wood controller to an existing Breakable Body"
	icon:#("HavokDestruction",8)	
(
	global hvkDestruction_newControllerPreCheck
	global hvkDestruction_createNewController

	on execute do 
	(
		linkFlag = 0
		userInput = hvkDestruction_newControllerPreCheck "hkdWoodController" "Create Wood Controller" &linkFlag

		if ( userInput == -1 ) then
		(
			-- internal abort or manually cancelled by user
			return true
		)

		undo "Create Wood Controller" on
		(
			hvkDestruction_createNewController hkdWoodController userInput linkFlag
		)
	)
)


macroScript mcrDestruction_createDeformationController 
	buttonText:"Deformation" 
	category:"Havok Destruction" 
	tooltip:"Attach a deformation controller to an existing Breakable Body. [FEATURE UNDER REVIEW]"
	icon:#("HavokDestruction",9)	
(
	global hvkDestruction_newControllerPreCheck
	global hvkDestruction_createNewController

	on execute do 
	(
		linkFlag = 0
		userInput = hvkDestruction_newControllerPreCheck "hkdDeformationController" "Create Deformation Controller" &linkFlag
		if ( userInput == -1 ) then
		(
			-- internal abort or manually cancelled by user
			return true
		)

		undo "Create Deformation Controller" on
		(
			hvkDestruction_createNewController hkdDeformationController userInput linkFlag
		)
	)
)


macroScript mcrDestruction_createFlexibleJointController 
	buttonText:"Flexible Joint" 
	category:"Havok Destruction" 
	tooltip:"Attach a flexible joint controller to an existing Breakable Body"
	icon:#("HavokDestruction",18)	
(
	global hvkDestruction_newControllerPreCheck
	global hvkDestruction_createNewController

	on execute do 
	(
		linkFlag = 0
		userInput = hvkDestruction_newControllerPreCheck "hkdFlexibleJointController" "Create Flexible Joint Controller" &linkFlag
		if ( userInput == -1 ) then
		(
			-- internal abort or manually cancelled by user
			return true
		)

		undo "Create Flexible Joint Controller" on
		(
			hvkDestruction_createNewController hkdFlexibleJointController userInput linkFlag
		)
	)
)


macroScript mcrDestruction_createBuildingController 
	buttonText:"Building Controller" 
	category:"Havok Destruction" 
	tooltip:"Attach a Building Controller to an existing Breakable Body"
	icon:#("HavokDestruction",22)
(
	global hvkDestruction_newControllerPreCheck
	global hvkDestruction_createNewController

	on execute do 
	(
		linkFlag = 0
		userInput = hvkDestruction_newControllerPreCheck "hkdBuildingController" "Create Building Controller" &linkFlag
		if ( userInput == -1 ) then
		(
			-- internal abort or manually cancelled by user
			return true
		)

		undo "Create Building Controller" on
		(
			hvkDestruction_createNewController hkdBuildingController userInput linkFlag
		)
	)
)


-- ============================================================================


macroScript mcrDestruction_createBreakableBody
	buttonText:"Create Breakable Body" 
	category:"Havok Destruction" 
	tooltip:"Create individual breakable bodies from each selected mesh"
	icon:#("HavokDestruction",1)	
(
	global hvkDestruction_createBreakableBody_preCheck
	global hvkDestruction_createBreakableBody
	
	on execute do 
	(
		userInput = hvkDestruction_createBreakableBody_preCheck()
		if ( userInput == -1 ) then
		(
			-- error or user-abort
			return true
		)

		undo "Create Breakable Body" on
		(
			hvkDestruction_createBreakableBody userInput
		)
	)
)


macroScript mcrDestruction_createCompoundBreakableBody
	buttonText:"Create Compound Breakable Body" 
	category:"Havok Destruction" 
	tooltip:"Create compound breakable body from selected meshes"
	icon:#("HavokDestruction",13)	
(
	global hvkDestruction_createBreakableBodyFromParts_preCheck
	global hvkDestruction_createBreakableBodyFromParts
	
	on execute do 
	(
		masterNode = undefined
		userInput = hvkDestruction_createBreakableBodyFromParts_preCheck true &masterNode
		if ( userInput == -1 ) then
		(
			-- internal abort or manually cancelled by user
			return true
		)

		undo "Create Compound Breakable Body" on
		(
			hvkDestruction_createBreakableBodyFromParts true masterNode
		)
	)
)


macroScript mcrDestruction_createBreakablePieces
	buttonText:"Attach Nodes as Fracture Pieces" 
	category:"Havok Destruction" 
	tooltip:"Attach selected nodes as Fracture Pieces (to unfractured object)"
	icon:#("HavokDestruction",2)
(
	global hvkDestruction_createBreakableBodyFromParts_preCheck
	global hvkDestruction_createBreakableBodyFromParts

	on execute do 
	(
		masterNode = undefined
		userInput = hvkDestruction_createBreakableBodyFromParts_preCheck false &masterNode
		if ( userInput == -1 ) then
		(
			-- internal abort or manually cancelled by user
			return true
		)

		undo "Create Breakable Pieces" on
		(
			hvkDestruction_createBreakableBodyFromParts false masterNode
		)
	)
)


-- ============================================================================


macroScript mcrDestruction_createDestructionDemoConfig
	buttonText:"Create Destruction Demo Config" 
	category:"Havok Destruction" 
	tooltip:"Create the Destruction Demo Config"
	icon:#("HavokCT",19)	
(
	global hvkDestruction_createGenericModifier
	
	on execute do 
	(	
		undo "Create Destruction Demo Config" on
		(
			weaponHelper = HavokGenericHelper()
			weaponHelper.name = uniqueName "DestructionDemoConfig"
			hvkDestruction_createGenericModifier weaponHelper hkdDestructionDemoConfig
			select(weaponHelper)
			setCommandPanelTaskMode mode:#modify
		)
	)
)


-- ============================================================================


macroScript mcrDestruction_openDestructionUtils 
	buttonText:"Open Destruction Utility" 
	category:"Havok Destruction" 
	tooltip:"Open Utility that can fracture current selection" 
	icon:#("HavokDestruction",1)
(
 	UtilityPanel.OpenUtility hkDestructionUtility
)


macroScript mcrDestruction_performInModelerFracture
	buttonText:"Fracture in-place"
	category:"Havok Destruction"
	tooltip:"Fracture the selected objects in-place"
	icon:#("HavokDestruction",15)
(
	on execute do
	(
		undo "Perform In Modeler Fracture" on
		(
			newNodes = #()
			hkDestructionUtility.destruct selection newNodes
		)
	)
)


macroScript mcrDestruction_deleteInModelerFracture
	buttonText:"Delete in-place fracture pieces"
	category:"Havok Destruction"
	tooltip:"Delete the fracture pieces for the selected objects"
	icon:#("HavokDestruction",16)
(
	on execute do
	(
		undo "Delete In Modeler Fracture" on
		(
			hkDestructionUtility.destructionDelete selection
		)
	)
)
