global mcrCloth_meshChannelToolbox 
global hvkCloth_openClothTools
global hvkCloth_createExportChannel
global hvkCloth_openBoneCollidableTools

macroscript mcrCloth_meshChannelToolbox
	buttonText:"Open Havok Mesh Channel Toolbox" 
	category:"Havok Cloth" 
	tooltip:"Open Havok Mesh Channel Toolbox"
	icon:#("HavokCT",23)	
(
	global hvkCloth_openClothTools

	on execute do
	(
		hvkCloth_openClothTools ()
	)
)

macroscript mcrCloth_createClothCollidable
	buttonText:"Create Cloth Collidable" 
	category:"Havok Cloth"  
	tooltip:"Create Cloth Collidable"
	icon:#("HavokCT",22)	
(
	global hvkCloth_createClothCollidable
	global hvkCloth_canCreateClothCollidable
	
	on execute do
	(
		undo "Create Cloth Collidable" on
		(
			hvkCloth_createClothCollidable $selection updateSelection:($selection.count==1)
			
			-- force a refresh
			select $selection
		)
	)
	
	on isEnabled do
	(
		-- Check for empty selection
		if (selection.count  == 0) then return false
		-- Check compatibility
		for selNode in $selection do
		(
			if (not hvkCloth_canCreateClothCollidable selNode) then return false
		)
		return true
	)
)

macroScript mcrCloth_openBoneCollidableTools 
	buttonText:"Open Bone Collidable Toolbox..."
	category:"Havok Cloth" 
	tooltip:"Open Bone Collidable Toolbox"
	icon:#("HavokCT",26)		
(
	global hvkCloth_openBoneCollidableTools

	on execute do
	(
		hvkCloth_openBoneCollidableTools()
	)
	
	on isEnabled return (hvkCloth_openBoneCollidableTools != undefined)
)

macroScript mcrCloth_openBonesFromMeshUtility 
	buttonText:"Create Bones From Mesh..." 
	category:"Havok Cloth" 
	tooltip:"Create Bones From Mesh..."
	icon:#("HavokCT",27)		
(
	UtilityPanel.OpenUtility hkBonesFromMeshUtility
)