
------------------------------------------------------------------------------
-- FORWARD DECLARATION
------------------------------------------------------------------------------

global hvkDestruction_getGenericModifierOfType


------------------------------------------------------------------------------
-- HAVOK MODIFIER TYPES
------------------------------------------------------------------------------

function hvkDestruction_getHavokDestructionModifierTypes =
(
	-- currently our GenericModifier always returns "hkdSplitInHalfFracture" as its class... so this is kind of dirty, but at least it works :)
	local types = #(hkdSplitInHalfFracture)
	
	return types
)


------------------------------------------------------------------------------
-- LOCAL METHODS
------------------------------------------------------------------------------

function hvkDestructionDialog_addNewSharedBreakableShapeModifierToSelectedNodes node =
(
	global returnValue = 0
	global nodeIn = node
	
	rollout requester "Add new shared Breakable Shape modifier"
	(
		label _output "<placeholder>"   align:#center offset:[0,7]
		
		button reqButton1 "Skip"        width:80 offset:[0,10] across:4
		button reqButton2 "Replace"     width:80 offset:[0,10]
		button reqButton3 "Replace All" width:80 offset:[0,10]
		button reqButton4 "Cancel"      width:80 offset:[0,10]
		
		on requester open do
		(
			_output.text = "Node '" + nodeIn.name + "' already has Breakable Shape modifier."
		)
		
		on reqButton1 pressed do
		(
			-- Skip
			DestroyDialog requester
			returnValue = 1
		)

		on reqButton2 pressed do
		(
			-- Replace
			DestroyDialog requester
			returnValue = 2
		)

		on reqButton3 pressed do
		(
			-- Replace All
			DestroyDialog requester
			returnValue = 3
		)

		on reqButton4 pressed do
		(
			-- Cancel
			DestroyDialog requester
			returnValue = 0
		)
	)
	
	createDialog requester 450 75 modal:true
	
	return returnValue
)


function hvkDestruction_addAndReplaceSharedBreakableShapeModifierToNodeArray sharedhkdShapeModifier nodeArray =
(
	-- Default: do not replace automatically
	replaceAll = 0
		
	for node in nodeArray do
	(
		hkdShapeModifier = hvkDestruction_getGenericModifierOfType node "hkdShape"
		
		if ( hkdShapeModifier != undefined ) then
		(
			if ( replaceAll == 0 ) then
			(
				queryResult = hvkDestructionDialog_addNewSharedBreakableShapeModifierToSelectedNodes node
				if ( queryResult == 0 ) then
				(
					return true
				)
				if ( queryResult == 1 ) then
				(
					continue
				)
				if ( queryResult == 3 ) then
				(
					replaceAll = 1
				)
			)
			
			-- Remove existing hkdShape modifier
			deleteModifier node hkdShapeModifier
		)

		-- Add shared hkdShape modifier.
		addModifier node sharedhkdShapeModifier
	)
)


------------------------------------------------------------------------------
-- GLOBAL METHODS
------------------------------------------------------------------------------

mapped function hvkDestruction_getRootNode node =
(
	if ( node == undefined ) then
	(
		return undefined
	)

	while node.parent != undefined do
	(
		node = node.parent
	)

	return node
)


mapped function hvkDestruction_createErrorMessage &outputString errorString =
(
	if ( outputString != "" ) then
	(
		outputString = outputString + "\n"
	)
	outputString = outputString + errorString
)

mapped function hvkDestruction_setModifierAttValue theNode theType theAttName theAttValue =
(
	for modifier in theNode.modifiers do
	(
		if ( hkIsOfGenericModifierType modifier theType ) then
		(
			setProperty modifier theAttName theAttValue
		)
	)
)

mapped function hvkDestruction_removeHavokDestructionModifiers theNode =
(
	local havokDestructionModifierTypes = hvkDestruction_getHavokDestructionModifierTypes()
	
	hvkCommon_removeModifiersOfTypes theNode havokDestructionModifierTypes
)


mapped function hvkDestruction_removeHavokDestructionData theNode =
(
	-- Remove havok destruction modifiers
	hvkDestruction_removeHavokDestructionModifiers theNode
)


mapped function hvkDestruction_removeShapeModifier theNode =
(
	shapeModifier = hvkPhysics_getShapeModifier theNode
	if ( shapeModifier == undefined ) then return undefined

	deleteModifier theNode shapeModifier
)


function hvkDestruction_unGroupNode node =
(
	if ( isGroupMember(node) ) then
	(
		groupHead = node.parent
		setGroupMember node false
		deleteItem groupHead.children node
		if ( groupHead.children.count == 0 ) then
		(
			delete groupHead
		)
	)
)


function hvkDestruction_isModifierShared objectIn modifierIn =
(
	for object in selection do
	(
		if ( object != objectIn ) then
		(
			for modifier in object.modifiers do
			(
				if ( modifier == modifierIn ) then
				(
					return true
				)
			)
		)
	)
	
	return false
)


mapped function hvkDestruction_getGenericModifierOfType theNode theType =
(
	for modifier in theNode.modifiers do
	(
		if ( hkIsOfGenericModifierType modifier theType ) then
		(
			return modifier
		)
	)
	
	return undefined
)


mapped function hvkDestruction_createGenericModifier node genericCtor =
(
	genericModifier = genericCtor()
	addModifier node genericModifier

	return genericModifier
)


mapped function hvkDestruction_createHkdShapeModifier node =
(
	hkdShapeModifier = hvkDestruction_getGenericModifierOfType node "hkdShape"
	if ( hkdShapeModifier == undefined ) then
	(
		hkdShapeModifier = hvkDestruction_createGenericModifier node hkdShape
	)
	return hkdShapeModifier
)


mapped function hvkDestruction_createHkdBodyModifier node =
(
	hkdBodyModifier = hvkDestruction_getGenericModifierOfType node "hkdBody"
	if ( hkdBodyModifier == undefined ) then
	(
		hkdBodyModifier = hvkDestruction_createGenericModifier node hkdBody
	)
	return hkdBodyModifier
)


function hvkDestruction_isModifierOnNodeStack node modifier =
(
	for modifierOnStack in node.modifiers do
	(
		if ( modifierOnStack == modifier ) then
		(
			return true
		)
	)
	return false
)


function hvkDestruction_collectAllNodesInScene superNode &arrayOut =
(
	className = superclassof(classof(superNode)) as string
	if ( className == "node" ) then
	(
		append arrayOut superNode
	)

	for node in superNode.children do
	(
		hvkDestruction_collectAllNodesInScene node &arrayOut
	)
)


function hvkDestruction_getNumModifiersOfBaseType node baseType =
(
	numModifiersOfType = 0
	
	for modifier in node.modifiers do
	(
		if ( hkIsOfGenericModifierBaseType modifier baseType ) then
		(
			numModifiersOfType = numModifiersOfType + 1
		)
	)
	
	return numModifiersOfType
)


-- This utility function will move all constraints from the supplied source mesh to the target mesh.
-- It will also take care that the constraint's position is properly mapped onto the new mesh.
-- You need to pass in an array that holds all Havok Constraint Modifier types to identify all
-- constraint modifiers.
function hvkDestruction_moveHavokConstraintModifiers constraintModifierTypesArray sourceNode targetNode =
(
	for i = sourceNode.modifiers.count to 1 by -1 do
	(
		modifier = sourceNode.modifiers[i]
		modifierType = classOf modifier
		isConstraint = findItem constraintModifierTypesArray modifierType
		if ( isConstraint > 0 ) then
		(
			worldTransform = modifier.childSpaceInWorld
			addModifier targetNode modifier
			deleteModifier sourceNode modifier
			modifier.childSpaceInWorld = worldTransform
		)
	)
)


-- This utility function will switch to the supplied modifier. If necessary (i.e. if the modifier is
-- not on the also passed-in object's modifier stack) it will switch to one object that holds the
-- linked modifier on its stack.
function hvkDestruction_followLink modifierLink object =
(
	if ( modifierLink != undefined ) then
	(
		linkedModifierIndex = modPanel.getModifierIndex object modifierLink
		if ( linkedModifierIndex == undefined ) then
		(
			allNodesInScene = #()
			hvkDestruction_collectAllNodesInScene rootnode &allNodesInScene

			for node in allNodesInScene do
			(
				for modifier in node.modifiers do
				(
					if ( modifier == modifierLink ) then
					(
						object = node
						exit
					)
				)
			)
		)
		
		modPanel.setCurrentObject modifierLink node:object ui:true
	)
)


function hvkDestruction_verifyMeshLink linkedNode =
(
	newLinkedNode = linkedNode
	
	while ( newLinkedNode.parent != undefined ) do
	(
		hkdShapeModifierOfParent = hvkDestruction_getGenericModifierOfType newLinkedNode.parent "hkdShape"
		if ( hkdShapeModifierOfParent == undefined ) then
		(
			exit
		)
		
		newLinkedNode = newLinkedNode.parent
	)
	
	if ( newLinkedNode != linkedNode ) then
	(
		txt = "The selected node is a part of a Breakable Shape hierarchy.\n\nPress (YES) to link to Selected Node : " + linkedNode.name + "\nPress (NO) to link to Hierarchy Root : " + newLinkedNode.name + "\n"
		userInput = queryBox txt Title:"Linking to a node..."
		
		if ( userInput == true ) then
		(
			newLinkedNode = linkedNode
		)
	)
	
	return newLinkedNode
)


function hvkDestruction_getIconIndexForDestructionModifier modifier =
(
	if ( hkIsOfGenericModifierType modifier "hkdSplitInHalfFracture" ) then
	(
		return 4
	)
	else if ( hkIsOfGenericModifierType modifier "hkdRandomSplitFracture" ) then
	(
		return 3
	)
	else if ( hkIsOfGenericModifierType modifier "hkdWoodFracture" ) then
	(
		return 2
	)
	else if ( hkIsOfGenericModifierType modifier "hkdSliceFracture" ) then
	(
		return 6
	)
	else if ( hkIsOfGenericModifierType modifier "hkdPieFracture" ) then
	(
		return 5
	)
	else if ( hkIsOfGenericModifierType modifier "hkdWoodController" ) then
	(
		return 7
	)
	else if ( hkIsOfGenericModifierType modifier "hkdDeformationController" ) then
	(
		return 8
	)
	else if ( hkIsOfGenericModifierType modifier "hkdScriptedFracture" ) then
	(
		return 23
	)
	else
	(
		return 0
	)
)


-- This utility function will be called when a modifier is deleted from an object's modifier stack.
--
-- It will go through all modifiers on the object's modifier stack and will check all custom attributes
-- in them. If it finds a custom attribute whose value is the deleted modifier then this obviously was
-- a link to the now deleted modifier and the custom attribute's value will be set to UNDEFINED.
--
function hvkDestruction_modifierDeleted =
(
	params          = callbacks.notificationParam()
	node            = params[1]
	deletedModifier = params[2]
	
	-- Process all modifiers in the object.
	for modifier in node.modifiers do
	(
		-- Process all custom attributes sets in the current modifier (usually will be just one).
		numCustomAttributesSet = custAttributes.count modifier
		for customAttributesSetIndex = 1 to numCustomAttributesSet do
		(
			-- Process all custom attributes in set.
			customAttributesSet   = custAttributes.get modifier customAttributesSetIndex
			customAttributesArray = getPropNames customAttributesSet
			for customAttribute in customAttributesArray do
			(
				-- Retrieve custom attribute's value.
				customAttributeValue = getProperty customAttributesSet customAttribute
				if ( customAttributeValue == deletedModifier ) then
				(
					setProperty customAttributesSet customAttribute undefined
				)
			)
		)
	)
)


-- This utility function will check if the supplied modifier is on the supplied
-- node's modifier stack. If it isn't, it will simply add it.
function hvkDestruction_assertLinkedModifierIsOnStack node linkedModifier =
(
	linkedModifierIsOnStack = false
	
	for modifierOnStack in node.modifiers do
	(
		if ( modifierOnStack == linkedModifier ) then
		(
			linkedModifierIsOnStack = true
			exit
		)
	)
	
	if ( linkedModifierIsOnStack == false ) then
	(
		addModifier node linkedModifier
	)
)


-- This utility function will copy over the values for all matching custom attributes
-- between the source modifier and the destination modifier.
function hvkDestruction_copyModifierData srcModifier dstModifier =
(
	numSrcCustomAttributesSet = custAttributes.count srcModifier
	for srcCustomAttributesSetIndex = 1 to numSrcCustomAttributesSet do
	(
		srcCustomAttributesSet   = custAttributes.get srcModifier srcCustomAttributesSetIndex
		srcCustomAttributesArray = getPropNames srcCustomAttributesSet

		for srcCustomAttribute in srcCustomAttributesArray do
		(
			srcCustomAttributeValue = getProperty srcCustomAttributesSet srcCustomAttribute
			
			-- Here we now have the source attribute... now we need to locate the matching
			-- attribute in the destination modifier.
			
			numDstCustomAttributesSet = custAttributes.count dstModifier
			for dstCustomAttributesSetIndex = 1 to numDstCustomAttributesSet do
			(
				dstCustomAttributesSet   = custAttributes.get dstModifier dstCustomAttributesSetIndex
				dstCustomAttributesArray = getPropNames dstCustomAttributesSet
				
				attributeHasBeenCopied = false

				for dstCustomAttribute in dstCustomAttributesArray do
				(
					if ( dstCustomAttribute == srcCustomAttribute ) then
					(
						setProperty dstCustomAttributesSet dstCustomAttribute srcCustomAttributeValue
						attributeHasBeenCopied = true
						exit
					)
				)

				-- As soon as we have successfully copied the attribute we can abort searching for it				
				if ( attributeHasBeenCopied == true ) then
				(
					exit
				)
			)
		)
	)
)


function hvkDestruction_transferConnectivityFromFractureToShape =
(
	allNodesInScene = #()
	hvkDestruction_collectAllNodesInScene rootnode &allNodesInScene

	for node in allNodesInScene do
	(
		hkdShapeModifier = hvkDestruction_getGenericModifierOfType node "hkdShape"
		if ( hkdShapeModifier != undefined ) then
		(
			firstFractureModifier = hkdShapeModifier.fractureHkUnique
			if ( firstFractureModifier != undefined ) then
			(
				hkdShapeModifier.connectivity = firstFractureModifier.connectivityType
			)
		)
	)
)


mapped function hvkDestruction_scaleBreakableShape maxNode scaleValue =
(
	numChildrenScaled = 0
	for i = 1 to maxNode.children.count do
	(
		childScaled = hvkDestruction_scaleBreakableShape maxNode.children[i] scaleValue
		numChildrenScaled = numChildrenScaled + childScaled
	)

	hkdShapeModifier = hvkDestruction_getGenericModifierOfType maxNode "hkdShape"
	hkdBodyModifier  = hvkDestruction_getGenericModifierOfType maxNode "hkdBody"

	-- Only scale if the node is a Fracture Piece (hkdShape but not hkdBody) and if it is a leaf node
	-- (not counting children that are purely physics nodes).
	if ( hkdShapeModifier != undefined AND hkdBodyModifier == undefined AND numChildrenScaled == 0 ) do
	(
		pivotPosition = maxNode.pivot
		CenterPivot maxNode
		maxNode.scale = [scaleValue, scaleValue, scaleValue]
		maxNode.pivot = pivotPosition
		selectMore maxNode
		return 1
	)

	return 0
)


mapped function hvkDestruction_scaleDownBreakableBody maxNode =
(
	hkdShapeModifier = hvkDestruction_getGenericModifierOfType maxNode "hkdShape"
	hkdBodyModifier  = hvkDestruction_getGenericModifierOfType maxNode "hkdBody"
	if ( hkdShapeModifier == undefined OR hkdBodyModifier == undefined ) do
	(
		messagebox("Exploded View only works on a Breakable Body.")
		return false
	)

	clearSelection()
	hvkDestruction_scaleBreakableShape maxNode 0.75

	-- Zoom all Viewports on current selection
	max zoomext sel all

	-- Isolate current selection
	-- Changes in v2013
	if ((maxVersion())[1]>=15000) then
	(
		IsolateSelection.EnterIsolateSelectionMode()
	)
	else
	(
		macros.run "Tools" "Isolate_Selection"
	)

	--Iso2Roll.open
)


mapped function hvkDestruction_enableExplodedViewForSelectedBreakableBody =
(
	maxNode = $selection[1]
	if ( maxNode != undefined ) then
	(
		hvkDestruction_scaleDownBreakableBody(maxNode)
	)
)


mapped function hvkDestruction_disableExplodedViewForSelectedBreakableBody =
(
	for i = 1 to selection.count do
	(
		maxNode = $selection[i]
		hvkDestruction_scaleBreakableShape maxNode 1.0
	)
)


mapped function hvkDestruction_addNewSharedBreakableShapeModifierToSelectedNodes =
(
	sharedhkdShapeModifier = hkdShape()
	hvkDestruction_addAndReplaceSharedBreakableShapeModifierToNodeArray sharedhkdShapeModifier $selection
)


mapped function hvkDestruction_shareExistingBreakableShapeModifierWithSelectedNodes =
(
	if ( $selection.count < 2 ) then
	(
		messagebox "You need at least 2 nodes in the selection for this operation. Aborting..." title:"Error"
		return false
	)

	sourceNode = $selection[1]
	sharedhkdShapeModifier = hvkDestruction_getGenericModifierOfType sourceNode "hkdShape"
	if ( sharedhkdShapeModifier == undefined ) then
	(
		msg = "Source node '" + sourceNode.name + "' does not have a Breakable Shape modifier. Aborting..."
		messagebox msg title:"Error"
		return false
	)

	msg = "Share Breakable Shape modifier from node '" + sourceNode.name + "' with rest of selection?"
	userInput = queryBox msg
	if ( userInput == false ) then
	(
		return false
	)

	-- make a copy of the selection, remove the source node and add the shared modifier to the rest of the selection
	nodeArray = #()
	join nodeArray $selection
	nodeArray = deleteItem nodeArray 1
	hvkDestruction_addAndReplaceSharedBreakableShapeModifierToNodeArray sharedhkdShapeModifier nodeArray
)


mapped function hvkDestruction_shareTopModifierWithSelectedNodes =
(
	if ( $selection.count < 2 ) then
	(
		messagebox "You need at least 2 nodes in the selection for this operation. Aborting..." title:"Error"
		return false
	)

	sourceNode = $selection[1]

	if ( sourceNode.modifiers.count < 1 ) then
	(
		msg = "Source node '" + sourceNode.name + "' has no modifiers on its stack. Aborting..."
		messagebox msg title:"Error"
		return false
	)

	sharedModifier = sourceNode.modifiers[1]

	msg = "Share '" + sharedModifier.name + "' modifier from node '" + sourceNode.name + "' with rest of selection?"
	userInput = queryBox msg
	if ( userInput == false ) then
	(
		return false
	)

	for i = 2 to selection.count do
	(
		node = selection[i]
		addModifier node sharedModifier
	)
)


mapped function hvkDestruction_shareAllModifiersWithSelectedNodes =
(
	if ( $selection.count < 2 ) then
	(
		messagebox "You need at least 2 nodes in the selection for this operation. Aborting..." title:"Error"
		return false
	)

	sourceNode = $selection[1]

	if ( sourceNode.modifiers.count < 1 ) then
	(
		msg = "Source node '" + sourceNode.name + "' has no modifiers on its stack. Aborting..."
		messagebox msg title:"Error"
		return false
	)

	for i = 1 to sourceNode.modifiers.count do
	(
		sharedModifier = sourceNode.modifiers[i]

		msg = "Share '" + sharedModifier.name + "' modifier from node '" + sourceNode.name + "' with rest of selection?"
		userInput = queryBox msg
		if ( userInput == false ) then
		(
			continue
		)

		for k = 2 to selection.count do
		(
			node = selection[k]
			addModifier node sharedModifier
		)
	)
)

function hvkDestruction_deleteAllDefs =
(
	resetMaxFile #noPrompt
	local sceneDefs = custAttributes.getSceneDefs ()
	
	for d in sceneDefs do
	(
		if matchPattern d.name pattern:"hkd*" do
		(
			instances = custAttributes.getDefInstances d

			for i in instances do
			(
				owner = custAttributes.getOwner i
				
				if owner != undefined do
				(
					for caIndex = 1 to (custAttributes.count owner) do
					(
						if ((custAttributes.get owner caIndex).name == d.name) do
						(
							custAttributes.makeUnique owner caIndex;
							custAttributes.delete owner caIndex;
						)
					)
				)
			)
			
			try
			(
				format "Deleting definition %\n" d.name
				custAttributes.deleteDef d
			)
			catch
			(
				format "Failed to delete definition %\n" d.name
			)
		)
	)
)
