
-- Perform a version check and e.g. warn the user about required Service Packs.
hctVersionCheck()

-- Force the spinner precision to 5 digits as some Destruction parameters require this.
preferences.spinnerPrecision = 5

--
-- TOOLBAR
--

if (hkdToolbarGUP != undefined) then
(
	-- Hide the toolbar to avoid flickering
	wasVisible = hkdToolbarGUP.isVisible()
	hkdToolbarGUP.hide()
	-- hkdToolbarGUP.addMacro "Havok Destruction" "mcrDestruction_Export"
	-- hkdToolbarGUP.addMacro "Havok Destruction" "mcrDestruction_BatchExport"
	-- hkdToolbarGUP.addSeparator()
	hkdToolbarGUP.addMacro "Havok Destruction" "mcrDestruction_createBreakableBody"
	hkdToolbarGUP.addMacro "Havok Destruction" "mcrDestruction_createBreakablePieces"
	hkdToolbarGUP.addMacro "Havok Destruction" "mcrDestruction_createCompoundBreakableBody"
	hkdToolbarGUP.addSeparator()
	hkdToolbarGUP.addMacro "Havok Destruction" "mcrDestruction_createPieFracture"
	hkdToolbarGUP.addMacro "Havok Destruction" "mcrDestruction_createRandomSplitFracture"
	hkdToolbarGUP.addMacro "Havok Destruction" "mcrDestruction_createSliceFracture"
	hkdToolbarGUP.addMacro "Havok Destruction" "mcrDestruction_createSplitInHalfFracture"
	hkdToolbarGUP.addMacro "Havok Destruction" "mcrDestruction_createWoodFracture"
	hkdToolbarGUP.addMacro "Havok Destruction" "mcrDestruction_createVoronoiFracture"
	hkdToolbarGUP.addMacro "Havok Destruction" "mcrDestruction_createDebrisFracture"
	hkdToolbarGUP.addMacro "Havok Destruction" "mcrDestruction_createDecomposeFracture"
	hkdToolbarGUP.addMacro "Havok Destruction" "mcrDestruction_createCutOutFracture"
	hkdToolbarGUP.addMacro "Havok Destruction" "mcrDestruction_createScriptedFracture"
	hkdToolbarGUP.addSeparator()
	hkdToolbarGUP.addMacro "Havok Destruction" "mcrDestruction_createWoodController"
    hkdToolbarGUP.addMacro "Havok Destruction" "mcrDestruction_createDeformationController"
	hkdToolbarGUP.addMacro "Havok Destruction" "mcrDestruction_createFlexibleJointController"
	hkdToolbarGUP.addMacro "Havok Destruction" "mcrDestruction_createBuildingController"
	hkdToolbarGUP.addSeparator()
	hkdToolbarGUP.addMacro "Havok Destruction" "mcrDestruction_performInModelerFracture"
	hkdToolbarGUP.addMacro "Havok Destruction" "mcrDestruction_deleteInModelerFracture"
	hkdToolbarGUP.addSeparator()
	hkdToolbarGUP.addMacro "Havok Destruction" "mcrDestruction_modifierUtility"

	-- restore the toolbar
	if (wasVisible) then hkdToolbarGUP.show()
)



--
-- MENU
-- 

function hvkDestruction_createFractureMenuFromClasses parentMenu =
(
	classesArray = #()
	hctGetDerivedClassesInfo "hkdFracture" classesArray

	for classArrayIdx = 1 to classesArray.count by 3 do
	(
		className   = classesArray[classArrayIdx+0]
		displayName = classesArray[classArrayIdx+1]
		classification = classesArray[classArrayIdx+2]

		category    =	"Havok Destruction"
		scriptName  =	className + "MenuScript"
		toolTipText =	""
		menuText    =	displayName + (if (classification == "1") then " [UNDER REVIEW]" else "")
		scriptBody  =	"on execute do"																					+ "\n" +
						"("																								+ "\n" +
						"	undo \"Create " + displayName + "\" on"														+ "\n" +
						"	("																							+ "\n" +
						"		hvkDestruction_createNewFracture " + className + " \"Create " + displayName + "...\""	+ "\n" +
						"	)"																							+ "\n" +
						")"																								+ "\n"

		macroScriptID = macros.new category scriptName toolTipText menuText scriptBody

		menuItem = menuMan.createActionItem scriptName category
		parentMenu.addItem menuItem -1
	)
)


function hvkDestruction_createControllerMenuFromClasses parentMenu =
(
	classesArray = #()
	hctGetDerivedClassesInfo "hkdController" classesArray

	for classArrayIdx = 1 to classesArray.count by 3 do
	(
		className   = classesArray[classArrayIdx+0]
		displayName = classesArray[classArrayIdx+1]
		classification = classesArray[classArrayIdx+2]

		category    =	"Havok Destruction"
		scriptName  =	className + "MenuScript"
		toolTipText =	""
		menuText    =	displayName + (if (classification == "1") then " [UNDER REVIEW]" else "")
		scriptBody  =	"on execute do"																											+ "\n" +
						"("																														+ "\n" +
						"	linkFlag = 0"																										+ "\n" +
						"	userInput = hvkDestruction_newControllerPreCheck \"" + className + "\" \"Create " + displayName + "\" &linkFlag"	+ "\n" +
						"	if ( userInput == -1 ) then"																						+ "\n" +
						"	("																													+ "\n" +
						"		return true"																									+ "\n" +
						"	)"																													+ "\n" +
						"	undo \"Create " + displayName + "\" on"																				+ "\n" +
						"	("																													+ "\n" +
						"		hvkDestruction_createNewController " + className + " userInput linkFlag"										+ "\n" +
						"	)"																													+ "\n" +
						")"																														+ "\n"

		macroScriptID = macros.new category scriptName toolTipText menuText scriptBody

		menuItem = menuMan.createActionItem scriptName category
		parentMenu.addItem menuItem -1
	)
)


function hvkDestruction_createWeaponMenuFromClasses parentMenu =
(
	classesArray = #()
	hctGetDerivedClassesInfo "hkpFirstPersonGun" classesArray

	for classArrayIdx = 1 to classesArray.count by 3 do
	(
		className   = classesArray[classArrayIdx+0]
		displayName = classesArray[classArrayIdx+1]
		classification = classesArray[classArrayIdx+2]

		category    =	"Havok Destruction"
		scriptName  =	className + "MenuScript"
		toolTipText =	""
		menuText    =	displayName + (if (classification == "1") then " [UNDER REVIEW]" else "")
		scriptBody  =	"on execute do"																+ "\n" +
						"("																			+ "\n" +
						"	undo \"Create " + displayName + "\" on"									+ "\n" +
						"	("																		+ "\n" +
						"		weaponHelper = HavokGenericHelper()"								+ "\n" +
						"		weaponHelper.name = uniqueName \"" + displayName + "\""				+ "\n" +
						"		hvkDestruction_createGenericModifier weaponHelper " + className		+ "\n" +
						"		select(weaponHelper)"												+ "\n" +
						"		setCommandPanelTaskMode mode:#modify"								+ "\n" +
						"	)"																		+ "\n" +
						")"																			+ "\n"

		macroScriptID = macros.new category scriptName toolTipText menuText scriptBody

		menuItem = menuMan.createActionItem scriptName category
		parentMenu.addItem menuItem -1
	)
)


function hvkDestruction_createPhysicsActionMenuFromClasses parentMenu =
(
	classesArray = #()
	hctGetDerivedClassesInfo "hkpAction" classesArray

	for classArrayIdx = 1 to classesArray.count by 3 do
	(
		className   = classesArray[classArrayIdx+0]
		displayName = classesArray[classArrayIdx+1]
		classification = classesArray[classArrayIdx+2]

		category    =	"Havok Destruction"
		scriptName  =	className + "MenuScript"
		toolTipText =	""
		menuText    =	displayName + (if (classification == "1") then " [UNDER REVIEW]" else "")
		scriptBody  =	"on execute do"																					+ "\n" +
						"("																								+ "\n" +
						"	undo \"Create " + displayName + "\" on"														+ "\n" +
						"	("																							+ "\n" +
						"		hvkDestruction_createNewAction " + className + " \"Create " + displayName + "...\""		+ "\n" +
						"	)"																							+ "\n" +
						")"																								+ "\n"

		macroScriptID = macros.new category scriptName toolTipText menuText scriptBody

		menuItem = menuMan.createActionItem scriptName category
		parentMenu.addItem menuItem -1
	)
)


function hvkDestruction_createActionMenuFromClasses parentMenu =
(
	classesArray = #()
	hctGetDerivedClassesInfo "hkdAction" classesArray

	for classArrayIdx = 1 to classesArray.count by 3 do
	(
		className   = classesArray[classArrayIdx+0]
		displayName = classesArray[classArrayIdx+1]
		classification = classesArray[classArrayIdx+2]

		category    =	"Havok Destruction"
		scriptName  =	className + "MenuScript"
		toolTipText =	""
		menuText    =	displayName + (if (classification == "1") then " [UNDER REVIEW]" else "")
		scriptBody  =	"on execute do"																					+ "\n" +
						"("																								+ "\n" +
						"	undo \"Create " + displayName + "\" on"														+ "\n" +
						"	("																							+ "\n" +
						"		hvkDestruction_createNewAction " + className + " \"Create " + displayName + "...\""		+ "\n" +
						"	)"																							+ "\n" +
						")"																								+ "\n"

		macroScriptID = macros.new category scriptName toolTipText menuText scriptBody

		menuItem = menuMan.createActionItem scriptName category
		parentMenu.addItem menuItem -1
	)
)


function hvkDestruction_createInfoMenuFromClasses parentMenu =
(
	classesArray = #()
	hctGetDerivedClassesInfo "hkdInfo" classesArray

	for classArrayIdx = 1 to classesArray.count by 3 do
	(
		className   = classesArray[classArrayIdx+0]
		displayName = classesArray[classArrayIdx+1]
		classification = classesArray[classArrayIdx+2]

		category    =	"Havok Destruction"
		scriptName  =	className + "MenuScript"
		toolTipText =	""
		menuText    =	displayName + (if (classification == "1") then " [UNDER REVIEW]" else "")
		scriptBody  =	"on execute do"																					+ "\n" +
						"("																								+ "\n" +
						"	undo \"Create " + displayName + "\" on"														+ "\n" +
						"	("																							+ "\n" +
						"		hvkDestruction_createNewInfo " + className + " \"Create " + displayName + "...\""		+ "\n" +
						"	)"																							+ "\n" +
						")"																								+ "\n"

		macroScriptID = macros.new category scriptName toolTipText menuText scriptBody

		menuItem = menuMan.createActionItem scriptName category
		parentMenu.addItem menuItem -1
	)
)


function hvkDestruction_createHavokDestructionMenu =
(
	local algorithmSubMenu = menuMan.createMenu "Create Fracture"
	hvkDestruction_createFractureMenuFromClasses algorithmSubMenu

	local controllersSubMenu = menuMan.createMenu "Create Controller"
	hvkDestruction_createControllerMenuFromClasses controllersSubMenu

	local actionsSubMenu = menuMan.createMenu "Create Action"
	hvkDestruction_createActionMenuFromClasses actionsSubMenu

	local infosSubMenu = menuMan.createMenu "Create Infos"
	hvkDestruction_createInfoMenuFromClasses infosSubMenu

	local weaponsSubMenu = menuMan.createMenu "Create Weapon"
	hvkDestruction_createWeaponMenuFromClasses weaponsSubMenu

	local physicsActionsSubMenu = menuMan.createMenu "Create Physics Action"
	hvkDestruction_createPhysicsActionMenuFromClasses physicsActionsSubMenu

	local destructionInternalSubMenu = menuMan.createMenu "Internal Demo Data"

	item = menuMan.createActionItem "mcrDestruction_createDestructionDemoConfig" "Havok Destruction"
	destructionInternalSubMenu.addItem item -1
	item = menuMan.createSubMenuItem "" weaponsSubMenu
	destructionInternalSubMenu.addItem item -1
	
	local destructionUtilitiesSubMenu = menuMan.createMenu "Utilities"

	item = menuMan.createActionItem "mcrDestruction_enableExplodedView" "Havok Destruction"
	destructionUtilitiesSubMenu.addItem item -1
	item = menuMan.createActionItem "mcrDestruction_disableExplodedView" "Havok Destruction"
	destructionUtilitiesSubMenu.addItem item -1
	item = menuMan.createSeparatorItem()
	destructionUtilitiesSubMenu.addItem item -1
	item = menuMan.createActionItem "mcrDestruction_modifierUtility" "Havok Destruction"
	destructionUtilitiesSubMenu.addItem item -1
	item = menuMan.createSeparatorItem()
	destructionUtilitiesSubMenu.addItem item -1
	item = menuMan.createActionItem "mcrDestruction_addSharedBreakableShapeModifierToSelection" "Havok Destruction"
	destructionUtilitiesSubMenu.addItem item -1
	item = menuMan.createActionItem "mcrDestruction_shareExistingBreakableShapeModifierWithSelection" "Havok Destruction"
	destructionUtilitiesSubMenu.addItem item -1



	local destructionMenu = menuMan.createMenu "Destruction"
 	
	item = menuMan.createActionItem "mcrDestruction_createBreakableBody" "Havok Destruction"
	destructionMenu.addItem item -1
	item = menuMan.createActionItem "mcrDestruction_createBreakablePieces" "Havok Destruction"
	destructionMenu.addItem item -1
	item = menuMan.createActionItem "mcrDestruction_createCompoundBreakableBody" "Havok Destruction"
	destructionMenu.addItem item -1
	item = menuMan.createActionItem "mcrDestruction_openDestructionUtils" "Havok Destruction"
	destructionMenu.addItem item -1
	item = menuMan.createSeparatorItem()
	destructionMenu.addItem item -1
	item = menuMan.createSubMenuItem "" algorithmSubMenu
	destructionMenu.addItem item -1
	item = menuMan.createSeparatorItem()
	destructionMenu.addItem item -1
	item = menuMan.createSubMenuItem "" controllersSubMenu
	destructionMenu.addItem item -1
	item = menuMan.createSeparatorItem()
	destructionMenu.addItem item -1
	item = menuMan.createSubMenuItem "" actionsSubMenu
	destructionMenu.addItem item -1
	item = menuMan.createSeparatorItem()
	destructionMenu.addItem item -1
	item = menuMan.createSubMenuItem "" infosSubMenu
	destructionMenu.addItem item -1
	item = menuMan.createSeparatorItem()
	destructionMenu.addItem item -1
	item = menuMan.createSubMenuItem "" physicsActionsSubMenu
	destructionMenu.addItem item -1
	item = menuMan.createSeparatorItem()
	destructionMenu.addItem item -1
	item = menuMan.createSubMenuItem "" destructionInternalSubMenu
	destructionMenu.addItem item -1
	item = menuMan.createSeparatorItem()
	destructionMenu.addItem item -1
	item = menuMan.createSubMenuItem "" destructionUtilitiesSubMenu
	destructionMenu.addItem item -1
	item = menuMan.createSeparatorItem()
	destructionMenu.addItem item -1
	item = menuMan.createActionItem "mcrDestruction_removeHavokDestructionData" "Havok Destruction"
	destructionMenu.addItem item -1

	local mainMenuBar = menuMan.getMainMenuBar()

	for i=1 to mainMenuBar.numItems() do
	(
		mItem = mainMenuBar.getItem i
		if (mItem.getTitle() == "Havok Content Tools") then
		(
			item = menuMan.createSeparatorItem()
			(mItem.getSubMenu()).addItem item -1
			
			item = menuMan.createSubMenuItem "Havok Destruction" destructionMenu
			(mItem.getSubMenu()).addItem item -1
		)
	)

	menuMan.updateMenuBar()
)

function hvkDestruction_repairHavokDestructionMenu =
(
	hvkPhysics_repairHavokPhysicsMenu()
	hvkCloth_createHavokClothMenu()
	hvkDestruction_createHavokDestructionMenu()
)

if menuMan.registerMenuContext 0x2800a039 then
(
	hvkDestruction_createHavokDestructionMenu()
)
else
(
	hvkDestruction_repairHavokDestructionMenu()
)
