
------------------------------------------------------------------------------
-- EXTERNAL METHODS
------------------------------------------------------------------------------

global hvkDestruction_collectAllNodesInScene


------------------------------------------------------------------------------
-- GLOBAL METHODS
------------------------------------------------------------------------------

global g_selectedModifier = undefined
global g_baseType         = undefined

function hvkDestruction_openGenericSelectionWindow baseType windowTitle currentlyLinkedModifier =
(
	g_baseType = baseType

	iconBitmapFile = (getDir #ui_ln) + "icons\\HavokDestruction_24i.bmp"
	img = dotNetObject "System.Drawing.Bitmap" iconBitmapFile

	global treeViewImageList    = dotNetObject "System.Windows.Forms.ImageList"
	treeViewImageList.ImageSize = dotNetObject "System.Drawing.Size" 24 24
	treeViewImageList.Images.AddStrip(img)

	rollout selectionWindow windowTitle
	(
		dotNetControl treeView "TreeView"
		button        btSelect        "Select"         width:80 height:20 across:4
		button        btCollapseAll   "Collapse All"   width:80 height:20
		button        btUnCollapseAll "Uncollapse All" width:80 height:20
		button        btCancel        "Cancel"         width:80 height:20

		local treeViewOffsetX        =  0
		local buttonWidth            = 80
		local buttonHeight           = 20
		local buttonTopBottomSpacing = 10
		local treeViewRootNodes      = #()

		function resizeGuiElements windowWidth windowHeight =
		(
			treeView.width  = windowWidth - treeViewOffsetX
			treeView.height = windowHeight - (buttonHeight+2*buttonTopBottomSpacing)
			
			leftRightBorder = treeViewOffsetX / 2
			buttonSpacing   = (windowWidth - (2*leftRightBorder) - (4*buttonWidth)) / 3
			
			btSelect.pos.x        = leftRightBorder
			btCollapseAll.pos.x   = leftRightBorder + 1*(buttonWidth+buttonSpacing)
			btUnCollapseAll.pos.x = leftRightBorder + 2*(buttonWidth+buttonSpacing)
			btCancel.pos.x        = leftRightBorder + 3*(buttonWidth+buttonSpacing)
			
			btSelect.pos.y        = windowHeight - buttonTopBottomSpacing - buttonHeight
			btCollapseAll.pos.y   = windowHeight - buttonTopBottomSpacing - buttonHeight
			btUnCollapseAll.pos.y = windowHeight - buttonTopBottomSpacing - buttonHeight
			btCancel.pos.y        = windowHeight - buttonTopBottomSpacing - buttonHeight
		)
		
		function fillTreeView =
		(
			treeView.imageList  = treeViewImageList
			treeView.ItemHeight = 28

			fontName       = treeView.Font.Name
			fontSize       = treeView.Font.SizeInPoints
			fontModeBold   = (dotNetClass "System.Drawing.FontStyle").Bold
			fontModeItalic = (dotNetClass "System.Drawing.FontStyle").Italic
			boldFont       = dotNetObject "System.Drawing.Font" fontName fontSize fontModeBold
			italicFont     = dotNetObject "System.Drawing.Font" fontName fontSize fontModeItalic

			allNodesInScene = #()
			hvkDestruction_collectAllNodesInScene rootnode &allNodesInScene

			for node in allNodesInScene do
			(
				hkdShapeModifier       = hvkDestruction_getGenericModifierOfType node "hkdShape"
				hkdBodyModifier        = hvkDestruction_getGenericModifierOfType node "hkdBody"
				numModifiersOnStack    = hvkDestruction_getNumModifiersOfBaseType node g_baseType

				if ( numModifiersOnStack > 0 ) then
				(
					newObjectNode            = treeView.Nodes.add node.name
					newObjectNode.tag        = dotNetMXSValue node
					newObjectNode.imageIndex = newObjectNode.selectedImageIndex = 0
					newObjectNode.ForeColor  = (dotNetClass "System.Drawing.Color").Black

					append treeViewRootNodes newObjectNode

					-- Highlight the currently selected object in BOLD (we have to add some empty spaces to the display text
					-- to avoid the actual text getting truncated.
					if ( node == selection[1] ) then
					(
						newObjectNode.Text     = newObjectNode.Text + "        "
						newObjectNode.NodeFont = boldFont
					)

					for modifier in node.modifiers do
					(
						if ( hkIsOfGenericModifierBaseType modifier g_baseType ) then
						(
							newModifierNode            = newObjectNode.Nodes.add modifier.name
							newModifierNode.Tag        = dotNetMXSValue modifier
							newModifierNode.imageIndex = newModifierNode.selectedImageIndex = hvkDestruction_getIconIndexForDestructionModifier modifier

							-- For each object, highlight the currently linked modifier in ITALICS (we have to add some empty spaces to the display text
							-- to avoid the actual text getting truncated.
							if ( hkdShapeModifier != undefined ) then
							(
								if ( modifier == hkdShapeModifier.fractureHkUnique OR modifier == hkdShapeModifier.dynamicFracture ) then
								(
									newModifierNode.Text     = newModifierNode.Text + "        "
									newModifierNode.NodeFont = italicFont
								)
							)
							else if ( hkdBodyModifier != undefined ) then
							(
								if ( modifier == hkdBodyModifier.controllerHkUnique ) then
								(
									newModifierNode.Text     = newModifierNode.Text + "        "
									newModifierNode.NodeFont = italicFont
								)
							)
						)
					)

					newObjectNode.Expand()
				)
			)
		)

		on selectionWindow open do
		(
			initialWindowWidth  = selectionWindow.width
			initialWindowHeight = selectionWindow.height

			treeViewOffsetX = initialWindowWidth - treeView.width

			resizeGuiElements initialWindowWidth initialWindowHeight
			
			fillTreeView()

			treeView.Sort()
			
			if ( treeView.SelectedNode == undefined ) then
			(
				btSelect.enabled = false
			)
		)

		on selectionWindow resized newSize do
		(
			resizeGuiElements newSize[1] newSize[2]
		)

		-- Enable/Disable SELECT button depending on what treeview entry is currently selected.
		on treeView AfterSelect arg do
		(
			hitNode = arg.node
			if ( hitNode != undefined ) then
			(
				superClassString = superClassOf(hitNode.tag.value) as string
				if ( superClassString == "modifier" ) then
				(
					btSelect.enabled = true
				)
				else
				(
					btSelect.enabled = false
				)
			)
		)

		-- Return DCed modifier and close selection window.
		on treeView DoubleClick arg do
		(
			-- Only allow DCing if pointer hovers above the currently highlighted treeview entry.
			if ( treeView.SelectedNode != undefined ) then
			(
				hitNode = treeView.GetNodeAt (dotNetObject "System.Drawing.Point" arg.x arg.y)
				if ( hitNode == treeView.SelectedNode ) do
				(
					superClassString = superClassOf(hitNode.tag.value) as string
					if ( superClassString == "modifier" ) then
					(
						g_selectedModifier = hitNode.tag.value
						destroyDialog selectionWindow
					)
				)
			)
		)

		-- Return the currently selected, valid modifier and close the selection window.
		on btSelect pressed do
		(
			-- Although we should never get here with no valid selected modifier, we will leave
			-- this safety check in... just in case.
			if ( treeView.SelectedNode != undefined ) then
			(
				g_selectedModifier = treeView.SelectedNode.Tag.Value
			)
			else
			(
				g_selectedModifier = undefined
			)
			destroyDialog selectionWindow
		)

		-- Collapse All nodes.
		on btCollapseAll pressed do
		(
			treeView.CollapseAll()
		)

		-- Un-Collapse All nodes.
		on btUnCollapseAll pressed do
		(
			for node in treeViewRootNodes do
			(
				node.Expand()
			)
		)

		-- Return UNDEFINED and close the selection windows.
		on btCancel pressed do
		(
			g_selectedModifier = undefined
			destroyDialog selectionWindow
		)
	)

	if ( selection.count != 1 ) then
	(
		messagebox("This only works with exactly *one* selected object.")
		return -1
	)

	createdialog selectionWindow 600 500 modal:true lockWidth:false style:#(#style_titlebar, #style_border, #style_resizing, #style_minimizebox, #style_maximizebox, #style_sysmenu)

	-- If user has selected a valid modifier and if that modifier is not on the currently selected node's modifier stack,
	-- we will add it to the stack. In either case we return the selected modifier.
	if ( g_selectedModifier != undefined ) then
	(
		modifierAlreadyOnStack = false

		for modifier in selection[1].modifiers do
		(
			if ( modifier == g_selectedModifier ) then
			(
				modifierAlreadyOnStack = true
				exit
			)
		)

		if ( modifierAlreadyOnStack == false ) then
		(
			addModifier selection[1] g_selectedModifier
		)

		return g_selectedModifier
	)
	else
	(
		return -1
	)
)


