
------------------------------------------------------------------------------
-- EXTERNAL METHODS & DATA
------------------------------------------------------------------------------


------------------------------------------------------------------------------
-- LOCAL METHODS & DATA
------------------------------------------------------------------------------

global hkModifierUtilityFloater = undefined
global g_sourceNodeAndModifierRollout
global g_targetNodesAndModifierRollout

function hkIsModifierOfClassOnNodeStack classIn nodeIn =
(
	for modifier in nodeIn.modifiers do
	(
		class = hkGetModifierClassAsString(modifier)
		if ( class == classIn ) then return true
	)

	return false
)



function hkIsModifierOnNodeStack modifierIn nodeIn =
(
	for modifier in nodeIn.modifiers do
	(
		if ( modifier == modifierIn ) then return true
	)

	return false
)



rollout sourceNodeAndModifierRollout "Source"
(
	label lineBreak0 height:2

	local sourceNode = undefined
	edittext textSourceNode "Source Node :" text:" No Source Node selected " align:#center readonly:true labelOnTop:true enabled:false

	button buttonSetSourceFromSelection "Use Selection"   width:120 align:#left  tooltip:"Use the currently selected node as source." across:2
	button buttonPickSourceFromScene    "Pick from Scene" width:120 align:#right tooltip:"Pick source node from scene." 

	label lineBreak1 height:2

	multilistbox listboxSourceModifiers "Modifiers :" height:7 enabled:false

	label lineBreak2 height:2

	button buttonCopyToAll           "Copy to all"           width:120 enabled:false align:#left  tooltip:"Add a copy of each selected modifier to each Target Node." across:2
	button buttonInstanceToAll       "Instance to all"       width:120 enabled:false align:#right tooltip:"Share each selected modifier with each Target Node."
	button buttonCopyWhereNew        "Copy where new"        width:120 enabled:false align:#left  tooltip:"Add a copy of each selected modifier to each Target Node that does not yet have a modifier of the same class on its stack." across:2
	button buttonInstanceWhereNew    "Instance where new"    width:120 enabled:false align:#right tooltip:"Share each selected modifier with each Target Node that does not yet have a modifier of the same class on its stack."
	button buttonReplaceWithCopy     "Replace with copy"     width:120 enabled:false align:#left  tooltip:"Replace any occurence of modifiers of the same class on each Target Node with a copy of each corresponding selected modifier." across:2
	button buttonReplaceWithInstance "Replace with instance" width:120 enabled:false align:#right tooltip:"Replace any occurence of modifiers of the same class on each Target Node with a shared instance of each corresponding selected modifier."

	label lineBreak3 height:2



	function updateSetSourceFromSelectionButton =
	(
		if ( selection.count == 1 ) then
		(
			buttonSetSourceFromSelection.enabled = true
		)
		else
		(
			buttonSetSourceFromSelection.enabled = false
		)
	)

	function updateSourceNodeDisplay =
	(
		-- Clear source modifiers list.
		listboxSourceModifiers.items = #()

		if ( sourceNode == undefined ) then
		(
			textSourceNode.text = "No Source Node selected "
		)
		else
		(
			textSourceNode.enabled         = true
			listboxSourceModifiers.enabled = true

			textSourceNode.text = sourceNode.name

			-- Fill source modifiers list with modifiers on the source node.
			for modifier in sourceNode.modifiers do
			(
				append listboxSourceModifiers.items modifier.name
			)
		)

		-- HACK: need to force refresh of the MultiListBox's display
		listboxSourceModifiers.items = listboxSourceModifiers.items

		-- Make sure the source node is not in the target nodes array (for consistency reasons)
		g_targetNodesAndModifierRollout.removeSourceNodeFromTargetNodes()

		-- Redraw Target Nodes ListBox (and remove the new Source Node if need be)
		g_targetNodesAndModifierRollout.updateTargetNodesDisplay()
	)

	function updateCommandButtons =
	(
		selectedSourceModifiers = (listboxSourceModifiers.selection as array)

		-- Only enable buttons if we have at least one source modifier selected and if
		-- there's at least one target node available
		if ( selectedSourceModifiers.count > 0                                    AND 
		     g_targetNodesAndModifierRollout.listboxTargetNodes != undefined      AND 
			 g_targetNodesAndModifierRollout.listboxTargetNodes.items.count > 0 ) then
		(
			buttonCopyToAll          .enabled = true
			buttonCopyWhereNew       .enabled = true
			buttonReplaceWithCopy    .enabled = true
			buttonInstanceToAll      .enabled = true
			buttonInstanceWhereNew   .enabled = true
			buttonReplaceWithInstance.enabled = true
		)
		else
		(
			buttonCopyToAll          .enabled = false
			buttonCopyWhereNew       .enabled = false
			buttonReplaceWithCopy    .enabled = false
			buttonInstanceToAll      .enabled = false
			buttonInstanceWhereNew   .enabled = false
			buttonReplaceWithInstance.enabled = false
		)
	)

	function nodeRenamedCallback =
	(
		if ( sourceNode != undefined ) then
		(
			textSourceNode.text = sourceNode.name
		)
	)

	function systemResetCallback =
	(
		sourceNode = undefined
		updateSourceNodeDisplay()
	)

	function nodeDeletedCallback =
	(
		nodeToBeDeleted = callbacks.notificationParam()
		if ( nodeToBeDeleted == sourceNode ) then
		(
			sourceNode = undefined
			updateSourceNodeDisplay()
		)
	)

	on buttonSetSourceFromSelection pressed do
	(
		if ( selection.count != 1 ) then return false -- safety abort. shouldn't happen.
		sourceNode = selection[1]
		updateSourceNodeDisplay()
	)

	on buttonPickSourceFromScene pressed do
	(
		node = selectByName title:"Select a Source Node" showHidden:true single:true
		if ( node != undefined ) then
		(
			sourceNode = node
			updateSourceNodeDisplay()
		)
	)



	on g_sourceNodeAndModifierRollout open do
	(
		updateSetSourceFromSelectionButton()
	)

	on listboxSourceModifiers selected value do
	(
		updateCommandButtons()
	)



	on buttonCopyToAll pressed do
	(
		selectedSourceModifiers_indexArray = (listboxSourceModifiers.selection as array)

		if ( selectedSourceModifiers_indexArray.count == 0 ) then return false -- safety abort. shouldn't happen.

		-- Add copies of all selected source modifiers to all available target nodes.
		undo on
		(
			for ssmIndex = selectedSourceModifiers_indexArray.count to 1 by -1 do
			(
				sourceModifier = sourceNode.modifiers[selectedSourceModifiers_indexArray[ssmIndex]]

				for targetNode in g_targetNodesAndModifierRollout.targetNodesArray do
				(
					modifierCopy = copy sourceModifier
					addModifier targetNode modifierCopy
				)
			)
		)
	)

	on buttonCopyWhereNew pressed do
	(
		selectedSourceModifiers_indexArray = (listboxSourceModifiers.selection as array)

		if ( selectedSourceModifiers_indexArray.count == 0 ) then return false -- safety abort. shouldn't happen.

		-- Add copies of all selected source modifiers to all available target nodes where there is no modifier of the same class yet.
		undo on
		(
			for ssmIndex = selectedSourceModifiers_indexArray.count to 1 by -1 do
			(
				sourceModifier      = sourceNode.modifiers[selectedSourceModifiers_indexArray[ssmIndex]]
				sourceModifierClass = hkGetModifierClassAsString(sourceModifier)

				for targetNode in g_targetNodesAndModifierRollout.targetNodesArray do
				(
					if ( (hkIsModifierOfClassOnNodeStack sourceModifierClass targetNode) == false ) then
					(
						modifierCopy = copy sourceModifier
						addModifier targetNode modifierCopy
					)
				)
			)
		)
	)

	on buttonReplaceWithCopy pressed do
	(
		selectedSourceModifiers_indexArray = (listboxSourceModifiers.selection as array)

		if ( selectedSourceModifiers_indexArray.count == 0 ) then return false -- safety abort. shouldn't happen.

		-- Replace all existing modifiers of the selected types with new copies.
		undo on
		(
			for ssmIndex in selectedSourceModifiers_indexArray do
			(
				sourceModifier      = sourceNode.modifiers[ssmIndex]
				sourceModifierClass = hkGetModifierClassAsString(sourceModifier)

				for targetNode in g_targetNodesAndModifierRollout.targetNodesArray do
				(
					for modifierPosOnStack = 1 to targetNode.modifiers.count do
					(
						modifier      = targetNode.modifiers[modifierPosOnStack]
						modifierClass = hkGetModifierClassAsString(modifier)
	
						if ( modifierClass == sourceModifierClass ) then
						(
							modifierCopy = copy sourceModifier
							addModifier targetNode modifierCopy before:modifierPosOnStack 
							deleteModifier targetNode modifier
						)
					)
				)
			)
		)
	)

	on buttonInstanceToAll pressed do
	(
		selectedSourceModifiers_indexArray = (listboxSourceModifiers.selection as array)

		if ( selectedSourceModifiers_indexArray.count == 0 ) then return false -- safety abort. shouldn't happen.

		-- Share all selected source modifiers with all available target nodes.
		undo on
		(
			for ssmIndex = selectedSourceModifiers_indexArray.count to 1 by -1 do
			(
				sourceModifier = sourceNode.modifiers[selectedSourceModifiers_indexArray[ssmIndex]]

				for targetNode in g_targetNodesAndModifierRollout.targetNodesArray do
				(
					if ( ( findItem targetNode.modifiers sourceModifier ) == 0 ) then
					(
						addModifier targetNode sourceModifier
					)
				)
			)
		)
	)

	on buttonInstanceWhereNew pressed do
	(
		selectedSourceModifiers_indexArray = (listboxSourceModifiers.selection as array)

		if ( selectedSourceModifiers_indexArray.count == 0 ) then return false -- safety abort. shouldn't happen.

		-- Share each selected source modifier with all available target nodes where there is no modifier of the same class yet.
		undo on
		(
			for ssmIndex = selectedSourceModifiers_indexArray.count to 1 by -1 do
			(
				sourceModifier      = sourceNode.modifiers[selectedSourceModifiers_indexArray[ssmIndex]]
				sourceModifierClass = hkGetModifierClassAsString(sourceModifier)

				for targetNode in g_targetNodesAndModifierRollout.targetNodesArray do
				(
					if ( (hkIsModifierOfClassOnNodeStack sourceModifierClass targetNode) == false ) then
					(
						addModifier targetNode sourceModifier
					)
				)
			)
		)
	)

	on buttonReplaceWithInstance pressed do
	(
		selectedSourceModifiers_indexArray = (listboxSourceModifiers.selection as array)

		if ( selectedSourceModifiers_indexArray.count == 0 ) then return false -- safety abort. shouldn't happen.

		-- Replace all existing modifiers of the selected types with instances of the selected ones.
		undo on
		(
			for ssmIndex in selectedSourceModifiers_indexArray do
			(
				sourceModifier      = sourceNode.modifiers[ssmIndex]
				sourceModifierClass = hkGetModifierClassAsString(sourceModifier)

				for targetNode in g_targetNodesAndModifierRollout.targetNodesArray do
				(
					for modifierPosOnStack = 1 to targetNode.modifiers.count do
					(
						modifier      = targetNode.modifiers[modifierPosOnStack]
						modifierClass = hkGetModifierClassAsString(modifier)
	
						if ( modifierClass == sourceModifierClass AND modifier != sourceModifier ) then
						(
							addModifier targetNode sourceModifier before:modifierPosOnStack 
							deleteModifier targetNode modifier
						)
					)
				)
			)
		)
	)
)





rollout targetNodesAndModifierRollout "Target(s)"
(
	label linbeBreak0 height:2

	local targetNodesArray = #()
	listbox listboxTargetNodes "Target Nodes :" height:7 readOnly:true enabled:false

	button buttonSetTargetsFromSelection "Use Selection"   align:#left  width:120 tooltip:"Use the currently selected nodes as targets." across:2
	button buttonPickTargetsFromScene    "Pick from Scene" align:#right width:120 tooltip:"Pick target nodes from scene."

	label linbeBreak1 height:2

	local targetModifiersArray = #()
	multilistbox listboxTargetModifiers "Modifiers :" height:7 enabled:false

	radiobuttons radiobuttonsModifierDisplayType "Display :" labels:#("All modifiers", "All modifiers, grouped by class", "Same class modifiers available on all Targets", "Shared modifiers only") align:#left enabled:false
	local displayTypeId_all        = 1
	local displayTypeId_allGrouped = 2
	local displayTypeId_sameClass  = 3
	local displayTypeId_shared     = 4

	label linbeBreak2 height:2

	button buttonShowInModifierPanel                     "Show in Modifier Panel"   width:244 enabled:false tooltip:"Shows the selected modifier in the 3ds Max Modifier Panel."
	button buttonRemoveModifiers                         "Remove"                   width:244 enabled:false tooltip:"Removes the selected modifiers from the Target Nodes."
	button buttonReplaceModifiersOfSameClassWithInstance "Replace with instance(s)" width:244 enabled:false tooltip:"Replaces all selected modifiers on the Target Nodes with a shared instance respectively."
	button buttonMakeModifiersUnique                     "Make unique"              width:244 enabled:false tooltip:"Makes all selected shared modifiers unique."
	button buttonSetSelectionFromTargetModifiers         "Set selection"            width:244 enabled:false tooltip:"Scene-selects all Target Nodes that have the selected Target Modifiers."

	label linbeBreak3 height:2



	function updateTargetNodesDisplay =
	(
		listboxTargetNodes.enabled = true

		-- Clear target nodes list.
		listboxTargetNodes.items = #()

		-- Fill target nodes display list.
		for node in targetNodesArray do
		(
			append listboxTargetNodes.items node.name
		)

		-- HACK: need to force refresh of the MultiListBox's display
		listboxTargetNodes.items = listboxTargetNodes.items

		-- Also update the "target modifiers" ListBox.
		g_targetNodesAndModifierRollout.updateTargetModifiersDisplay()

		-- Update the Source Node Command buttons
		g_sourceNodeAndModifierRollout.updateCommandButtons()
	)

	function updateSetTargetsFromSelectionButton =
	(
		if ( selection.count == 0 ) then
		(
			buttonSetTargetsFromSelection.enabled = false
		)
		else
		(
			buttonSetTargetsFromSelection.enabled = true
		)
	)

	function removeSourceNodeFromTargetNodes =
	(
		sourceNodeInTargetArray_index = findItem targetNodesArray g_sourceNodeAndModifierRollout.sourceNode
		if ( sourceNodeInTargetArray_index != 0 ) then
		(
			deleteItem targetNodesArray sourceNodeInTargetArray_index
		)
	)

	function fillTargetModifiersList_typeAll =
	(
		for node in targetNodesArray do
		(
			for modifier in node.modifiers do
			(
				append targetModifiersArray         modifier
				append listboxTargetModifiers.items (node.name + " : " + modifier.name)
			)
		)
	)

	function fillTargetModifiersList_typeAllGrouped =
	(
		for targetNode in targetNodesArray do
		(
			for modifier in targetNode.modifiers do
			(
				-- If modifier is already in ListBox (most likely shared), skip it
				index = findItem targetModifiersArray modifier
				if ( index != 0 ) then continue

				-- Modifier not shared, but maybe one of same class already there?						
				modifierClass = hkGetModifierClassAsString(modifier)
				modifierClassAlreadyDisplayed = false

				for displayedModifier in targetModifiersArray do
				(
					displayedModifierClass = hkGetModifierClassAsString(displayedModifier)
					if ( displayedModifierClass == modifierClass ) then
					(
						modifierClassAlreadyDisplayed = true
						exit
					)
				)

				-- Modifier class not yet displayed in list: add it.
				if ( modifierClassAlreadyDisplayed == false ) then
				(
					append targetModifiersArray         modifier 
					append listboxTargetModifiers.items modifier.name
				)
			)
		)
	)

	function fillTargetModifiersList_typeSameClass =
	(
		referenceTargetNode = targetNodesArray[1]
		for referenceModifier in referenceTargetNode.modifiers do
		(
			referenceModifierClass        = hkGetModifierClassAsString(referenceModifier)
			modifierFoundOnAllTargetNodes = true

			for targetNode in targetNodesArray do
			(
				if ( (hkIsModifierOfClassOnNodeStack referenceModifierClass targetNode) == false ) then
				(
					modifierFoundOnAllTargetNodes = false
					exit
				)
			)

			if ( modifierFoundOnAllTargetNodes == true ) then
			(
				append targetModifiersArray         referenceModifier 
				append listboxTargetModifiers.items referenceModifier.name
			)
		)
	)

	function fillTargetModifiersList_typeShared =
	(
		referenceTargetNode = targetNodesArray[1]

		for referenceModifier in referenceTargetNode.modifiers do
		(
			modifierFoundOnAllTargetNodes = true

			for targetNode in targetNodesArray do
			(
				if ( (hkIsModifierOnNodeStack referenceModifier targetNode) == false ) then
				(
					modifierFoundOnAllTargetNodes = false
					exit
				)
			)

			if ( modifierFoundOnAllTargetNodes == true ) then
			(
				append targetModifiersArray         referenceModifier 
				append listboxTargetModifiers.items referenceModifier.name
			)
		)
	)

	function updateTargetModifiersDisplay =
	(
		targetModifiersArray         = #()
		listboxTargetModifiers.items = #()

		if ( targetNodesArray.count == 0 ) then return false

		listboxTargetModifiers.enabled          = true
		radiobuttonsModifierDisplayType.enabled = true

		if ( radiobuttonsModifierDisplayType.state == displayTypeId_all ) then
		(
			fillTargetModifiersList_typeAll()
		)
		else if ( radiobuttonsModifierDisplayType.state == displayTypeId_allGrouped ) then
		(
			fillTargetModifiersList_typeAllGrouped()
		)
		else if ( radiobuttonsModifierDisplayType.state == displayTypeId_sameClass ) then
		(
			fillTargetModifiersList_typeSameClass()
		)
		else if ( radiobuttonsModifierDisplayType.state == displayTypeId_shared ) then
		(
			fillTargetModifiersList_typeShared()
		)

		-- HACK: need to force refresh of the MultiListBox's display
		listboxTargetModifiers.items = listboxTargetModifiers.items
	)

	function areSelectedTargetModifiersOfSameType =
	(
		selectedTargetModifiers_indexArray = (listboxTargetModifiers.selection as array)

		-- Use the first selected target modifier as reference. Any would do as we require them all to be identical anyways.
		referenceModifierClass = hkGetModifierClassAsString(targetModifiersArray[1])

		for stmIndex in selectedTargetModifiers_indexArray do
		(
			selectedTargetModifier      = targetModifiersArray[stmIndex]
			selectedTargetModifierClass = hkGetModifierClassAsString(selectedTargetModifier)

			if ( selectedTargetModifierClass != referenceModifierClass ) then return false
		)

		return true
	)

	function updateCommandButtons =
	(
		selectedTargetModifiers = (listboxTargetModifiers.selection as array)
		
		if ( selectedTargetModifiers.count > 0 ) then
		(
			-- "Show In Modifier Panel" only works on unambiguous modifiers, i.e. either unique ones or shared ones. Result would
			-- be undefined for modifiers selected by class alone.
			if ( selectedTargetModifiers.count == 1 AND
		       ( radiobuttonsModifierDisplayType.state == displayTypeId_all OR radiobuttonsModifierDisplayType.state == displayTypeId_shared ) ) then
			(
				buttonShowInModifierPanel.enabled = true
			)
			else
			(
				buttonShowInModifierPanel.enabled = false
			)

			buttonRemoveModifiers.enabled = true

			if ( (radiobuttonsModifierDisplayType.state == displayTypeId_all AND selectedTargetModifiers.count  > 1 AND areSelectedTargetModifiersOfSameType() == true) OR
			     (radiobuttonsModifierDisplayType.state != displayTypeId_all AND selectedTargetModifiers.count == 1 ) ) then
			(
				buttonReplaceModifiersOfSameClassWithInstance.enabled = true
			)
			else
			(
				buttonReplaceModifiersOfSameClassWithInstance.enabled = false
			)
			
			if ( radiobuttonsModifierDisplayType.state != displayTypeId_all ) then
			(
				buttonMakeModifiersUnique.enabled = true
			)
			else
			(
				buttonMakeModifiersUnique.enabled = false
			)

			buttonSetSelectionFromTargetModifiers.enabled = true
		)
		else
		(
			buttonShowInModifierPanel                    .enabled = false
			buttonRemoveModifiers                        .enabled = false
			buttonReplaceModifiersOfSameClassWithInstance.enabled = false
			buttonMakeModifiersUnique                    .enabled = false
			buttonSetSelectionFromTargetModifiers        .enabled = false
		)
	)

	function nodeDeletedCallback =
	(
		nodeToBeDeleted = callbacks.notificationParam()
		indexInTargetNodesArray = findItem targetNodesArray nodeToBeDeleted

		if ( indexInTargetNodesArray != 0 ) then
		(
			deleteItem targetNodesArray indexInTargetNodesArray
			updateTargetNodesDisplay()
		)
	)

	function nodeRenamedCallback =
	(
		updateTargetNodesDisplay()
	)

	function systemResetCallback =
	(
		targetNodesArray = #()
		updateTargetNodesDisplay()
	)



	on g_targetNodesAndModifierRollout open do
	(
		updateSetTargetsFromSelectionButton()
	)

	on buttonSetTargetsFromSelection pressed do
	(
		if ( selection.count == 0 ) then return false -- safety abort. shouldn't happen.

		-- Make a copy of the current selection.
		targetNodesArray = #()
		join targetNodesArray $selection

		-- Make sure Source Node (if set) is not part of the Target Nodes.
		removeSourceNodeFromTargetNodes()

		-- Fill Target Nodes display list.
		updateTargetNodesDisplay()
	)

	on buttonPickTargetsFromScene pressed do
	(
		nodes = selectByName title:"Select one or more Target Nodes" showHidden:true single:false
		if ( nodes != undefined ) then
		(
			targetNodesArray = #()
			join targetNodesArray nodes
			removeSourceNodeFromTargetNodes()
			updateTargetNodesDisplay()
		)
	)

	on listboxTargetModifiers selected value do
	(
		updateCommandButtons()
	)

	on radiobuttonsModifierDisplayType changed selected do
	(
		updateTargetModifiersDisplay()
		updateCommandButtons()
	)

	on buttonShowInModifierPanel pressed do
	(
		selectedTargetModifiers_indexArray = (listboxTargetModifiers.selection as array)

		if ( selectedTargetModifiers_indexArray.count != 1 ) then return false -- safety abort. shouldn't happen.

		undo on
		(
			selectedTargetModifier = targetModifiersArray[selectedTargetModifiers_indexArray[1]]
			modPanel.setCurrentObject selectedTargetModifier ui:true
		)
	)

	on buttonRemoveModifiers pressed do
	(
		selectedTargetModifiers_indexArray = (listboxTargetModifiers.selection as array)

		if ( selectedTargetModifiers_indexArray.count == 0 ) then return false -- safety abort. shouldn't happen.

		undo on
		(
			if ( radiobuttonsModifierDisplayType.state == displayTypeId_all OR radiobuttonsModifierDisplayType.state == displayTypeId_shared ) then
			(
				for stmArrayIndex = selectedTargetModifiers_indexArray.count to 1 by -1 do
				(
					stmIndex               = selectedTargetModifiers_indexArray[stmArrayIndex]
					selectedTargetModifier = targetModifiersArray[stmIndex]
					for targetNode in targetNodesArray do
					(
						if ( findItem targetNode.modifiers selectedTargetModifier != 0 ) then
						(
							deleteModifier targetNode selectedTargetModifier
						)
					)
				)
			)
			else if ( radiobuttonsModifierDisplayType.state == displayTypeId_sameClass OR radiobuttonsModifierDisplayType.state == displayTypeId_allGrouped ) then
			(
				for stmArrayIndex = selectedTargetModifiers_indexArray.count to 1 by -1 do
				(
					stmIndex                    = selectedTargetModifiers_indexArray[stmArrayIndex]
					selectedTargetModifier      = targetModifiersArray[stmIndex]
					selectedTargetModifierClass = hkGetModifierClassAsString(selectedTargetModifier)
					for targetNode in targetNodesArray do
					(
						for modifier in targetNode.modifiers do
						(
							modifierClass = hkGetModifierClassAsString(modifier)
							if ( modifierClass == selectedTargetModifierClass ) then
							(
								deleteModifier targetNode modifier
							)
						)
					)
				)
			)
		)

		updateTargetModifiersDisplay()
		updateCommandButtons()
	)

	on buttonReplaceModifiersOfSameClassWithInstance pressed do
	(
		if ( radiobuttonsModifierDisplayType.state == displayTypeId_shared ) then return false -- safety abort. shouldn't happen.

		selectedTargetModifiers_indexArray = (listboxTargetModifiers.selection as array)

		if ( selectedTargetModifiers_indexArray.count == 0     ) then return false -- safety abort. shouldn't happen.
		if ( areSelectedTargetModifiersOfSameType()   == false ) then return false -- safety abort. shouldn't happen.

		undo on
		(
			-- We can access entry #1 because we either have exactly one selected (!ALL display mode)
			-- or we have more than one but of same class (ALL display mode)
			referenceTargetModifier      = targetModifiersArray[selectedTargetModifiers_indexArray[1]]
			referenceTargetModifierClass = hkGetModifierClassAsString(referenceTargetModifier)

			for targetNode in targetNodesArray do
			(
				for modifierPosOnStack = 1 to targetNode.modifiers.count do
				(
					modifier      = targetNode.modifiers[modifierPosOnStack]
					modifierClass = hkGetModifierClassAsString(modifier)

					if ( modifierClass == referenceTargetModifierClass ) then
					(
						if ( modifier != referenceTargetModifier ) then
						(
							addModifier targetNode referenceTargetModifier before:modifierPosOnStack 
							deleteModifier targetNode modifier
						)
					)
				)
			)
		)

		updateTargetModifiersDisplay()
		updateCommandButtons()
	)

	on buttonMakeModifiersUnique pressed do
	(
		if ( radiobuttonsModifierDisplayType.state == displayTypeId_all ) then return false -- safety abort. shouldn't happen.

		selectedTargetModifiers_indexArray = (listboxTargetModifiers.selection as array)

		if ( selectedTargetModifiers_indexArray.count == 0 ) then return false -- safety abort. shouldn't happen.

		undo on
		(
			for stmArrayIndex = selectedTargetModifiers_indexArray.count to 1 by -1 do
			(
				stmIndex                    = selectedTargetModifiers_indexArray[stmArrayIndex]
				selectedTargetModifier      = targetModifiersArray[stmIndex]
				selectedTargetModifierClass = hkGetModifierClassAsString(selectedTargetModifier)

				for targetNode in targetNodesArray do
				(
					for modifierPosOnStack = 1 to targetNode.modifiers.count do
					(
						modifier      = targetNode.modifiers[modifierPosOnStack]
						modifierClass = hkGetModifierClassAsString(modifier)

						if ( modifierClass == selectedTargetModifierClass ) then
						(
							modifierClone = copy modifier
							addModifier targetNode modifierClone before:modifierPosOnStack 
							deleteModifier targetNode modifier
						)
					)
				)
			)
		)
	)

	on buttonSetSelectionFromTargetModifiers pressed do
	(
		selectedTargetModifiers_indexArray = (listboxTargetModifiers.selection as array)

		undo on
		(
			if ( radiobuttonsModifierDisplayType.state == displayTypeId_sameClass OR radiobuttonsModifierDisplayType.state == displayTypeId_shared ) then
			(
				select targetNodesArray
			)
			else if ( radiobuttonsModifierDisplayType.state == displayTypeId_allGrouped ) then
			(
				newSelection = #()

				for stmIndex in selectedTargetModifiers_indexArray do
				(
					selectedTargetModifier      = targetModifiersArray[stmIndex]
					selectedTargetModifierClass = hkGetModifierClassAsString(selectedTargetModifier)

					for targetNode in targetNodesArray do
					(
						for modifier in targetNode.modifiers do
						(
							modifierClass = hkGetModifierClassAsString(modifier)

							if ( modifierClass == selectedTargetModifierClass ) then
							(
								append newSelection targetNode
								exit
							)
						)
					)
				)

				select newSelection
			) 
			else if ( radiobuttonsModifierDisplayType.state == displayTypeId_all ) then
			(
				newSelection = #()

				for stmIndex in selectedTargetModifiers_indexArray do
				(
					selectedTargetModifier = targetModifiersArray[stmIndex]

					for targetNode in targetNodesArray do
					(
						for modifier in targetNode.modifiers do
						(
							if ( modifier == selectedTargetModifier ) then
							(
								append newSelection targetNode
								exit
							)
						)
					)
				)

				select newSelection
			)
		)
	)
)



function selectionChangedCallback =
(
	if ( hkModifierUtilityFloater != undefined ) then
	(
		g_sourceNodeAndModifierRollout .updateSetSourceFromSelectionButton()
		g_targetNodesAndModifierRollout.updateSetTargetsFromSelectionButton()
	)
)

function nodePreDeleteCallback =
(
	if ( hkModifierUtilityFloater != undefined ) then
	(
		g_sourceNodeAndModifierRollout .nodeDeletedCallback()
		g_targetNodesAndModifierRollout.nodeDeletedCallback()
	)
)

function nodeRenamedCallback =
(
	if ( hkModifierUtilityFloater != undefined ) then
	(
		g_sourceNodeAndModifierRollout .nodeRenamedCallback()
		g_targetNodesAndModifierRollout.nodeRenamedCallback()
	)
)

function sceneResetCallback =
(
	if ( hkModifierUtilityFloater != undefined ) then
	(
		g_sourceNodeAndModifierRollout .systemResetCallback()
		g_targetNodesAndModifierRollout.systemResetCallback()
	)
)

function modifierAddedOrDeletedCallback =
(
	if ( hkModifierUtilityFloater != undefined ) then
	(
		g_sourceNodeAndModifierRollout .updateSourceNodeDisplay()
		g_targetNodesAndModifierRollout.updateTargetModifiersDisplay()
	)
)



callbacks.addScript #selectionSetChanged "selectionChangedCallback()"
callbacks.addScript #nodePreDelete       "nodePreDeleteCallback()"
callbacks.addScript #nodeRenamed         "nodeRenamedCallback()"
callbacks.addScript #systemPreNew        "sceneResetCallback()"
callbacks.addScript #systemPreReset      "sceneResetCallback()"
callbacks.addScript #filePreOpen         "sceneResetCallback()"
callbacks.addScript #postModifierAdded   "modifierAddedOrDeletedCallback()"
callbacks.addScript #postModifierDeleted "modifierAddedOrDeletedCallback()"
callbacks.addScript #sceneUndo           "modifierAddedOrDeletedCallback()"
callbacks.addScript #sceneRedo           "modifierAddedOrDeletedCallback()"



------------------------------------------------------------------------------
-- GLOBAL METHODS & DATA
------------------------------------------------------------------------------

mapped function hvkModifierUtility =
(
	global hkModifierUtilityFloater

	if (hkModifierUtilityFloater == undefined) OR (hkModifierUtilityFloater.open == false) then
	(
		hkModifierUtilityFloater = NewRolloutFloater "Havok Modifier Utility" 280 838

		cui.RegisterDialogBar hkModifierUtilityFloater style:#(#cui_dock_left, #cui_dock_right, #cui_floatable, #cui_handles, #cui_max_sized) minSize:[286,-1] maxSize:[286,-1]
		cui.dockDialogBar     hkModifierUtilityFloater #cui_dock_left

		addRollout sourceNodeAndModifierRollout  hkModifierUtilityFloater rolledUp:false
		addRollout targetNodesAndModifierRollout hkModifierUtilityFloater rolledUp:false

		g_sourceNodeAndModifierRollout  = sourceNodeAndModifierRollout
		g_targetNodesAndModifierRollout = targetNodesAndModifierRollout
	)
	else if (hkModifierUtilityFloater != undefined) then
	(
		cui.FloatDialogBar      hkModifierUtilityFloater
		cui.UnRegisterDialogBar hkModifierUtilityFloater 
		closeRolloutFloater     hkModifierUtilityFloater
	)
)

--hvkModifierUtility()
