
------------------------------------------------------------------------------
-- EXTERNAL METHODS
------------------------------------------------------------------------------

global hvkDestruction_createGenericModifier


------------------------------------------------------------------------------
-- LOCAL METHODS
------------------------------------------------------------------------------

function hvkDestructionDialog_uniqueOrSharedInfo reqTitle =
(
	global returnValue = -1
	
	rollout requester reqTitle
	(
		label _label1 "You can create individual Infos for all objects in the"         align:#left
		label _label2 "selection (UNIQUE) or you can create one single Info modifier"  align:#left
		label _label3 "that is being shared between all selected objects (SHARED)."    align:#left
		label _label4 ""
		
		button reqButton1 "Unique" width:80 across:3
		button reqButton2 "Shared" width:80
		button reqButton3 "Cancel" width:80
		
		on reqButton1 pressed do
		(
			DestroyDialog requester
			returnValue = 0
		)

		on reqButton2 pressed do
		(
			DestroyDialog requester
			returnValue = 1
		)

		on reqButton3 pressed do
		(
			DestroyDialog requester
			returnValue = 2
		)
	)

	createDialog requester 350 110 modal:true
	
	return returnValue
)


------------------------------------------------------------------------------
-- GLOBAL METHODS
------------------------------------------------------------------------------

function hvkDestruction_createNewInfo infoCtor requesterTitle =
(
	--//
	--//  No node selected:
	--//  o create a dummy node
	--//  o add new Info modifier to dummy node
	--//  o switch to Info modifier
	--//
	if ( selection.count == 0 ) then
	(
		infoHelper           = dummy()
		infoHelper.boxsize.x = 0
		infoHelper.boxsize.y = 0
		infoHelper.boxsize.z = 0
		infoHelper.name      = uniqueName (infoCtor as string)

		hvkDestruction_createGenericModifier infoHelper infoCtor
		select(infoHelper)
		setCommandPanelTaskMode mode:#modify
	)
	else
	(
		creationType       = 0        --// 0 = unique, 1 = shared, 2 = cancel
		sharedInfoModifier = undefined  --// This holds the shared Info modifier. 'Undefined' if user selects to create unique Info modifiers or if selection.count == 1.

		--// Only query for 'shared' if more than one node is in selection.
		if ( selection.count > 1 ) then
		(
			creationType = hvkDestructionDialog_uniqueOrSharedInfo requesterTitle

			--// Share Fracture modifier.
			if ( creationType == 1 ) then
			(
				sharedInfoModifier = infoCtor()
			)
			--// User abort...
			else if ( creationType == 2 ) then
			(
				return false
			)
		)

		--// Process all selected nodes/meshes.
		for node in selection do
		(
			--//
			--// Either create & add a new unique modifier or only add the shared modifier.
			--//
			if ( creationType == 0 ) then --// unique
			(
				hvkDestruction_createGenericModifier node infoCtor
			)
			else --// shared
			(
				addModifier node sharedInfoModifier
			)
		)

		select selection[1]
		setCommandPanelTaskMode mode:#modify
	)
)
